/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote.recovery;

import java.util.Set;
import javax.transaction.xa.Xid;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.recovery.RecoveryCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TxCompletionNotificationCommand
extends RecoveryCommand
implements TopologyAffectedCommand {
    private static Log log = LogFactory.getLog(TxCompletionNotificationCommand.class);
    public static final int COMMAND_ID = 22;
    private Xid xid;
    private long internalId;
    private GlobalTransaction gtx;
    private TransactionTable txTable;
    private LockManager lockManager;
    private StateTransferManager stateTransferManager;
    private int topologyId = -1;

    private TxCompletionNotificationCommand() {
        super(null);
    }

    public TxCompletionNotificationCommand(Xid xid, GlobalTransaction gtx, String cacheName) {
        super(cacheName);
        this.xid = xid;
        this.gtx = gtx;
    }

    public void init(TransactionTable tt, LockManager lockManager, RecoveryManager rm2, StateTransferManager stm) {
        super.init(rm2);
        this.txTable = tt;
        this.lockManager = lockManager;
        this.stateTransferManager = stm;
    }

    public TxCompletionNotificationCommand(long internalId, String cacheName) {
        super(cacheName);
        this.internalId = internalId;
    }

    public TxCompletionNotificationCommand(String cacheName) {
        super(cacheName);
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        log.tracef("Processing completed transaction %s", (Object)this.gtx);
        RemoteTransaction remoteTx = null;
        if (this.recoveryManager != null) {
            remoteTx = this.xid != null ? (RemoteTransaction)((Object)this.recoveryManager.removeRecoveryInformation(this.xid)) : (RemoteTransaction)((Object)this.recoveryManager.removeRecoveryInformation(this.internalId));
        }
        if (remoteTx == null && this.gtx != null) {
            remoteTx = this.txTable.removeRemoteTransaction(this.gtx);
        }
        if (remoteTx == null) {
            return null;
        }
        this.forwardCommandRemotely(remoteTx);
        this.lockManager.unlock(remoteTx.getLockedKeys(), remoteTx.getGlobalTransaction());
        return null;
    }

    public GlobalTransaction getGlobalTransaction() {
        return this.gtx;
    }

    private void forwardCommandRemotely(RemoteTransaction remoteTx) {
        Set<Object> affectedKeys = remoteTx.getAffectedKeys();
        log.tracef("Invoking forward of TxCompletionNotification for transaction %s. Affected keys: %s", (Object)this.gtx, (Object)affectedKeys);
        this.stateTransferManager.forwardCommandIfNeeded(this, affectedKeys, remoteTx.getGlobalTransaction().getAddress(), false);
    }

    @Override
    public byte getCommandId() {
        return 22;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.xid != null ? this.xid : Long.valueOf(this.internalId), this.gtx};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 22) {
            throw new IllegalArgumentException("Wrong command id. Received " + commandId + " and expected " + 22);
        }
        if (parameters[0] instanceof Xid) {
            this.xid = (Xid)parameters[0];
        } else {
            this.internalId = (Long)parameters[0];
        }
        this.gtx = (GlobalTransaction)parameters[1];
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{ xid=" + this.xid + ", internalId=" + this.internalId + ", topologyId=" + this.topologyId + ", gtx=" + this.gtx + ", cacheName=" + this.cacheName + "} ";
    }
}

