/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.util.Util;

public class Average {
    protected final long[] samples;
    protected AtomicInteger index = new AtomicInteger(0);

    public Average() {
        this(64);
    }

    public Average(int size) {
        this.samples = new long[Util.getNextHigherPowerOfTwo(size)];
        for (int i = 0; i < this.samples.length; ++i) {
            this.samples[i] = -1L;
        }
    }

    public void add(long sample) {
        int tmp_index = this.index.getAndIncrement();
        int real_index = tmp_index & this.samples.length - 1;
        this.samples[real_index] = sample;
        if (tmp_index >= this.samples.length) {
            this.index.set(0);
        }
    }

    public double getAverage() {
        int num = 0;
        long total = 0L;
        for (int i = 0; i < this.samples.length; ++i) {
            long sample = this.samples[i];
            if (sample < 0L) continue;
            ++num;
            total += sample;
        }
        return num > 0 ? (double)total / (double)num : 0.0;
    }

    public void clear() {
        for (int i = 0; i < this.samples.length; ++i) {
            this.samples[i] = -1L;
        }
    }

    public String toString() {
        return String.valueOf(this.getAverage());
    }
}

