/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import infinispan.com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.Map;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.SnapshotImpl;
import org.iq80.leveldb.impl.ValueType;
import org.iq80.leveldb.util.AbstractSeekingIterator;
import org.iq80.leveldb.util.DbIterator;
import org.iq80.leveldb.util.Slice;

public final class SnapshotSeekingIterator
extends AbstractSeekingIterator<Slice, Slice> {
    private final DbIterator iterator;
    private final SnapshotImpl snapshot;
    private final Comparator<Slice> userComparator;

    public SnapshotSeekingIterator(DbIterator iterator, SnapshotImpl snapshot, Comparator<Slice> userComparator) {
        this.iterator = iterator;
        this.snapshot = snapshot;
        this.userComparator = userComparator;
        this.snapshot.getVersion().retain();
    }

    public void close() {
        this.snapshot.getVersion().release();
    }

    @Override
    protected void seekToFirstInternal() {
        this.iterator.seekToFirst();
        this.findNextUserEntry(null);
    }

    @Override
    protected void seekInternal(Slice targetKey) {
        this.iterator.seek(new InternalKey(targetKey, this.snapshot.getLastSequence(), ValueType.VALUE));
        this.findNextUserEntry(null);
    }

    @Override
    protected Map.Entry<Slice, Slice> getNextElement() {
        if (!this.iterator.hasNext()) {
            return null;
        }
        Object next = this.iterator.next();
        this.findNextUserEntry(((InternalKey)next.getKey()).getUserKey());
        return Maps.immutableEntry(((InternalKey)next.getKey()).getUserKey(), next.getValue());
    }

    private void findNextUserEntry(Slice deletedKey) {
        if (!this.iterator.hasNext()) {
            return;
        }
        do {
            InternalKey internalKey;
            if ((internalKey = (InternalKey)this.iterator.peek().getKey()).getSequenceNumber() > this.snapshot.getLastSequence()) {
                this.iterator.next();
                continue;
            }
            if (internalKey.getValueType() == ValueType.DELETION) {
                deletedKey = internalKey.getUserKey();
            } else if (internalKey.getValueType() == ValueType.VALUE && (deletedKey == null || this.userComparator.compare(internalKey.getUserKey(), deletedKey) > 0)) {
                return;
            }
            this.iterator.next();
        } while (this.iterator.hasNext());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SnapshotSeekingIterator");
        sb.append("{snapshot=").append(this.snapshot);
        sb.append(", iterator=").append(this.iterator);
        sb.append('}');
        return sb.toString();
    }
}

