/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import infinispan.com.google.common.base.Preconditions;
import infinispan.com.google.common.primitives.Ints;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.MemTable;
import org.iq80.leveldb.impl.SeekingIterator;
import org.iq80.leveldb.util.AbstractSeekingIterator;
import org.iq80.leveldb.util.InternalIterator;
import org.iq80.leveldb.util.InternalTableIterator;
import org.iq80.leveldb.util.LevelIterator;
import org.iq80.leveldb.util.Slice;

public final class DbIterator
extends AbstractSeekingIterator<InternalKey, Slice>
implements InternalIterator {
    private final MemTable.MemTableIterator memTableIterator;
    private final MemTable.MemTableIterator immutableMemTableIterator;
    private final List<InternalTableIterator> level0Files;
    private final List<LevelIterator> levels;
    private final Comparator<InternalKey> comparator;
    private final ComparableIterator[] heap;
    private int heapSize = 0;

    public DbIterator(MemTable.MemTableIterator memTableIterator, MemTable.MemTableIterator immutableMemTableIterator, List<InternalTableIterator> level0Files, List<LevelIterator> levels, Comparator<InternalKey> comparator) {
        this.memTableIterator = memTableIterator;
        this.immutableMemTableIterator = immutableMemTableIterator;
        this.level0Files = level0Files;
        this.levels = levels;
        this.comparator = comparator;
        this.heap = new ComparableIterator[3 + level0Files.size() + levels.size()];
        this.resetPriorityQueue();
    }

    @Override
    protected void seekToFirstInternal() {
        if (this.memTableIterator != null) {
            this.memTableIterator.seekToFirst();
        }
        if (this.immutableMemTableIterator != null) {
            this.immutableMemTableIterator.seekToFirst();
        }
        for (InternalTableIterator level0File : this.level0Files) {
            level0File.seekToFirst();
        }
        for (LevelIterator level : this.levels) {
            level.seekToFirst();
        }
        this.resetPriorityQueue();
    }

    @Override
    protected void seekInternal(InternalKey targetKey) {
        if (this.memTableIterator != null) {
            this.memTableIterator.seek(targetKey);
        }
        if (this.immutableMemTableIterator != null) {
            this.immutableMemTableIterator.seek(targetKey);
        }
        for (InternalTableIterator level0File : this.level0Files) {
            level0File.seek(targetKey);
        }
        for (LevelIterator level : this.levels) {
            level.seek(targetKey);
        }
        this.resetPriorityQueue();
    }

    @Override
    protected Map.Entry<InternalKey, Slice> getNextElement() {
        ComparableIterator replacementElement;
        if (this.heapSize == 0) {
            return null;
        }
        ComparableIterator smallest = this.heap[0];
        Object result = smallest.next();
        if (smallest.hasNext()) {
            replacementElement = smallest;
        } else {
            --this.heapSize;
            replacementElement = this.heap[this.heapSize];
            this.heap[this.heapSize] = null;
        }
        if (replacementElement != null) {
            this.heap[0] = replacementElement;
            this.heapSiftDown(0);
        }
        return result;
    }

    private void resetPriorityQueue() {
        int i = 0;
        this.heapSize = 0;
        if (this.memTableIterator != null && this.memTableIterator.hasNext()) {
            this.heapAdd(new ComparableIterator(this.memTableIterator, this.comparator, i++, this.memTableIterator.next()));
        }
        if (this.immutableMemTableIterator != null && this.immutableMemTableIterator.hasNext()) {
            this.heapAdd(new ComparableIterator(this.immutableMemTableIterator, this.comparator, i++, this.immutableMemTableIterator.next()));
        }
        for (InternalTableIterator level0File : this.level0Files) {
            if (!level0File.hasNext()) continue;
            this.heapAdd(new ComparableIterator(level0File, this.comparator, i++, (Map.Entry)level0File.next()));
        }
        for (LevelIterator level : this.levels) {
            if (!level.hasNext()) continue;
            this.heapAdd(new ComparableIterator(level, this.comparator, i++, (Map.Entry)level.next()));
        }
    }

    private boolean heapAdd(ComparableIterator newElement) {
        Preconditions.checkNotNull(newElement, "newElement is null");
        this.heap[this.heapSize] = newElement;
        this.heapSiftUp(this.heapSize++);
        return true;
    }

    private void heapSiftUp(int childIndex) {
        int parentIndex;
        ComparableIterator parent;
        ComparableIterator target = this.heap[childIndex];
        while (childIndex > 0 && (parent = this.heap[parentIndex = (childIndex - 1) / 2]).compareTo(target) > 0) {
            this.heap[childIndex] = parent;
            childIndex = parentIndex;
        }
        this.heap[childIndex] = target;
    }

    private void heapSiftDown(int rootIndex) {
        int childIndex;
        ComparableIterator target = this.heap[rootIndex];
        while ((childIndex = rootIndex * 2 + 1) < this.heapSize) {
            if (childIndex + 1 < this.heapSize && this.heap[childIndex + 1].compareTo(this.heap[childIndex]) < 0) {
                ++childIndex;
            }
            if (target.compareTo(this.heap[childIndex]) <= 0) break;
            this.heap[rootIndex] = this.heap[childIndex];
            rootIndex = childIndex;
        }
        this.heap[rootIndex] = target;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DbIterator");
        sb.append("{memTableIterator=").append(this.memTableIterator);
        sb.append(", immutableMemTableIterator=").append(this.immutableMemTableIterator);
        sb.append(", level0Files=").append(this.level0Files);
        sb.append(", levels=").append(this.levels);
        sb.append(", comparator=").append(this.comparator);
        sb.append('}');
        return sb.toString();
    }

    private static class ComparableIterator
    implements Iterator<Map.Entry<InternalKey, Slice>>,
    Comparable<ComparableIterator> {
        private final SeekingIterator<InternalKey, Slice> iterator;
        private final Comparator<InternalKey> comparator;
        private final int ordinal;
        private Map.Entry<InternalKey, Slice> nextElement;

        private ComparableIterator(SeekingIterator<InternalKey, Slice> iterator, Comparator<InternalKey> comparator, int ordinal, Map.Entry<InternalKey, Slice> nextElement) {
            this.iterator = iterator;
            this.comparator = comparator;
            this.ordinal = ordinal;
            this.nextElement = nextElement;
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public Map.Entry<InternalKey, Slice> next() {
            if (this.nextElement == null) {
                throw new NoSuchElementException();
            }
            Map.Entry<InternalKey, Slice> result = this.nextElement;
            this.nextElement = this.iterator.hasNext() ? (Map.Entry)this.iterator.next() : null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComparableIterator comparableIterator = (ComparableIterator)o;
            if (this.ordinal != comparableIterator.ordinal) {
                return false;
            }
            return !(this.nextElement != null ? !this.nextElement.equals(comparableIterator.nextElement) : comparableIterator.nextElement != null);
        }

        public int hashCode() {
            int result = this.ordinal;
            result = 31 * result + (this.nextElement != null ? this.nextElement.hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(ComparableIterator that) {
            int result = this.comparator.compare(this.nextElement.getKey(), that.nextElement.getKey());
            if (result == 0) {
                result = Ints.compare(this.ordinal, that.ordinal);
            }
            return result;
        }
    }
}

