/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;

public class TakeOfflineConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<TakeOfflineConfiguration> {
    private int afterFailures = 0;
    private long minTimeToWait = 0L;
    private BackupConfigurationBuilder backupConfigurationBuilder;

    public TakeOfflineConfigurationBuilder(ConfigurationBuilder builder, BackupConfigurationBuilder backupConfigurationBuilder) {
        super(builder);
        this.backupConfigurationBuilder = backupConfigurationBuilder;
    }

    @Override
    public void validate() {
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public TakeOfflineConfiguration create() {
        return new TakeOfflineConfiguration(this.afterFailures, this.minTimeToWait);
    }

    @Override
    public Builder<?> read(TakeOfflineConfiguration template) {
        this.afterFailures = template.afterFailures();
        this.minTimeToWait = template.minTimeToWait();
        return this;
    }

    public TakeOfflineConfigurationBuilder minTimeToWait(long minTimeToWait) {
        this.minTimeToWait = minTimeToWait;
        return this;
    }

    public TakeOfflineConfigurationBuilder afterFailures(int afterFailures) {
        this.afterFailures = afterFailures;
        return this;
    }

    public BackupConfigurationBuilder backup() {
        return this.backupConfigurationBuilder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TakeOfflineConfigurationBuilder)) {
            return false;
        }
        TakeOfflineConfigurationBuilder that = (TakeOfflineConfigurationBuilder)o;
        if (this.afterFailures != that.afterFailures) {
            return false;
        }
        return this.minTimeToWait == that.minTimeToWait;
    }

    public int hashCode() {
        int result = this.afterFailures;
        result = 31 * result + (int)(this.minTimeToWait ^ this.minTimeToWait >>> 32);
        return result;
    }

    public String toString() {
        return "TakeOfflineConfigurationBuilder{afterFailures=" + this.afterFailures + ", minTimeToWait=" + this.minTimeToWait + '}';
    }
}

