/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.batch.BatchContainer;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.CommandsFactoryImpl;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.io.ByteBufferFactoryImpl;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.InvocationContextContainerImpl;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.NonTransactionalInvocationContextFactory;
import org.infinispan.context.TransactionalInvocationContextFactory;
import org.infinispan.distribution.L1Manager;
import org.infinispan.distribution.RemoteValueRetrievedListener;
import org.infinispan.distribution.impl.L1ManagerImpl;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.eviction.impl.ActivationManagerImpl;
import org.infinispan.eviction.impl.EvictionManagerImpl;
import org.infinispan.eviction.impl.PassivationManagerImpl;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.marshall.core.MarshalledEntryFactoryImpl;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.CacheNotifierImpl;
import org.infinispan.notifications.cachelistener.cluster.ClusterCacheNotifier;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.manager.PersistenceManagerImpl;
import org.infinispan.statetransfer.CommitManager;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferLockImpl;
import org.infinispan.transaction.impl.TransactionCoordinator;
import org.infinispan.transaction.totalorder.TotalOrderManager;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.transaction.xa.recovery.RecoveryAdminOperations;
import org.infinispan.xsite.BackupSender;
import org.infinispan.xsite.BackupSenderImpl;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;
import org.infinispan.xsite.statetransfer.XSiteStateConsumerImpl;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;
import org.infinispan.xsite.statetransfer.XSiteStateProviderImpl;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManagerImpl;

@DefaultFactoryFor(classes={CacheNotifier.class, ClusterCacheNotifier.class, CommandsFactory.class, PersistenceManager.class, InvocationContextContainer.class, PassivationManager.class, ActivationManager.class, BatchContainer.class, EvictionManager.class, TransactionCoordinator.class, RecoveryAdminOperations.class, StateTransferLock.class, ClusteringDependentLogic.class, L1Manager.class, TransactionFactory.class, BackupSender.class, TotalOrderManager.class, ByteBufferFactory.class, MarshalledEntryFactory.class, RemoteValueRetrievedListener.class, InvocationContextFactory.class, CommitManager.class, XSiteStateTransferManager.class, XSiteStateConsumer.class, XSiteStateProvider.class})
public class EmptyConstructorNamedCacheFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        if (componentType.equals(ClusteringDependentLogic.class)) {
            CacheMode cacheMode = this.configuration.clustering().cacheMode();
            if (!cacheMode.isClustered()) {
                return componentType.cast(new ClusteringDependentLogic.LocalLogic());
            }
            if (cacheMode.isInvalidation()) {
                return componentType.cast(new ClusteringDependentLogic.InvalidationLogic());
            }
            if (cacheMode.isReplicated()) {
                return componentType.cast(new ClusteringDependentLogic.ReplicationLogic());
            }
            return componentType.cast(new ClusteringDependentLogic.DistributionLogic());
        }
        boolean isTransactional = this.configuration.transaction().transactionMode().isTransactional();
        if (componentType.equals(InvocationContextFactory.class)) {
            Class componentImpl = isTransactional ? TransactionalInvocationContextFactory.class : NonTransactionalInvocationContextFactory.class;
            return componentType.cast(Util.getInstance(componentImpl));
        }
        if (componentType.equals(InvocationContextContainer.class)) {
            return (T)new InvocationContextContainerImpl();
        }
        if (componentType.equals(CacheNotifier.class)) {
            return (T)new CacheNotifierImpl();
        }
        if (componentType.equals(CommandsFactory.class)) {
            return (T)new CommandsFactoryImpl();
        }
        if (componentType.equals(PersistenceManager.class)) {
            return (T)new PersistenceManagerImpl();
        }
        if (componentType.equals(PassivationManager.class)) {
            return (T)new PassivationManagerImpl();
        }
        if (componentType.equals(ActivationManager.class)) {
            return (T)new ActivationManagerImpl();
        }
        if (componentType.equals(BatchContainer.class)) {
            return (T)new BatchContainer();
        }
        if (componentType.equals(TransactionCoordinator.class)) {
            return (T)new TransactionCoordinator();
        }
        if (componentType.equals(RecoveryAdminOperations.class)) {
            return (T)new RecoveryAdminOperations();
        }
        if (componentType.equals(StateTransferLock.class)) {
            return (T)new StateTransferLockImpl();
        }
        if (componentType.equals(EvictionManager.class)) {
            return (T)new EvictionManagerImpl();
        }
        if (componentType.equals(L1Manager.class)) {
            return (T)new L1ManagerImpl();
        }
        if (componentType.equals(TransactionFactory.class)) {
            return (T)new TransactionFactory();
        }
        if (componentType.equals(BackupSender.class)) {
            return (T)new BackupSenderImpl(this.globalConfiguration.sites().localSite());
        }
        if (componentType.equals(TotalOrderManager.class)) {
            return (T)new TotalOrderManager();
        }
        if (componentType.equals(ByteBufferFactory.class)) {
            return (T)new ByteBufferFactoryImpl();
        }
        if (componentType.equals(MarshalledEntryFactory.class)) {
            return (T)new MarshalledEntryFactoryImpl();
        }
        if (componentType.equals(RemoteValueRetrievedListener.class)) {
            return (T)this.componentRegistry.getComponent(L1Manager.class);
        }
        if (componentType.equals(ClusterCacheNotifier.class)) {
            return (T)this.componentRegistry.getComponent(CacheNotifier.class);
        }
        if (componentType.equals(CommitManager.class)) {
            return (T)new CommitManager(this.configuration.dataContainer().keyEquivalence());
        }
        if (componentType.equals(XSiteStateTransferManager.class)) {
            return (T)(this.configuration.sites().allBackups().isEmpty() ? null : new XSiteStateTransferManagerImpl());
        }
        if (componentType.equals(XSiteStateConsumer.class)) {
            return (T)new XSiteStateConsumerImpl();
        }
        if (componentType.equals(XSiteStateProvider.class)) {
            return (T)new XSiteStateProviderImpl();
        }
        throw new CacheConfigurationException("Don't know how to create a " + componentType.getName());
    }
}

