/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import java.util.UUID;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.cluster.RemoteClusterListener;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverter;
import org.infinispan.notifications.cachelistener.filter.CompositeCacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.PostCacheEventFilter;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusterListenerReplicateCallable<K, V>
implements DistributedCallable<K, V, Void> {
    private static final Log log = LogFactory.getLog(ClusterListenerReplicateCallable.class);
    private transient EmbeddedCacheManager cacheManager;
    private transient CacheNotifier cacheNotifier;
    private transient CacheManagerNotifier cacheManagerNotifier;
    private transient DistributedExecutorService distExecutor;
    private transient Address ourAddress;
    private final UUID identifier;
    private final CacheEventFilter<K, V> filter;
    private final CacheEventConverter<K, V, ?> converter;
    private final Address origin;

    public ClusterListenerReplicateCallable(UUID identifier, Address origin, CacheEventFilter<K, V> filter, CacheEventConverter<K, V, ?> converter) {
        this.identifier = identifier;
        this.origin = origin;
        this.filter = filter;
        this.converter = converter;
    }

    @Override
    public void setEnvironment(Cache<K, V> cache, Set<K> inputKeys) {
        this.cacheManager = cache.getCacheManager();
        this.cacheNotifier = cache.getAdvancedCache().getComponentRegistry().getComponent(CacheNotifier.class);
        this.cacheManagerNotifier = cache.getCacheManager().getGlobalComponentRegistry().getComponent(CacheManagerNotifier.class);
        this.distExecutor = new DefaultExecutorService(cache, new WithinThreadExecutor());
        this.ourAddress = cache.getCacheManager().getAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        if (!this.ourAddress.equals(this.origin)) {
            if (this.cacheManager.getMembers().contains(this.origin)) {
                CacheNotifier cacheNotifier = this.cacheNotifier;
                synchronized (cacheNotifier) {
                    boolean alreadyInstalled = false;
                    for (Object installedListener : this.cacheNotifier.getListeners()) {
                        if (!(installedListener instanceof RemoteClusterListener) || !this.identifier.equals(((RemoteClusterListener)installedListener).getId())) continue;
                        alreadyInstalled = true;
                        break;
                    }
                    if (!alreadyInstalled) {
                        RemoteClusterListener listener = new RemoteClusterListener(this.identifier, this.origin, this.distExecutor, this.cacheNotifier, this.cacheManagerNotifier);
                        this.cacheNotifier.addListener((Object)listener, this.filter != null ? new CompositeCacheEventFilter(new PostCacheEventFilter(), this.filter) : null, this.converter);
                        this.cacheManagerNotifier.addListener(listener);
                        if (!this.cacheManager.getMembers().contains(this.origin)) {
                            this.cacheNotifier.removeListener(listener);
                            this.cacheManagerNotifier.removeListener(listener);
                            if (log.isTraceEnabled()) {
                                log.tracef("Removing local cluster listener for remote cluster listener that was just registered, as the origin %s went away concurrently", (Object)this.origin);
                            }
                        } else if (log.isTraceEnabled()) {
                            log.tracef("Registered local cluster listener for remote cluster listener from origin %s with id %s", (Object)this.origin, (Object)this.identifier);
                        }
                    } else if (log.isTraceEnabled()) {
                        log.tracef("Local cluster listener from origin %s with id % was already installed, ignoring", (Object)this.origin, (Object)this.identifier);
                    }
                }
            } else if (log.isTraceEnabled()) {
                log.tracef("Not registering local cluster listener for remote cluster listener from origin %s, as the origin went away", (Object)this.origin);
            }
        } else if (log.isTraceEnabled()) {
            log.trace("Not registering local cluster listener as we are the node who registered the cluster listener");
        }
        return null;
    }

    public static class Externalizer
    extends AbstractExternalizer<ClusterListenerReplicateCallable> {
        @Override
        public Set<Class<? extends ClusterListenerReplicateCallable>> getTypeClasses() {
            return Util.asSet(ClusterListenerReplicateCallable.class);
        }

        @Override
        public void writeObject(ObjectOutput output, ClusterListenerReplicateCallable object) throws IOException {
            output.writeObject(object.identifier);
            output.writeObject(object.origin);
            output.writeObject(object.filter);
            if (object.filter == object.converter && object.filter instanceof CacheEventFilterConverter) {
                output.writeBoolean(true);
            } else {
                output.writeBoolean(false);
                output.writeObject(object.converter);
            }
        }

        @Override
        public ClusterListenerReplicateCallable readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            UUID id = (UUID)input.readObject();
            Address address = (Address)input.readObject();
            CacheEventFilter filter = (CacheEventFilter)input.readObject();
            boolean sameConverter = input.readBoolean();
            CacheEventConverter converter = sameConverter ? (CacheEventFilterConverter)filter : (CacheEventConverter)input.readObject();
            return new ClusterListenerReplicateCallable(id, address, filter, converter);
        }

        @Override
        public Integer getId() {
            return 127;
        }
    }
}

