/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.rpc;

import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.remoting.ReplicationQueue;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.rpc.RpcOptionsBuilder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="RpcManager", description="Manages all remote calls to remote cache instances in the cluster.")
public class RpcManagerImpl
implements RpcManager,
JmxStatisticsExposer {
    private static final Log log = LogFactory.getLog(RpcManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private Transport t;
    private final AtomicLong replicationCount = new AtomicLong(0L);
    private final AtomicLong replicationFailures = new AtomicLong(0L);
    private final AtomicLong totalReplicationTime = new AtomicLong(0L);
    private boolean statisticsEnabled = false;
    private Configuration configuration;
    private ReplicationQueue replicationQueue;
    private ExecutorService asyncExecutor;
    private CommandsFactory cf;
    private LocalTopologyManager localTopologyManager;
    private StateTransferManager stateTransferManager;
    private String cacheName;
    private TimeService timeService;

    @Inject
    public void injectDependencies(Transport t, Cache cache, Configuration cfg, ReplicationQueue replicationQueue, CommandsFactory cf, @ComponentName(value="org.infinispan.executors.transport") ExecutorService e, LocalTopologyManager localTopologyManager, StateTransferManager stateTransferManager, TimeService timeService) {
        this.t = t;
        this.cacheName = cache.getName();
        this.configuration = cfg;
        this.replicationQueue = replicationQueue;
        this.asyncExecutor = e;
        this.cf = cf;
        this.localTopologyManager = localTopologyManager;
        this.stateTransferManager = stateTransferManager;
        this.timeService = timeService;
    }

    @Start(priority=9)
    private void start() {
        this.statisticsEnabled = this.configuration.jmxStatistics().enabled();
        if (this.configuration.transaction().transactionProtocol().isTotalOrder()) {
            this.t.checkTotalOrderSupported();
        }
    }

    @ManagedAttribute(description="Retrieves the committed view.", displayName="Committed view", dataType=DataType.TRAIT)
    public String getCommittedViewAsString() {
        CacheTopology cacheTopology = this.stateTransferManager.getCacheTopology();
        if (cacheTopology == null) {
            return "N/A";
        }
        return cacheTopology.getCurrentCH().getMembers().toString();
    }

    @ManagedAttribute(description="Retrieves the pending view.", displayName="Pending view", dataType=DataType.TRAIT)
    public String getPendingViewAsString() {
        CacheTopology cacheTopology = this.stateTransferManager.getCacheTopology();
        if (cacheTopology == null) {
            return "N/A";
        }
        ConsistentHash pendingCH = cacheTopology.getPendingCH();
        return pendingCH != null ? pendingCH.getMembers().toString() : "null";
    }

    private boolean useReplicationQueue(boolean sync) {
        return !sync && this.replicationQueue != null && this.replicationQueue.isEnabled();
    }

    @Override
    public final Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter) {
        RpcOptions options = this.getRpcOptionsBuilder(mode, !usePriorityQueue).timeout(timeout, TimeUnit.MILLISECONDS).responseFilter(responseFilter).build();
        return this.invokeRemotely(recipients, rpcCommand, options);
    }

    @Override
    public final Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue) {
        return this.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue, null);
    }

    @Override
    public final Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout) {
        return this.invokeRemotely(recipients, rpcCommand, mode, timeout, false, null);
    }

    @Override
    public final void broadcastRpcCommand(ReplicableCommand rpc, boolean sync) throws RpcException {
        this.broadcastRpcCommand(rpc, sync, false);
    }

    @Override
    public final void broadcastRpcCommand(ReplicableCommand rpc, boolean sync, boolean usePriorityQueue) throws RpcException {
        if (this.useReplicationQueue(sync)) {
            this.replicationQueue.add(rpc);
        } else {
            this.invokeRemotely(null, rpc, sync, usePriorityQueue);
        }
    }

    @Override
    public final void broadcastRpcCommandInFuture(ReplicableCommand rpc, NotifyingNotifiableFuture<Object> l) {
        this.broadcastRpcCommandInFuture(rpc, false, l);
    }

    @Override
    public final void broadcastRpcCommandInFuture(ReplicableCommand rpc, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> l) {
        this.invokeRemotelyInFuture(null, rpc, usePriorityQueue, l);
    }

    @Override
    public final Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpc, boolean sync) throws RpcException {
        return this.invokeRemotely(recipients, rpc, sync, false);
    }

    @Override
    public final Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpc, boolean sync, boolean usePriorityQueue) throws RpcException {
        return this.invokeRemotely(recipients, rpc, sync, usePriorityQueue, this.configuration.clustering().sync().replTimeout());
    }

    public final Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpc, boolean sync, boolean usePriorityQueue, long timeout) throws RpcException {
        ResponseMode responseMode = this.getResponseMode(sync);
        return this.invokeRemotely(recipients, rpc, sync, usePriorityQueue, timeout, responseMode);
    }

    private Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpc, boolean sync, boolean usePriorityQueue, long timeout, ResponseMode responseMode) {
        if (trace) {
            log.tracef("%s broadcasting call %s to recipient list %s", (Object)this.t.getAddress(), (Object)rpc, (Object)recipients);
        }
        if (this.useReplicationQueue(sync)) {
            this.replicationQueue.add(rpc);
            return null;
        }
        if (!(rpc instanceof CacheRpcCommand)) {
            rpc = this.cf.buildSingleRpcCommand(rpc);
        }
        Map<Address, Response> rsps = this.invokeRemotely(recipients, rpc, responseMode, timeout, usePriorityQueue);
        if (trace) {
            log.tracef("Response(s) to %s is %s", (Object)rpc, (Object)rsps);
        }
        return rsps;
    }

    @Override
    public final void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpc, NotifyingNotifiableFuture<Object> l) {
        this.invokeRemotelyInFuture(recipients, rpc, false, l);
    }

    @Override
    public final void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpc, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> l) {
        this.invokeRemotelyInFuture(recipients, rpc, usePriorityQueue, l, this.configuration.clustering().sync().replTimeout());
    }

    @Override
    public final void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpc, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> l, long timeout) {
        this.invokeRemotelyInFuture(recipients, rpc, usePriorityQueue, l, timeout, false);
    }

    @Override
    public void invokeRemotelyInFuture(final Collection<Address> recipients, final ReplicableCommand rpc, final boolean usePriorityQueue, final NotifyingNotifiableFuture<Object> future, final long timeout, boolean ignoreLeavers) {
        if (trace) {
            log.tracef("%s invoking in future call %s to recipient list %s", (Object)this.t.getAddress(), (Object)rpc, (Object)recipients);
        }
        final ResponseMode responseMode = ignoreLeavers ? ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS : ResponseMode.SYNCHRONOUS;
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Map result = null;
                try {
                    result = RpcManagerImpl.this.invokeRemotely((Collection<Address>)recipients, rpc, true, usePriorityQueue, timeout, responseMode);
                    future.notifyDone(result);
                    return result;
                }
                catch (RuntimeException e) {
                    future.notifyException(e);
                    throw e;
                }
            }
        };
        future.setFuture(this.asyncExecutor.submit(c));
    }

    @Override
    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpc, RpcOptions options) {
        TopologyAffectedCommand topologyAffectedCommand;
        if (trace) {
            log.tracef("%s invoking %s to recipient list %s with options %s", this.t.getAddress(), rpc, recipients, options);
        }
        if (!options.skipReplicationQueue() && this.useReplicationQueue(options.responseMode().isSynchronous())) {
            if (trace) {
                log.tracef("Using replication queue for command [%s]", (Object)rpc);
            }
            this.replicationQueue.add(rpc);
            return null;
        }
        if (!this.configuration.clustering().cacheMode().isClustered()) {
            throw new IllegalStateException("Trying to invoke a remote command but the cache is not clustered");
        }
        if (rpc instanceof TopologyAffectedCommand && (topologyAffectedCommand = (TopologyAffectedCommand)rpc).getTopologyId() == -1) {
            int currentTopologyId = this.stateTransferManager.getCacheTopology().getTopologyId();
            if (trace) {
                log.tracef("Topology id missing on command %s, setting it to %d", (Object)rpc, (Object)currentTopologyId);
            }
            topologyAffectedCommand.setTopologyId(currentTopologyId);
        }
        if (!(rpc instanceof CacheRpcCommand)) {
            rpc = this.cf.buildSingleRpcCommand(rpc);
        }
        long startTimeNanos = 0L;
        if (this.statisticsEnabled) {
            startTimeNanos = this.timeService.time();
        }
        try {
            Map<Address, Response> result = this.t.invokeRemotely(recipients, rpc, options.responseMode(), options.timeUnit().toMillis(options.timeout()), !options.fifoOrder(), options.responseFilter(), options.totalOrder(), this.configuration.clustering().cacheMode().isDistributed());
            if (this.statisticsEnabled) {
                this.replicationCount.incrementAndGet();
            }
            if (trace) {
                log.tracef("Response(s) to %s is %s", (Object)rpc, (Object)result);
            }
            Map<Address, Response> map = result;
            return map;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException("Thread interrupted while invoking RPC", e);
        }
        catch (CacheException e) {
            log.trace("replication exception: ", e);
            if (this.statisticsEnabled) {
                this.replicationFailures.incrementAndGet();
            }
            throw e;
        }
        catch (Throwable th) {
            log.unexpectedErrorReplicating(th);
            if (this.statisticsEnabled) {
                this.replicationFailures.incrementAndGet();
            }
            throw new CacheException(th);
        }
        finally {
            if (this.statisticsEnabled) {
                long timeTaken = this.timeService.timeDuration(startTimeNanos, TimeUnit.MILLISECONDS);
                this.totalReplicationTime.getAndAdd(timeTaken);
            }
        }
    }

    @Override
    public void invokeRemotelyInFuture(final NotifyingNotifiableFuture<Map<Address, Response>> future, final Collection<Address> recipients, final ReplicableCommand rpc, final RpcOptions options) {
        if (trace) {
            log.tracef("%s invoking in future call %s to recipient list %s with options %s", this.t.getAddress(), rpc, recipients, options);
        }
        Callable<Map<Address, Response>> c = new Callable<Map<Address, Response>>(){

            @Override
            public Map<Address, Response> call() throws Exception {
                try {
                    Map<Address, Response> result = RpcManagerImpl.this.invokeRemotely((Collection<Address>)recipients, rpc, options);
                    future.notifyDone(result);
                    return result;
                }
                catch (RuntimeException e) {
                    future.notifyException(e);
                    throw e;
                }
            }
        };
        future.setFuture(this.asyncExecutor.submit(c));
    }

    @Override
    public void invokeRemotelyInFuture(final Collection<Address> recipients, final ReplicableCommand rpc, final RpcOptions options, final NotifyingNotifiableFuture<Object> future) {
        if (trace) {
            log.tracef("%s invoking in future call %s to recipient list %s with options %s", this.t.getAddress(), rpc, recipients, options);
        }
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Map<Address, Response> result = null;
                try {
                    result = RpcManagerImpl.this.invokeRemotely((Collection<Address>)recipients, rpc, options);
                    future.notifyDone(result);
                    return result;
                }
                catch (RuntimeException e) {
                    future.notifyException(e);
                    throw e;
                }
            }
        };
        future.setFuture(this.asyncExecutor.submit(c));
    }

    @Override
    public Transport getTransport() {
        return this.t;
    }

    private ResponseMode getResponseMode(boolean sync) {
        return sync ? ResponseMode.SYNCHRONOUS : ResponseMode.getAsyncResponseMode(this.configuration);
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        this.replicationCount.set(0L);
        this.replicationFailures.set(0L);
        this.totalReplicationTime.set(0L);
    }

    @ManagedAttribute(description="Number of successful replications", displayName="Number of successful replications", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getReplicationCount() {
        if (!this.isStatisticsEnabled()) {
            return -1L;
        }
        return this.replicationCount.get();
    }

    @ManagedAttribute(description="Number of failed replications", displayName="Number of failed replications", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getReplicationFailures() {
        if (!this.isStatisticsEnabled()) {
            return -1L;
        }
        return this.replicationFailures.get();
    }

    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", displayName="Statistics enabled", dataType=DataType.TRAIT, writable=true)
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.isStatisticsEnabled();
    }

    @Override
    @Deprecated
    @ManagedOperation(displayName="Enable/disable statistics. Deprecated, use the statisticsEnabled attribute instead.")
    public void setStatisticsEnabled(@Parameter(name="enabled", description="Whether statistics should be enabled or disabled (true/false)") boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @ManagedAttribute(description="Successful replications as a ratio of total replications", displayName="Successful replications ratio")
    public String getSuccessRatio() {
        if (this.replicationCount.get() == 0L || !this.statisticsEnabled) {
            return "N/A";
        }
        double ration = this.calculateSuccessRatio() * 100.0;
        return NumberFormat.getInstance().format(ration) + "%";
    }

    @ManagedAttribute(description="Successful replications as a ratio of total replications in numeric double format", displayName="Successful replication ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getSuccessRatioFloatingPoint() {
        if (this.replicationCount.get() == 0L || !this.statisticsEnabled) {
            return 0.0;
        }
        return this.calculateSuccessRatio();
    }

    private double calculateSuccessRatio() {
        double totalCount = this.replicationCount.get() + this.replicationFailures.get();
        return (double)this.replicationCount.get() / totalCount;
    }

    @ManagedAttribute(description="The average time spent in the transport layer, in milliseconds", displayName="Average time spent in the transport layer", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageReplicationTime() {
        if (this.replicationCount.get() == 0L) {
            return 0L;
        }
        return this.totalReplicationTime.get() / this.replicationCount.get();
    }

    public void setTransport(Transport t) {
        this.t = t;
    }

    @Override
    public Address getAddress() {
        return this.t != null ? this.t.getAddress() : null;
    }

    @Override
    public int getTopologyId() {
        CacheTopology cacheTopology = this.stateTransferManager.getCacheTopology();
        return cacheTopology != null ? cacheTopology.getTopologyId() : -1;
    }

    @Override
    public RpcOptionsBuilder getRpcOptionsBuilder(ResponseMode responseMode) {
        return this.getRpcOptionsBuilder(responseMode, true);
    }

    @Override
    public RpcOptionsBuilder getRpcOptionsBuilder(ResponseMode responseMode, boolean fifoOrder) {
        return new RpcOptionsBuilder(this.configuration.clustering().sync().replTimeout(), TimeUnit.MILLISECONDS, responseMode, fifoOrder);
    }

    @Override
    public RpcOptions getDefaultRpcOptions(boolean sync) {
        return this.getDefaultRpcOptions(sync, true);
    }

    @Override
    public RpcOptions getDefaultRpcOptions(boolean sync, boolean fifoOrder) {
        return this.getRpcOptionsBuilder(sync ? ResponseMode.SYNCHRONOUS : ResponseMode.getAsyncResponseMode(this.configuration), fifoOrder).build();
    }

    @Override
    public List<Address> getMembers() {
        return this.stateTransferManager.getCacheTopology().getMembers();
    }
}

