/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import org.infinispan.Cache;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.manager.PersistenceManager;

public class RemoveCacheCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 18;
    private EmbeddedCacheManager cacheManager;
    private GlobalComponentRegistry registry;
    private PersistenceManager persistenceManager;
    private CacheJmxRegistration cacheJmxRegistration;

    private RemoveCacheCommand() {
        super(null);
    }

    public RemoveCacheCommand(String cacheName, EmbeddedCacheManager cacheManager, GlobalComponentRegistry registry, PersistenceManager persistenceManager, CacheJmxRegistration cacheJmxRegistration) {
        super(cacheName);
        this.cacheManager = cacheManager;
        this.registry = registry;
        this.persistenceManager = persistenceManager;
        this.cacheJmxRegistration = cacheJmxRegistration;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        this.persistenceManager.setClearOnStop(true);
        this.cacheJmxRegistration.setUnregisterCacheMBean(true);
        Cache cache = this.cacheManager.getCache(this.cacheName);
        cache.stop();
        this.registry.removeCache(this.cacheName);
        return null;
    }

    @Override
    public byte getCommandId() {
        return 18;
    }

    @Override
    public Object[] getParameters() {
        return Util.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public String toString() {
        return "RemoveCacheCommand{cacheName='" + this.cacheName + '\'' + '}';
    }
}

