/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Properties;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.DataContainerConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.DataContainer;

public class DataContainerConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<DataContainerConfiguration> {
    private DataContainer dataContainer;
    private Equivalence keyEquivalence = AnyEquivalence.getInstance();
    private Equivalence valueEquivalence = AnyEquivalence.getInstance();
    private Properties properties = new Properties();

    DataContainerConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public DataContainerConfigurationBuilder dataContainer(DataContainer dataContainer) {
        this.dataContainer = dataContainer;
        return this;
    }

    public DataContainerConfigurationBuilder addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public DataContainerConfigurationBuilder withProperties(Properties props) {
        this.properties = props;
        return this;
    }

    public <K> DataContainerConfigurationBuilder keyEquivalence(Equivalence<K> keyEquivalence) {
        this.keyEquivalence = keyEquivalence;
        return this;
    }

    public <V> DataContainerConfigurationBuilder valueEquivalence(Equivalence<V> valueEquivalence) {
        this.valueEquivalence = valueEquivalence;
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public DataContainerConfiguration create() {
        return new DataContainerConfiguration(this.dataContainer, TypedProperties.toTypedProperties(this.properties), this.keyEquivalence, this.valueEquivalence);
    }

    public DataContainerConfigurationBuilder read(DataContainerConfiguration template) {
        this.dataContainer = template.dataContainer();
        this.properties = template.properties();
        this.keyEquivalence = template.keyEquivalence();
        this.valueEquivalence = template.valueEquivalence();
        return this;
    }

    public String toString() {
        return "DataContainerConfigurationBuilder{dataContainer=" + this.dataContainer + ", properties=" + this.properties + ", keyEquivalence=" + this.keyEquivalence + ", valueEquivalence=" + this.valueEquivalence + '}';
    }
}

