/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.AbstractTxLockingInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PessimisticLockingInterceptor
extends AbstractTxLockingInterceptor {
    private CommandsFactory cf;
    private StateTransferManager stateTransferManager;
    private static final Log log = LogFactory.getLog(PessimisticLockingInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void init(CommandsFactory factory, StateTransferManager stateTransferManager) {
        this.cf = factory;
        this.stateTransferManager = stateTransferManager;
    }

    @Override
    public final Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    @Override
    public final Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    private final Object visitDataReadCommand(InvocationContext ctx, AbstractDataCommand command) throws Throwable {
        try {
            if (ctx.isInTxScope() && command.hasFlag(Flag.FORCE_WRITE_LOCK) && !this.hasSkipLocking(command)) {
                this.acquireRemoteIfNeeded(ctx, command, this.cdl.localNodeIsPrimaryOwner(command.getKey()));
                long lockTimeout = this.getLockAcquisitionTimeout(command, false);
                this.lockKeyAndCheckOwnership(ctx, command.getKey(), lockTimeout, false);
            }
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        catch (Throwable t) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw t;
        }
        finally {
            if (!ctx.isInTxScope()) {
                this.lockManager.unlockAll(ctx);
            }
        }
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        return this.invokeNextAndCommitIf1Pc(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (command.hasFlag(Flag.PUT_FOR_EXTERNAL_READ)) {
            return super.visitPutKeyValueCommand(ctx, command);
        }
        TxInvocationContext txContext = (TxInvocationContext)ctx;
        try {
            boolean skipLocking = this.hasSkipLocking(command);
            if (!skipLocking) {
                boolean localLock = this.cdl.localNodeIsPrimaryOwner(command.getKey());
                this.acquireRemoteIfNeeded(ctx, command, localLock);
                long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
                this.lockAndRegisterBackupLock(txContext, command.getKey(), localLock, lockTimeout, skipLocking);
            }
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw te;
        }
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        try {
            boolean skipLocking = this.hasSkipLocking(command);
            if (!skipLocking) {
                this.acquireRemoteIfNeeded(ctx, command.getMap().keySet(), command);
                TxInvocationContext txContext = (TxInvocationContext)ctx;
                long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
                for (Object key : command.getMap().keySet()) {
                    this.lockAndRegisterBackupLock(txContext, key, lockTimeout, skipLocking);
                }
            }
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw te;
        }
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        try {
            boolean skipLocking = this.hasSkipLocking(command);
            if (!skipLocking) {
                boolean localNodeOwnsLock = this.cdl.localNodeIsPrimaryOwner(command.getKey());
                this.acquireRemoteIfNeeded(ctx, command, localNodeOwnsLock);
                TxInvocationContext txContext = (TxInvocationContext)ctx;
                long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
                this.lockAndRegisterBackupLock(txContext, command.getKey(), localNodeOwnsLock, lockTimeout, skipLocking);
            }
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw te;
        }
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        Object[] compositeKeys = command.getCompositeKeys();
        try {
            boolean skipLocking = this.hasSkipLocking(command);
            if (!skipLocking) {
                HashSet<Object> keysToLock = new HashSet<Object>(Arrays.asList(compositeKeys));
                this.acquireRemoteIfNeeded(ctx, keysToLock, command);
                if (this.cdl.localNodeIsOwner(command.getKey())) {
                    long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
                    for (Object key : compositeKeys) {
                        this.lockKey(ctx, key, lockTimeout, skipLocking);
                    }
                }
            }
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        try {
            boolean skipLocking = this.hasSkipLocking(command);
            if (!skipLocking) {
                boolean localNodeOwnsLock = this.cdl.localNodeIsPrimaryOwner(command.getKey());
                this.acquireRemoteIfNeeded(ctx, command, localNodeOwnsLock);
                TxInvocationContext txContext = (TxInvocationContext)ctx;
                long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
                this.lockAndRegisterBackupLock(txContext, command.getKey(), localNodeOwnsLock, lockTimeout, skipLocking);
            }
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw te;
        }
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        try {
            boolean skipLocking = this.hasSkipLocking(command);
            if (!skipLocking) {
                long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
                for (InternalCacheEntry entry : this.dataContainer.entrySet()) {
                    this.lockAndRegisterBackupLock((TxInvocationContext)ctx, entry.getKey(), lockTimeout, skipLocking);
                }
            }
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw te;
        }
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (!ctx.isInTxScope()) {
            throw new IllegalStateException("Locks should only be acquired within the scope of a transaction!");
        }
        try {
            boolean skipLocking = this.hasSkipLocking(command);
            if (skipLocking) {
                return this.invokeNextInterceptor(ctx, command);
            }
            if (ctx.isOriginLocal()) {
                boolean needBackupLocks;
                boolean isSingleKeyAndLocal = !command.multipleKeys() && this.cdl.localNodeIsPrimaryOwner(command.getSingleKey());
                boolean bl = needBackupLocks = !isSingleKeyAndLocal || this.isStateTransferInProgress();
                if (needBackupLocks && !command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
                    LocalTransaction localTx = (LocalTransaction)ctx.getCacheTransaction();
                    if (!localTx.getAffectedKeys().containsAll(command.getKeys())) {
                        this.invokeNextInterceptor(ctx, command);
                    } else {
                        log.tracef("Already own locks on keys: %s, skipping remote call", (Object)command.getKeys());
                    }
                }
                ctx.addAllAffectedKeys(command.getKeys());
            }
            if (command.isUnlock()) {
                if (ctx.isOriginLocal()) {
                    throw new AssertionError((Object)"There's no advancedCache.unlock so this must have originated remotely.");
                }
                this.releaseLocksOnFailureBeforePrepare(ctx);
                return Boolean.FALSE;
            }
            long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
            for (Object key : command.getKeys()) {
                this.lockAndRegisterBackupLock(ctx, key, lockTimeout, skipLocking);
            }
            return Boolean.TRUE;
        }
        catch (Throwable te) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw te;
        }
    }

    private void acquireRemoteIfNeeded(InvocationContext ctx, Set<Object> keys, FlagAffectedCommand command) throws Throwable {
        if (ctx.isOriginLocal() && !command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LocalTransaction localTransaction = (LocalTransaction)txContext.getCacheTransaction();
            if (localTransaction.getAffectedKeys().containsAll(keys)) {
                log.tracef("We already have lock for keys %s, skip remote lock acquisition", (Object)keys);
                return;
            }
            LockControlCommand lcc = this.cf.buildLockControlCommand(keys, command.getFlags(), txContext.getGlobalTransaction());
            this.invokeNextInterceptor(ctx, lcc);
        }
        ((TxInvocationContext)ctx).addAllAffectedKeys(keys);
    }

    private void acquireRemoteIfNeeded(InvocationContext ctx, AbstractDataCommand command, boolean localNodeIsLockOwner) throws Throwable {
        boolean needBackupLocks;
        Object key = command.getKey();
        boolean bl = needBackupLocks = ctx.isOriginLocal() && (!localNodeIsLockOwner || this.isStateTransferInProgress());
        if (needBackupLocks && !command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LocalTransaction localTransaction = (LocalTransaction)txContext.getCacheTransaction();
            boolean alreadyLocked = localTransaction.getAffectedKeys().contains(key);
            if (alreadyLocked) {
                log.tracef("We already have lock for key %s, skip remote lock acquisition", key);
                return;
            }
            LockControlCommand lcc = this.cf.buildLockControlCommand(key, command.getFlags(), txContext.getGlobalTransaction());
            this.invokeNextInterceptor(ctx, lcc);
        }
        ((TxInvocationContext)ctx).addAffectedKey(key);
    }

    private boolean isStateTransferInProgress() {
        return this.stateTransferManager != null && this.stateTransferManager.isStateTransferInProgress();
    }

    private void releaseLocksOnFailureBeforePrepare(InvocationContext ctx) {
        this.lockManager.unlockAll(ctx);
        if (ctx.isOriginLocal() && ctx.isInTxScope() && this.rpcManager != null) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            TxCompletionNotificationCommand command = this.cf.buildTxCompletionNotificationCommand(null, txContext.getGlobalTransaction());
            LocalTransaction cacheTransaction = (LocalTransaction)txContext.getCacheTransaction();
            this.rpcManager.invokeRemotely(cacheTransaction.getRemoteLocksAcquired(), (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(true, DeliverOrder.NONE));
        }
    }

    private void lockAndRegisterBackupLock(TxInvocationContext ctx, Object key, boolean isLockOwner, long lockTimeout, boolean skipLocking) throws InterruptedException {
        if (isLockOwner) {
            this.lockKeyAndCheckOwnership(ctx, key, lockTimeout, skipLocking);
        } else if (this.cdl.localNodeIsOwner(key)) {
            ((AbstractCacheTransaction)ctx.getCacheTransaction()).addBackupLockForKey(key);
        }
    }
}

