/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.remote.configuration.AbstractRemoteStoreConfigurationChildBuilder;
import org.infinispan.persistence.remote.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.remote.configuration.ExhaustedAction;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;

public class ConnectionPoolConfigurationBuilder
extends AbstractRemoteStoreConfigurationChildBuilder<RemoteStoreConfigurationBuilder>
implements Builder<ConnectionPoolConfiguration> {
    private ExhaustedAction exhaustedAction = ExhaustedAction.WAIT;
    private int maxActive = -1;
    private int maxTotal = -1;
    private int maxIdle = -1;
    private int minIdle = 1;
    private long timeBetweenEvictionRuns = 120000L;
    private long minEvictableIdleTime = 1800000L;
    private boolean testWhileIdle = true;

    ConnectionPoolConfigurationBuilder(RemoteStoreConfigurationBuilder builder) {
        super(builder);
    }

    public ConnectionPoolConfigurationBuilder exhaustedAction(ExhaustedAction exhaustedAction) {
        this.exhaustedAction = exhaustedAction;
        return this;
    }

    public ConnectionPoolConfigurationBuilder maxActive(int maxActive) {
        this.maxActive = maxActive;
        return this;
    }

    public ConnectionPoolConfigurationBuilder maxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
        return this;
    }

    public ConnectionPoolConfigurationBuilder maxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
        return this;
    }

    public ConnectionPoolConfigurationBuilder minIdle(int minIdle) {
        this.minIdle = minIdle;
        return this;
    }

    public ConnectionPoolConfigurationBuilder timeBetweenEvictionRuns(long timeBetweenEvictionRuns) {
        this.timeBetweenEvictionRuns = timeBetweenEvictionRuns;
        return this;
    }

    public ConnectionPoolConfigurationBuilder minEvictableIdleTime(long minEvictableIdleTime) {
        this.minEvictableIdleTime = minEvictableIdleTime;
        return this;
    }

    public ConnectionPoolConfigurationBuilder testWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public ConnectionPoolConfiguration create() {
        return new ConnectionPoolConfiguration(this.exhaustedAction, this.maxActive, this.maxTotal, this.maxIdle, this.minIdle, this.timeBetweenEvictionRuns, this.minEvictableIdleTime, this.testWhileIdle);
    }

    public ConnectionPoolConfigurationBuilder read(ConnectionPoolConfiguration template) {
        this.exhaustedAction = template.exhaustedAction();
        this.maxActive = template.maxActive();
        this.maxTotal = template.maxTotal();
        this.maxIdle = template.maxIdle();
        this.minIdle = template.minIdle();
        this.timeBetweenEvictionRuns = template.timeBetweenEvictionRuns();
        this.minEvictableIdleTime = template.minEvictableIdleTime();
        this.testWhileIdle = template.testWhileIdle();
        return this;
    }
}

