/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import javax.xml.stream.XMLStreamException;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser71;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.persistence.remote.configuration.Attribute;
import org.infinispan.persistence.remote.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.Element;
import org.infinispan.persistence.remote.configuration.ExecutorFactoryConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.ExhaustedAction;
import org.infinispan.persistence.remote.configuration.RemoteServerConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.persistence.remote.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Namespaces(value={@Namespace(uri="urn:infinispan:config:store:remote:7.1", root="remote-store"), @Namespace(root="remote-store")})
public class RemoteStoreConfigurationParser71
implements ConfigurationParser {
    private static final Log log = LogFactory.getLog(RemoteStoreConfigurationParser71.class, Log.class);

    @Override
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case REMOTE_STORE: {
                this.parseRemoteStore(reader, builder.persistence(), holder.getClassLoader());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    private void parseRemoteStore(XMLExtendedStreamReader reader, PersistenceConfigurationBuilder persistenceBuilder, ClassLoader classLoader) throws XMLStreamException {
        RemoteStoreConfigurationBuilder builder = new RemoteStoreConfigurationBuilder(persistenceBuilder);
        this.parseRemoteStoreAttributes(reader, builder);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ASYNC_TRANSPORT_EXECUTOR: {
                    this.parseAsyncTransportExecutor(reader, builder.asyncExecutorFactory(), classLoader);
                    continue block5;
                }
                case CONNECTION_POOL: {
                    this.parseConnectionPool(reader, builder.connectionPool());
                    continue block5;
                }
                case SERVER: {
                    this.parseServer(reader, builder.addServer());
                    continue block5;
                }
            }
            Parser71.parseStoreElement(reader, builder);
        }
        persistenceBuilder.addStore(builder);
    }

    private void parseAsyncTransportExecutor(XMLExtendedStreamReader reader, ExecutorFactoryConfigurationBuilder builder, ClassLoader classLoader) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTORY: {
                    builder.factory((ExecutorFactory)Util.getInstance(value, classLoader));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        builder.withExecutorProperties(Parser71.parseProperties(reader));
    }

    private void parseConnectionPool(XMLExtendedStreamReader reader, ConnectionPoolConfigurationBuilder builder) throws XMLStreamException {
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case EXHAUSTED_ACTION: {
                    builder.exhaustedAction(ExhaustedAction.valueOf(value));
                    continue block10;
                }
                case MAX_ACTIVE: {
                    builder.maxActive(Integer.parseInt(value));
                    continue block10;
                }
                case MAX_IDLE: {
                    builder.maxIdle(Integer.parseInt(value));
                    continue block10;
                }
                case MAX_TOTAL: {
                    builder.maxTotal(Integer.parseInt(value));
                    continue block10;
                }
                case MIN_EVICTABLE_IDLE_TIME: {
                    builder.minEvictableIdleTime(Long.parseLong(value));
                    continue block10;
                }
                case MIN_IDLE: {
                    builder.minIdle(Integer.parseInt(value));
                    continue block10;
                }
                case TEST_WHILE_IDLE: {
                    builder.testWhileIdle(Boolean.parseBoolean(value));
                    continue block10;
                }
                case TIME_BETWEEN_EVICTION_RUNS: {
                    builder.timeBetweenEvictionRuns(Long.parseLong(value));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseServer(XMLExtendedStreamReader reader, RemoteServerConfigurationBuilder builder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOST: {
                    builder.host(value);
                    continue block5;
                }
                case PORT: {
                    builder.port(Integer.parseInt(value));
                    continue block5;
                }
                case OUTBOUND_SOCKET_BINDING: {
                    log.ignoreXmlAttribute((Object)attribute);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseRemoteStoreAttributes(XMLExtendedStreamReader reader, RemoteStoreConfigurationBuilder builder) throws XMLStreamException {
        block16: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            String attrName = reader.getAttributeLocalName(i);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case BALANCING_STRATEGY: {
                    builder.balancingStrategy(value);
                    continue block16;
                }
                case CONNECT_TIMEOUT: {
                    builder.connectionTimeout(Long.parseLong(value));
                    continue block16;
                }
                case FORCE_RETURN_VALUES: {
                    builder.forceReturnValues(Boolean.parseBoolean(value));
                    continue block16;
                }
                case HOTROD_WRAPPING: {
                    builder.hotRodWrapping(Boolean.parseBoolean(value));
                    continue block16;
                }
                case KEY_SIZE_ESTIMATE: {
                    builder.keySizeEstimate(Integer.parseInt(value));
                    continue block16;
                }
                case MARSHALLER: {
                    builder.marshaller(value);
                    continue block16;
                }
                case PING_ON_STARTUP: {
                    builder.pingOnStartup(Boolean.parseBoolean(value));
                    continue block16;
                }
                case PROTOCOL_VERSION: {
                    builder.protocolVersion(value);
                    continue block16;
                }
                case RAW_VALUES: {
                    builder.rawValues(Boolean.parseBoolean(value));
                    continue block16;
                }
                case REMOTE_CACHE_NAME: {
                    builder.remoteCacheName(value);
                    continue block16;
                }
                case SOCKET_TIMEOUT: {
                    builder.socketTimeout(Long.parseLong(value));
                    continue block16;
                }
                case TCP_NO_DELAY: {
                    builder.tcpNoDelay(Boolean.parseBoolean(value));
                    continue block16;
                }
                case TRANSPORT_FACTORY: {
                    builder.transportFactory(value);
                    continue block16;
                }
                case VALUE_SIZE_ESTIMATE: {
                    builder.valueSizeEstimate(Integer.parseInt(value));
                    continue block16;
                }
                default: {
                    Parser71.parseStoreAttribute(reader, i, builder);
                }
            }
        }
    }

    @Override
    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }
}

