/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.concurrent.AbstractInProcessFuture;
import org.infinispan.commons.util.concurrent.NotifyingFutureImpl;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.LocalInvocation;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BaseBackupReceiver;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;
import org.infinispan.xsite.statetransfer.XSiteStateTransferControlCommand;

public class ClusteredCacheBackupReceiver
extends BaseBackupReceiver {
    private static final Log log = LogFactory.getLog(ClusteredCacheBackupReceiver.class);
    private static final boolean trace = log.isDebugEnabled();

    public ClusteredCacheBackupReceiver(Cache<Object, Object> cache) {
        super(cache);
    }

    private static boolean awaitRemoteTask(Cache<?, ?> cache, StatePushTask task) throws Exception {
        try {
            if (trace) {
                log.tracef("Waiting reply from %s", (Object)task.address);
            }
            Response response = task.awaitResponse();
            if (trace) {
                log.tracef("Response received is %s", (Object)response);
            }
            if (response == CacheNotFoundResponse.INSTANCE) {
                if (trace) {
                    log.tracef("Cache not found in node '%s'. Retrying locally!", (Object)task.address);
                }
                if (!cache.getStatus().allowInvocations()) {
                    throw new CacheException("Cache is stopping or terminated: " + (Object)((Object)cache.getStatus()));
                }
                task.executeLocal();
            }
        }
        catch (Exception e) {
            if (!cache.getStatus().allowInvocations()) {
                throw new CacheException("Cache is stopping or terminated: " + (Object)((Object)cache.getStatus()));
            }
            if (cache.getAdvancedCache().getRpcManager().getMembers().contains(task.address) && !cache.getAdvancedCache().getRpcManager().getAddress().equals(task.address)) {
                if (trace) {
                    log.tracef((Throwable)e, "An exception was sent by %s. Retrying!", (Object)task.address);
                }
                task.executeRemote();
                return false;
            }
            if (trace) {
                log.tracef((Throwable)e, "An exception was sent by %s. Retrying locally!", (Object)task.address);
            }
            task.executeLocal();
            return false;
        }
        return true;
    }

    @Override
    public void handleStateTransferControl(XSiteStateTransferControlCommand command) throws Exception {
        XSiteStateTransferControlCommand invokeCommand = command;
        if (!command.getCacheName().equals(this.cache.getName())) {
            invokeCommand = command.copyForCache(this.cache.getName());
        }
        invokeCommand.setSiteName(command.getOriginSite());
        this.invokeRemotelyInLocalSite(invokeCommand);
    }

    @Override
    public void handleStateTransferState(XSiteStatePushCommand cmd) throws Exception {
        if (!this.cache.getStatus().allowInvocations()) {
            throw new CacheException("Cache is stopping or terminated: " + (Object)((Object)this.cache.getStatus()));
        }
        long endTime = this.timeService.expectedEndTime(cmd.getTimeout(), TimeUnit.MILLISECONDS);
        ClusteringDependentLogic clusteringDependentLogic = this.cache.getAdvancedCache().getComponentRegistry().getComponent(ClusteringDependentLogic.class);
        HashMap<Address, LinkedList<XSiteState>> primaryOwnersChunks = new HashMap<Address, LinkedList<XSiteState>>();
        Address localAddress = clusteringDependentLogic.getAddress();
        if (trace) {
            log.tracef("Received X-Site state transfer '%s'. Splitting by primary owner.", (Object)cmd);
        }
        for (XSiteState state : cmd.getChunk()) {
            Address primaryOwner = clusteringDependentLogic.getPrimaryOwner(state.key());
            LinkedList<XSiteState> primaryOwnerList = (LinkedList<XSiteState>)primaryOwnersChunks.get(primaryOwner);
            if (primaryOwnerList == null) {
                primaryOwnerList = new LinkedList<XSiteState>();
                primaryOwnersChunks.put(primaryOwner, primaryOwnerList);
            }
            primaryOwnerList.add(state);
        }
        List localChunks = (List)primaryOwnersChunks.remove(localAddress);
        ArrayList<StatePushTask> tasks = new ArrayList<StatePushTask>(primaryOwnersChunks.size());
        for (Map.Entry entry : primaryOwnersChunks.entrySet()) {
            if (entry.getValue() == null || ((List)entry.getValue()).isEmpty()) continue;
            if (trace) {
                log.tracef("Node '%s' will apply %s", entry.getKey(), entry.getValue());
            }
            StatePushTask task = new StatePushTask((List)entry.getValue(), (Address)entry.getKey(), this.cache);
            tasks.add(task);
            task.executeRemote();
        }
        primaryOwnersChunks.clear();
        if (trace) {
            log.tracef("Local node '%s' will apply %s", (Object)localAddress, (Object)localChunks);
        }
        if (localChunks != null) {
            StatePushTask task = new StatePushTask(localChunks, localAddress, this.cache);
            tasks.add(task);
            task.executeLocal();
        }
        if (trace) {
            log.tracef("Waiting for the remote tasks...", new Object[0]);
        }
        while (!tasks.isEmpty() && !this.timeService.isTimeExpired(endTime)) {
            Iterator iterator = tasks.iterator();
            while (iterator.hasNext()) {
                if (!ClusteredCacheBackupReceiver.awaitRemoteTask(this.cache, (StatePushTask)iterator.next())) continue;
                iterator.remove();
            }
        }
        if (!this.cache.getStatus().allowInvocations()) {
            throw new CacheException("Cache is stopping or terminated: " + (Object)((Object)this.cache.getStatus()));
        }
        if (!tasks.isEmpty()) {
            throw new TimeoutException("Unable to apply state in the time limit.");
        }
    }

    private Map<Address, Response> invokeRemotelyInLocalSite(CacheRpcCommand command) throws Exception {
        RpcManager rpcManager = this.cache.getAdvancedCache().getRpcManager();
        NotifyingFutureImpl<Map<Address, Response>> remoteFuture = new NotifyingFutureImpl<Map<Address, Response>>();
        HashMap<Address, Response> responseMap = new HashMap<Address, Response>();
        rpcManager.invokeRemotelyInFuture(remoteFuture, null, command, rpcManager.getDefaultRpcOptions(true, DeliverOrder.NONE));
        responseMap.put(rpcManager.getAddress(), LocalInvocation.newInstanceFromCache(this.cache, command).call());
        responseMap.putAll((Map)remoteFuture.get());
        return responseMap;
    }

    private static class StatePushTask {
        private final List<XSiteState> chunk;
        private final Address address;
        private final Cache<?, ?> cache;
        private volatile Future<Map<Address, Response>> remoteFuture;

        private StatePushTask(List<XSiteState> chunk, Address address, Cache<?, ?> cache) {
            this.chunk = chunk;
            this.address = address;
            this.cache = cache;
        }

        public void executeRemote() {
            RpcManager rpcManager = this.cache.getAdvancedCache().getRpcManager();
            NotifyingFutureImpl<Map<Address, Response>> future = new NotifyingFutureImpl<Map<Address, Response>>();
            this.remoteFuture = future;
            rpcManager.invokeRemotelyInFuture(future, Collections.singletonList(this.address), BaseBackupReceiver.newStatePushCommand(this.cache, this.chunk), rpcManager.getDefaultRpcOptions(true));
        }

        public void executeLocal() {
            try {
                final Response response = LocalInvocation.newInstanceFromCache(this.cache, BaseBackupReceiver.newStatePushCommand(this.cache, this.chunk)).call();
                this.remoteFuture = new AbstractInProcessFuture<Map<Address, Response>>(){

                    @Override
                    public Map<Address, Response> get() throws InterruptedException, ExecutionException {
                        return Collections.singletonMap(StatePushTask.this.address, response);
                    }
                };
            }
            catch (Exception e) {
                this.remoteFuture = new AbstractInProcessFuture<Map<Address, Response>>(){

                    @Override
                    public Map<Address, Response> get() throws InterruptedException, ExecutionException {
                        throw new ExecutionException(e);
                    }
                };
            }
        }

        public Response awaitResponse() throws Exception {
            Future<Map<Address, Response>> future = this.remoteFuture;
            if (future == null) {
                throw new NullPointerException("Should not happen!");
            }
            Map<Address, Response> responseMap = future.get();
            if (responseMap.size() != 1 || !responseMap.containsKey(this.address)) {
                throw new IllegalStateException("Shouldn't happen. Map is " + responseMap);
            }
            return responseMap.values().iterator().next();
        }
    }
}

