/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.components;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.infinispan.factories.components.JmxOperationParameter;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.Parameter;

public class JmxOperationMetadata
implements Serializable {
    private final String methodName;
    private final String operationName;
    private final JmxOperationParameter[] methodParameters;
    private final String description;
    private final String returnType;

    public JmxOperationMetadata(Method m) {
        this.methodName = m.getName();
        this.returnType = m.getReturnType().getName();
        Class<?>[] params = m.getParameterTypes();
        Annotation[][] annots = m.getParameterAnnotations();
        this.methodParameters = new JmxOperationParameter[params.length];
        for (int i = 0; i < params.length; ++i) {
            Parameter annot = null;
            for (int j = 0; j < annots[i].length; ++j) {
                if (!(annots[i][j] instanceof Parameter)) continue;
                annot = (Parameter)annots[i][j];
                break;
            }
            this.methodParameters[i] = annot == null ? new JmxOperationParameter("p" + i, params[i].getName(), null) : new JmxOperationParameter(annot.name(), params[i].getName(), annot.description());
        }
        ManagedOperation mo = m.getAnnotation(ManagedOperation.class);
        this.operationName = mo.name();
        this.description = mo != null ? mo.description() : null;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOperationName() {
        return this.operationName.isEmpty() ? this.methodName : this.operationName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public JmxOperationParameter[] getMethodParameters() {
        return this.methodParameters;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String toString() {
        return "JmxOperationMetadata{methodName='" + this.methodName + '\'' + ", methodParameters=" + (this.methodParameters == null ? null : Arrays.asList(this.methodParameters)) + ", description='" + this.description + '\'' + '}';
    }
}

