/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util.concurrent;

import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commons.util.concurrent.FutureListener;
import org.infinispan.commons.util.concurrent.NoOpFuture;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.commons.util.concurrent.NotifyingFutureImpl;

public final class CompositeNotifyingFuture<T>
extends NotifyingFutureImpl<Void> {
    private final CountDownLatch remaining;
    private final List<NotifyingFuture<T>> futures;
    private volatile boolean cancelled = false;

    public CompositeNotifyingFuture(List<NotifyingFuture<T>> futures) {
        this.futures = futures;
        this.remaining = new CountDownLatch(futures.size());
        InternalListener internalListener = new InternalListener();
        for (NotifyingFuture<T> future : futures) {
            future.attachListener(internalListener);
        }
    }

    @Override
    public boolean isDone() {
        return this.remaining.getCount() == 0L;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelled = true;
        boolean wasCancelled = true;
        for (NotifyingFuture<T> future : this.futures) {
            wasCancelled &= future.cancel(mayInterruptIfRunning);
        }
        return wasCancelled;
    }

    @Override
    public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (unit == null) {
            throw new IllegalArgumentException("provided unit is null");
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        if (!this.remaining.await(timeout, unit)) {
            throw new TimeoutException();
        }
        return (Void)super.get();
    }

    @Override
    public Void get() throws InterruptedException, ExecutionException {
        if (this.cancelled) {
            throw new CancellationException();
        }
        this.remaining.await();
        return (Void)super.get();
    }

    final class InternalListener
    implements FutureListener<T> {
        InternalListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void futureDone(Future<T> future) {
            InternalListener internalListener = this;
            synchronized (internalListener) {
                Throwable error = null;
                try {
                    future.get();
                }
                catch (Throwable e) {
                    error = e;
                }
                CompositeNotifyingFuture.this.remaining.countDown();
                if (CompositeNotifyingFuture.this.remaining.getCount() == 0L) {
                    if (error != null) {
                        CompositeNotifyingFuture.this.notifyException(error);
                    } else {
                        CompositeNotifyingFuture.this.notifyDone(null);
                    }
                    CompositeNotifyingFuture.this.setFuture(new NoOpFuture<Object>(null));
                }
            }
        }
    }
}

