/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.marshall.core.MarshalledValue;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MarshalledValueInterceptor
extends CommandInterceptor {
    private StreamingMarshaller marshaller;
    private boolean wrapKeys = true;
    private boolean wrapValues = true;
    private InternalEntryFactory entryFactory;
    private static final Log log = LogFactory.getLog(MarshalledValueInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    protected void injectMarshaller(@ComponentName(value="org.infinispan.marshaller.cache") StreamingMarshaller marshaller, InternalEntryFactory entryFactory) {
        this.marshaller = marshaller;
        this.entryFactory = entryFactory;
    }

    @Start
    protected void start() {
        this.wrapKeys = this.cacheConfiguration.storeAsBinary().storeKeysAsBinary();
        this.wrapValues = this.cacheConfiguration.storeAsBinary().storeValuesAsBinary();
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (this.wrapKeys) {
            if (command.multipleKeys()) {
                Collection<Object> rawKeys = command.getKeys();
                HashMap<Object, Object> keyToMarshalledKeyMapping = new HashMap<Object, Object>(rawKeys.size());
                for (Object k : rawKeys) {
                    if (MarshalledValue.isTypeExcluded(k.getClass())) continue;
                    keyToMarshalledKeyMapping.put(k, this.createMarshalledValue(k, ctx));
                }
                if (!keyToMarshalledKeyMapping.isEmpty()) {
                    command.replaceKeys(keyToMarshalledKeyMapping);
                }
            } else {
                Object key = command.getSingleKey();
                if (!MarshalledValue.isTypeExcluded(key.getClass())) {
                    command.replaceKey(key, this.createMarshalledValue(key, ctx));
                }
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        HashSet<MarshalledValue> marshalledValues = new HashSet<MarshalledValue>(command.getMap().size());
        Map<Object, Object> map = this.wrapMap(command.getMap(), marshalledValues, ctx);
        command.setMap(map);
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return this.processRetVal(retVal, ctx);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (this.wrapKeys && !MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            MarshalledValue key = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(key);
        }
        if (this.wrapValues && !MarshalledValue.isTypeExcluded(command.getValue().getClass())) {
            MarshalledValue value = this.createMarshalledValue(command.getValue(), ctx);
            command.setValue(value);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return this.processRetVal(retVal, ctx);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        if (this.wrapKeys && !MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            MarshalledValue value = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(value);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return this.processRetVal(retVal, ctx);
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        if (this.wrapKeys && !MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            MarshalledValue value = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(value);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return this.processRetVal(retVal, ctx);
    }

    @Override
    public final Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    @Override
    public final Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    private Object visitDataReadCommand(InvocationContext ctx, AbstractDataCommand command) throws Throwable {
        if (this.wrapKeys && !MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            MarshalledValue mv = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(mv);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return this.processRetVal(retVal, ctx);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        if (this.wrapKeys && !MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            MarshalledValue key = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(key);
        }
        if (this.wrapValues && !MarshalledValue.isTypeExcluded(command.getNewValue().getClass())) {
            MarshalledValue newValue = this.createMarshalledValue(command.getNewValue(), ctx);
            command.setNewValue(newValue);
        }
        if (this.wrapValues && command.getOldValue() != null && !MarshalledValue.isTypeExcluded(command.getOldValue().getClass())) {
            MarshalledValue oldValue = this.createMarshalledValue(command.getOldValue(), ctx);
            command.setOldValue(oldValue);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return this.processRetVal(retVal, ctx);
    }

    protected Object processRetVal(Object retVal, InvocationContext ctx) {
        if (retVal instanceof MarshalledValue && ctx.isOriginLocal()) {
            if (trace) {
                log.tracef("Return is a marshall value, so extract instance from: %s", retVal);
            }
            retVal = ((MarshalledValue)retVal).get();
        }
        return retVal;
    }

    protected Map<Object, Object> wrapMap(Map<Object, Object> m, Set<MarshalledValue> marshalledValues, InvocationContext ctx) {
        if (m == null) {
            if (trace) {
                log.trace("Map is nul; returning an empty map.");
            }
            return InfinispanCollections.emptyMap();
        }
        if (trace) {
            log.tracef("Wrapping map contents of argument %s", (Object)m);
        }
        HashMap<Object, Object> copy = new HashMap<Object, Object>(m.size());
        for (Map.Entry<Object, Object> me : m.entrySet()) {
            Object newValue;
            Object key = me.getKey();
            Object value = me.getValue();
            Object newKey = key == null || MarshalledValue.isTypeExcluded(key.getClass()) || !this.wrapKeys ? key : this.createMarshalledValue(key, ctx);
            Object object = newValue = value == null || MarshalledValue.isTypeExcluded(value.getClass()) || !this.wrapValues ? value : this.createMarshalledValue(value, ctx);
            if (newKey instanceof MarshalledValue) {
                marshalledValues.add((MarshalledValue)newKey);
            }
            if (newValue instanceof MarshalledValue) {
                marshalledValues.add((MarshalledValue)newValue);
            }
            copy.put(newKey, newValue);
        }
        return copy;
    }

    protected MarshalledValue createMarshalledValue(Object toWrap, InvocationContext ctx) {
        return new MarshalledValue(toWrap, this.marshaller);
    }
}

