/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CompletionListener;
import javax.cache.management.CacheMXBean;
import javax.cache.management.CacheStatisticsMXBean;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.management.MBeanServer;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheListenerException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.commons.util.concurrent.FutureListener;
import org.infinispan.context.Flag;
import org.infinispan.interceptors.EntryWrappingInterceptor;
import org.infinispan.jcache.ConfigurationAdapter;
import org.infinispan.jcache.Exceptions;
import org.infinispan.jcache.Expiration;
import org.infinispan.jcache.FailureEntryProcessorResult;
import org.infinispan.jcache.JCacheEntry;
import org.infinispan.jcache.JCacheLoaderAdapter;
import org.infinispan.jcache.JCacheNotifier;
import org.infinispan.jcache.JCacheWriterAdapter;
import org.infinispan.jcache.MutableJCacheEntry;
import org.infinispan.jcache.RICacheStatistics;
import org.infinispan.jcache.RIDelegatingCacheMXBean;
import org.infinispan.jcache.RIMBeanServerRegistrationUtility;
import org.infinispan.jcache.SuccessEntryProcessorResult;
import org.infinispan.jcache.interceptor.ExpirationTrackingInterceptor;
import org.infinispan.jcache.logging.Log;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.manager.PersistenceManagerImpl;
import org.infinispan.util.concurrent.locks.containers.LockContainer;
import org.infinispan.util.concurrent.locks.containers.ReentrantPerEntryLockContainer;
import org.infinispan.util.logging.LogFactory;

public class JCache<K, V>
implements Cache<K, V> {
    private static final Log log = LogFactory.getLog(JCache.class, Log.class);
    private final CacheManager cacheManager;
    private final MutableConfiguration<K, V> configuration;
    private final AdvancedCache<K, V> cache;
    private final AdvancedCache<K, V> ignoreReturnValuesCache;
    private final AdvancedCache<K, V> skipCacheLoadCache;
    private final AdvancedCache<K, V> skipCacheLoadAndStatsCache;
    private final AdvancedCache<K, V> skipListenerCache;
    private final RICacheStatistics stats;
    private final CacheMXBean mxBean;
    private final ExpiryPolicy expiryPolicy;
    private final LockContainer processorLocks;
    private final long lockTimeout;
    private final JCacheNotifier<K, V> notifier = new JCacheNotifier();
    private CacheLoader<K, V> jcacheLoader;
    private CacheWriter<? super K, ? super V> jcacheWriter;

    public JCache(AdvancedCache<K, V> cache, CacheManager cacheManager, ConfigurationAdapter<K, V> c) {
        this.cache = cache;
        this.processorLocks = new ReentrantPerEntryLockContainer(32, cache.getCacheConfiguration().dataContainer().keyEquivalence());
        this.ignoreReturnValuesCache = cache.withFlags(Flag.IGNORE_RETURN_VALUES);
        this.skipCacheLoadCache = cache.withFlags(Flag.SKIP_CACHE_LOAD);
        this.skipCacheLoadAndStatsCache = cache.withFlags(Flag.SKIP_CACHE_LOAD, Flag.SKIP_STATISTICS);
        this.skipListenerCache = cache.withFlags(Flag.SKIP_LISTENER_NOTIFICATION);
        this.cacheManager = cacheManager;
        this.configuration = c.getConfiguration();
        this.mxBean = new RIDelegatingCacheMXBean(this);
        this.stats = new RICacheStatistics(this.cache);
        this.expiryPolicy = (ExpiryPolicy)this.configuration.getExpiryPolicyFactory().create();
        this.lockTimeout = cache.getCacheConfiguration().locking().lockAcquisitionTimeout();
        for (CacheEntryListenerConfiguration r : this.configuration.getCacheEntryListenerConfigurations()) {
            this.notifier.addListener(r, this, this.notifier, cache);
        }
        this.setCacheLoader(cache, (CompleteConfiguration<K, V>)this.configuration);
        this.setCacheWriter(cache, (CompleteConfiguration<K, V>)this.configuration);
        this.addExpirationTrackingInterceptor(cache, this.notifier);
        if (this.configuration.isManagementEnabled()) {
            this.setManagementEnabled(true);
        }
        if (this.configuration.isStatisticsEnabled()) {
            this.setStatisticsEnabled(true);
        }
    }

    private void setCacheLoader(AdvancedCache<K, V> cache, CompleteConfiguration<K, V> c) {
        Factory cacheLoaderFactory = c.getCacheLoaderFactory();
        if (cacheLoaderFactory != null) {
            PersistenceManagerImpl persistenceManager = (PersistenceManagerImpl)cache.getComponentRegistry().getComponent(PersistenceManager.class);
            JCacheLoaderAdapter<K, V> adapter = this.getCacheLoaderAdapter(persistenceManager);
            this.jcacheLoader = (CacheLoader)cacheLoaderFactory.create();
            adapter.setCacheLoader(this.jcacheLoader);
            adapter.setExpiryPolicy(this.expiryPolicy);
        }
    }

    private JCacheLoaderAdapter<K, V> getCacheLoaderAdapter(PersistenceManagerImpl persistenceManager) {
        return (JCacheLoaderAdapter)persistenceManager.getAllLoaders().get(0);
    }

    private void setCacheWriter(AdvancedCache<K, V> cache, CompleteConfiguration<K, V> c) {
        Factory cacheWriterFactory = c.getCacheWriterFactory();
        if (cacheWriterFactory != null) {
            PersistenceManagerImpl persistenceManager = (PersistenceManagerImpl)cache.getComponentRegistry().getComponent(PersistenceManager.class);
            JCacheWriterAdapter<? super K, ? super V> ispnCacheStore = this.getCacheWriterAdapter(persistenceManager);
            this.jcacheWriter = (CacheWriter)cacheWriterFactory.create();
            ispnCacheStore.setCacheWriter(this.jcacheWriter);
        }
    }

    private JCacheWriterAdapter<K, V> getCacheWriterAdapter(PersistenceManagerImpl persistenceManager) {
        return (JCacheWriterAdapter)persistenceManager.getAllWriters().get(0);
    }

    private void addExpirationTrackingInterceptor(AdvancedCache<K, V> cache, JCacheNotifier notifier) {
        ExpirationTrackingInterceptor interceptor = new ExpirationTrackingInterceptor(cache.getDataContainer(), this, notifier, cache.getComponentRegistry().getTimeService());
        cache.addInterceptorBefore(interceptor, EntryWrappingInterceptor.class);
    }

    public void clear() {
        this.skipListenerCache.clear();
    }

    public boolean containsKey(final K key) {
        this.checkNotClosed();
        if (log.isTraceEnabled()) {
            log.tracef("Invoke containsKey(key=%s)", (Object)key);
        }
        if (key == null) {
            throw log.parameterMustNotBeNull("key");
        }
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.skipCacheLoadCache.containsKey(key);
                }
            });
        }
        return this.skipCacheLoadAndStatsCache.containsKey(key);
    }

    public V get(final K key) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock().call(key, new Callable<V>(){

                @Override
                public V call() {
                    return JCache.this.doGet(key);
                }
            });
        }
        return this.doGet(key);
    }

    private V doGet(K key) {
        Object value;
        Object v = value = this.configuration.isReadThrough() ? this.cache.get(key) : this.skipCacheLoadCache.get(key);
        if (value != null) {
            this.updateTTLForAccessed(this.cache, key, value);
        }
        return value;
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        this.checkNotClosed();
        this.verifyKeys(keys);
        if (keys.isEmpty()) {
            return InfinispanCollections.emptyMap();
        }
        HashMap<K, V> result = new HashMap<K, V>(keys.size());
        for (K key : keys) {
            V value = this.get(key);
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public V getAndPut(final K key, final V value) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock().call(key, new Callable<V>(){

                @Override
                public V call() {
                    return JCache.this.put(JCache.this.skipCacheLoadCache, JCache.this.skipCacheLoadCache, key, value, false);
                }
            });
        }
        return this.put(this.skipCacheLoadCache, this.skipCacheLoadCache, key, value, false);
    }

    public V getAndRemove(final K key) {
        this.checkNotClosed();
        this.skipCacheLoadCache.get(key);
        if (this.lockRequired(key)) {
            return new WithProcessorLock().call(key, new Callable<V>(){

                @Override
                public V call() {
                    return JCache.this.skipCacheLoadCache.remove(key);
                }
            });
        }
        return this.skipCacheLoadCache.remove(key);
    }

    public V getAndReplace(final K key, final V value) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock().call(key, new Callable<V>(){

                @Override
                public V call() {
                    return JCache.this.replace(JCache.this.skipCacheLoadCache, key, value);
                }
            });
        }
        return this.replace(this.skipCacheLoadCache, key, value);
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void close() {
        this.cache.stop();
    }

    public boolean isClosed() {
        return this.cache.getStatus().isTerminated();
    }

    public String getName() {
        return this.cache.getName();
    }

    public <T> T invoke(final K key, final EntryProcessor<K, V, T> entryProcessor, final Object ... arguments) {
        this.checkNotClosed().checkNull(key, "key").checkNull(entryProcessor, "entryProcessor");
        if (log.isTraceEnabled()) {
            log.tracef("Invoke entry processor %s for key=%s", (Object)entryProcessor, (Object)key);
        }
        return (T)new WithProcessorLock().call(key, new Callable<T>(){

            @Override
            public T call() throws Exception {
                Object oldValue;
                Object safeOldValue = oldValue = JCache.this.skipCacheLoadCache.get(key);
                if (JCache.this.configuration.isStoreByValue()) {
                    safeOldValue = JCache.this.safeCopy(oldValue);
                }
                MutableJCacheEntry mutable = JCache.this.createMutableCacheEntry(safeOldValue, key);
                Object ret = JCache.this.processEntryProcessor(mutable, entryProcessor, arguments);
                switch (mutable.getOperation()) {
                    case NONE: {
                        break;
                    }
                    case ACCESS: {
                        JCache.this.updateTTLForAccessed(JCache.this.cache, key, oldValue);
                        break;
                    }
                    case UPDATE: {
                        Object newValue = mutable.getNewValue();
                        if (oldValue != null) {
                            JCache.this.replace(JCache.this.cache, JCache.this.skipCacheLoadAndStatsCache, key, oldValue, newValue, true);
                            break;
                        }
                        JCache.this.put(JCache.this.cache, JCache.this.skipCacheLoadCache, key, newValue, true);
                        break;
                    }
                    case REMOVE: {
                        JCache.this.cache.remove(key);
                    }
                }
                return ret;
            }
        });
    }

    private <T> T processEntryProcessor(MutableJCacheEntry<K, V> mutable, EntryProcessor<K, V, T> entryProcessor, Object[] arguments) {
        try {
            return (T)entryProcessor.process(mutable, arguments);
        }
        catch (Exception e) {
            throw Exceptions.launderEntryProcessorException(e);
        }
    }

    private MutableJCacheEntry<K, V> createMutableCacheEntry(V safeOldValue, K key) {
        return new MutableJCacheEntry<K, V>(this.configuration.isReadThrough() ? this.cache : this.skipCacheLoadCache, key, safeOldValue);
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.checkNotClosed().checkNull(entryProcessor, "entryProcessor").verifyKeys(keys);
        HashMap map = new HashMap(keys.size());
        for (K key : keys) {
            Object result;
            try {
                T t = this.invoke(key, entryProcessor, arguments);
                result = t == null ? null : new SuccessEntryProcessorResult<T>(t);
            }
            catch (Throwable t) {
                result = new FailureEntryProcessorResult(t);
            }
            if (result == null) continue;
            map.put(key, result);
        }
        return map;
    }

    private V safeCopy(V original) {
        try {
            StreamingMarshaller marshaller = this.skipCacheLoadCache.getComponentRegistry().getCacheMarshaller();
            byte[] bytes = marshaller.objectToByteBuffer(original);
            Object o = marshaller.objectFromByteBuffer(bytes);
            return (V)o;
        }
        catch (Exception e) {
            throw new CacheException("Unexpected error making a copy of entry " + original, (Throwable)e);
        }
    }

    private boolean lockRequired(K key) {
        boolean locked = this.processorLocks.isLocked(key);
        if (log.isTraceEnabled()) {
            log.tracef("Lock required for key=%s? %s", (Object)key, (Object)locked);
        }
        return locked;
    }

    private void acquiredProcessorLock(K key) throws InterruptedException {
        this.processorLocks.acquireLock(Thread.currentThread(), key, this.lockTimeout, TimeUnit.MILLISECONDS);
    }

    private void releaseProcessorLock(K key) {
        this.processorLocks.releaseLock(Thread.currentThread(), key);
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        return new Itr();
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener listener) {
        this.checkNotClosed();
        if (keys == null) {
            throw log.parameterMustNotBeNull("keys");
        }
        if (this.jcacheLoader == null && this.jcacheWriter != null) {
            this.setListenerCompletion(listener);
        } else if (this.jcacheLoader != null) {
            this.loadAllFromJCacheLoader(keys, replaceExistingValues, listener);
        } else {
            this.loadAllFromInfinispanCacheLoader(keys, replaceExistingValues, listener);
        }
    }

    private void setListenerException(CompletionListener listener, Throwable t) {
        if (listener != null) {
            if (t instanceof Exception) {
                listener.onException((Exception)t);
            } else {
                listener.onException((Exception)((Object)new CacheException(t)));
            }
        }
    }

    public void put(final K key, final V value) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            new WithProcessorLock<Void>().call(key, new Callable<Void>(){

                @Override
                public Void call() {
                    JCache.this.doPut(key, value);
                    return null;
                }
            });
        } else {
            this.doPut(key, value);
        }
    }

    public void putAll(Map<? extends K, ? extends V> inputMap) {
        this.checkNotClosed();
        if (inputMap == null || inputMap.containsKey(null) || inputMap.containsValue(null)) {
            throw new NullPointerException("inputMap is null or keys/values contain a null entry: " + inputMap);
        }
        for (final Map.Entry<K, V> e : inputMap.entrySet()) {
            final K key = e.getKey();
            if (this.lockRequired(key)) {
                new WithProcessorLock<Void>().call(key, new Callable<Void>(){

                    @Override
                    public Void call() {
                        JCache.this.doPut(key, e.getValue());
                        return null;
                    }
                });
                continue;
            }
            this.doPut(key, e.getValue());
        }
    }

    private void doPut(K key, V value) {
        this.put(this.ignoreReturnValuesCache, this.skipCacheLoadAndStatsCache, key, value, false);
    }

    public boolean putIfAbsent(final K key, final V value) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.put(JCache.this.skipCacheLoadCache, JCache.this.skipCacheLoadAndStatsCache, key, value, true) == null;
                }
            });
        }
        return this.put(this.skipCacheLoadCache, this.skipCacheLoadAndStatsCache, key, value, true) == null;
    }

    public boolean remove(final K key) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.cache.remove(key) != null;
                }
            });
        }
        try {
            return this.cache.remove(key) != null;
        }
        catch (CacheListenerException e) {
            throw Exceptions.launderCacheListenerException(e);
        }
    }

    public boolean remove(final K key, final V oldValue) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.remove(JCache.this.cache, key, oldValue);
                }
            });
        }
        return this.remove(this.cache, key, oldValue);
    }

    public void removeAll() {
        ArrayList futures = new ArrayList();
        for (final Object e : this.cache.keySet()) {
            if (this.lockRequired(e)) {
                new WithProcessorLock<Void>().call(e, new Callable<Void>(){

                    @Override
                    public Void call() {
                        JCache.this.cache.remove(e);
                        return null;
                    }
                });
                continue;
            }
            futures.add(this.cache.removeAsync(e));
        }
        for (Future future : futures) {
            try {
                future.get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CacheException("Interrupted while waiting for remove to complete");
            }
            catch (Exception e) {
                throw Exceptions.launderCacheWriterException(e);
            }
        }
    }

    public void removeAll(Set<? extends K> keys) {
        this.checkNotClosed();
        this.verifyKeys(keys);
        for (K k : keys) {
            this.remove(k);
        }
    }

    public boolean replace(final K key, final V value) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.replace(JCache.this.skipCacheLoadCache, JCache.this.skipCacheLoadCache, key, null, value, false);
                }
            });
        }
        return this.replace(this.skipCacheLoadCache, this.skipCacheLoadCache, key, null, value, false);
    }

    public boolean replace(final K key, final V oldValue, final V newValue) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.replace(JCache.this.skipCacheLoadCache, JCache.this.skipCacheLoadCache, key, oldValue, newValue, true);
                }
            });
        }
        return this.replace(this.skipCacheLoadCache, this.skipCacheLoadCache, key, oldValue, newValue, true);
    }

    public <T> T unwrap(Class<T> clazz) {
        return ReflectionUtil.unwrapAny(clazz, this, this.cache);
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> listenerCfg) {
        this.notifier.addListener(listenerCfg, this, this.notifier, this.cache);
        this.addCacheEntryListenerConfiguration(listenerCfg);
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> listenerCfg) {
        this.notifier.removeListener(listenerCfg, this.cache);
        this.removeCacheEntryListenerConfiguration(listenerCfg);
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        if (clazz.isInstance(this.configuration)) {
            return (C)((Configuration)clazz.cast(this.configuration));
        }
        throw log.configurationClassNotSupported(clazz);
    }

    void setManagementEnabled(boolean enabled) {
        this.configuration.setManagementEnabled(enabled);
        if (enabled) {
            RIMBeanServerRegistrationUtility.registerCacheObject(this, RIMBeanServerRegistrationUtility.ObjectNameType.CONFIGURATION);
        } else {
            RIMBeanServerRegistrationUtility.unregisterCacheObject(this, RIMBeanServerRegistrationUtility.ObjectNameType.CONFIGURATION);
        }
    }

    void setStatisticsEnabled(boolean enabled) {
        this.cache.getStats().setStatisticsEnabled(enabled);
        this.configuration.setStatisticsEnabled(enabled);
        if (enabled) {
            RIMBeanServerRegistrationUtility.registerCacheObject(this, RIMBeanServerRegistrationUtility.ObjectNameType.STATISTICS);
        } else {
            RIMBeanServerRegistrationUtility.unregisterCacheObject(this, RIMBeanServerRegistrationUtility.ObjectNameType.STATISTICS);
        }
    }

    CacheMXBean getCacheMXBean() {
        return this.mxBean;
    }

    CacheStatisticsMXBean getCacheStatisticsMXBean() {
        return this.stats;
    }

    MBeanServer getMBeanServer() {
        return JmxUtil.lookupMBeanServer(this.cache.getCacheManager().getCacheManagerConfiguration());
    }

    private JCache checkNotClosed() {
        if (this.isClosed()) {
            throw log.cacheClosed(this.cache.getStatus());
        }
        return this;
    }

    private JCache checkNull(Object obj, String name) {
        if (obj == null) {
            throw log.parameterMustNotBeNull(name);
        }
        return this;
    }

    private JCache verifyKeys(Set<? extends K> keys) {
        if (keys == null || keys.contains(null)) {
            throw new NullPointerException("keys is null or keys contains a null: " + keys);
        }
        return this;
    }

    private V put(AdvancedCache<K, V> cache, AdvancedCache<K, V> createCheckCache, K key, V value, boolean isPutIfAbsent) {
        boolean isCreated;
        Object prev = createCheckCache.get(key);
        boolean bl = isCreated = prev == null;
        if (!isCreated && isPutIfAbsent) {
            return prev;
        }
        Duration ttl = isCreated ? Expiration.getExpiry(this.expiryPolicy, Expiration.Operation.CREATION) : Expiration.getExpiry(this.expiryPolicy, Expiration.Operation.UPDATE);
        try {
            Object ret;
            if (ttl == null || ttl.isEternal()) {
                ret = isPutIfAbsent ? cache.putIfAbsent(key, value) : cache.put(key, value);
            } else if (ttl.equals((Object)Duration.ZERO)) {
                ret = !isCreated ? cache.remove(key) : null;
            } else {
                long duration = ttl.getDurationAmount();
                TimeUnit timeUnit = ttl.getTimeUnit();
                ret = isPutIfAbsent ? cache.putIfAbsent(key, value, duration, timeUnit) : cache.put(key, value, duration, timeUnit);
            }
            return ret;
        }
        catch (CacheListenerException e) {
            throw Exceptions.launderCacheListenerException(e);
        }
    }

    private boolean replace(AdvancedCache<K, V> cache, AdvancedCache<K, V> existsCheckCache, K key, V oldValue, V value, boolean isConditional) {
        Object current;
        this.checkNull(value, "value");
        if (isConditional) {
            this.checkNull(oldValue, "oldValue");
        }
        if ((current = existsCheckCache.get(key)) != null) {
            if (isConditional && !current.equals(oldValue)) {
                this.updateTTLForAccessed(cache, key, value);
                return false;
            }
            Duration ttl = Expiration.getExpiry(this.expiryPolicy, Expiration.Operation.UPDATE);
            if (ttl == null || ttl.isEternal()) {
                return isConditional ? cache.replace(key, oldValue, value) : cache.replace(key, value) != null;
            }
            if (ttl.equals((Object)Duration.ZERO)) {
                return cache.remove(key) != null;
            }
            long duration = ttl.getDurationAmount();
            TimeUnit timeUnit = ttl.getTimeUnit();
            return isConditional ? cache.replace(key, oldValue, value, duration, timeUnit) : cache.replace(key, value, duration, timeUnit) != null;
        }
        return false;
    }

    private V replace(AdvancedCache<K, V> cache, K key, V value) {
        this.checkNull(value, "value");
        boolean exists = cache.containsKey(key);
        if (exists) {
            Duration ttl = Expiration.getExpiry(this.expiryPolicy, Expiration.Operation.UPDATE);
            if (ttl == null || ttl.isEternal()) {
                return cache.replace(key, value);
            }
            if (ttl.equals((Object)Duration.ZERO)) {
                return cache.remove(key);
            }
            long duration = ttl.getDurationAmount();
            TimeUnit timeUnit = ttl.getTimeUnit();
            return cache.replace(key, value, duration, timeUnit);
        }
        return null;
    }

    private void updateTTLForAccessed(AdvancedCache<K, V> cache, K key, V value) {
        Duration ttl = Expiration.getExpiry(this.expiryPolicy, Expiration.Operation.ACCESS);
        if (ttl != null) {
            if (ttl.equals((Object)Duration.ZERO)) {
                cache.remove(key);
            } else {
                long durationAmount = ttl.getDurationAmount();
                TimeUnit timeUnit = ttl.getTimeUnit();
                cache.put(key, value, durationAmount, timeUnit);
            }
        }
    }

    private void addCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> listenerCfg) {
        if (listenerCfg == null) {
            throw new NullPointerException("CacheEntryListenerConfiguration can't be null");
        }
        boolean alreadyExists = false;
        for (CacheEntryListenerConfiguration c : this.configuration.getCacheEntryListenerConfigurations()) {
            if (!c.equals(listenerCfg)) continue;
            alreadyExists = true;
        }
        if (alreadyExists) {
            throw new IllegalArgumentException("A CacheEntryListenerConfiguration can be registered only once");
        }
        this.configuration.addCacheEntryListenerConfiguration(listenerCfg);
    }

    private void removeCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> listenerCfg) {
        this.configuration.removeCacheEntryListenerConfiguration(listenerCfg);
    }

    private void loadAllFromInfinispanCacheLoader(Set<? extends K> keys, boolean replaceExistingValues, final CompletionListener listener) {
        final List<K> keysToLoad = this.filterLoadAllKeys(keys, replaceExistingValues, true);
        if (keysToLoad.isEmpty()) {
            this.setListenerCompletion(listener);
            return;
        }
        try {
            final CyclicBarrier barrier = new CyclicBarrier(keysToLoad.size(), new Runnable(){

                @Override
                public void run() {
                    if (log.isTraceEnabled()) {
                        log.tracef("Keys %s loaded, notify listener on completion", (Object)keysToLoad);
                    }
                    JCache.this.setListenerCompletion(listener);
                }
            });
            FutureListener futureListener = new FutureListener<V>(){

                @Override
                public void futureDone(Future<V> future) {
                    try {
                        if (log.isTraceEnabled()) {
                            log.tracef("Key loaded, wait for the rest of keys to load", new Object[0]);
                        }
                        barrier.await(30L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (BrokenBarrierException e) {
                        JCache.this.setListenerException(listener, e);
                    }
                    catch (TimeoutException e) {
                        JCache.this.setListenerException(listener, e);
                    }
                }
            };
            AdvancedCache<K, V> asyncCache = this.cache;
            for (K k : keysToLoad) {
                asyncCache.getAsync(k).attachListener(futureListener);
            }
        }
        catch (Throwable t) {
            log.errorLoadingAll(keysToLoad, t);
            this.setListenerException(listener, t);
        }
    }

    private void setListenerCompletion(CompletionListener listener) {
        if (listener != null) {
            listener.onCompletion();
        }
    }

    private List<K> filterLoadAllKeys(Set<? extends K> keys, boolean replaceExistingValues, boolean cacheEvict) {
        if (log.isTraceEnabled()) {
            log.tracef("Before filtering, keys to load: %s", (Object)keys);
        }
        ArrayList<K> keysToLoad = new ArrayList<K>();
        for (K key : keys) {
            if (key == null) {
                throw log.parameterMustNotBeNull("Key");
            }
            if (cacheEvict && replaceExistingValues && this.containsKey(key)) {
                this.cache.evict(key);
            }
            if (!replaceExistingValues && this.containsKey(key)) continue;
            keysToLoad.add(key);
        }
        if (log.isTraceEnabled()) {
            log.tracef("After filtering, keys to load: %s", (Object)keysToLoad);
        }
        return keysToLoad;
    }

    private void loadAllFromJCacheLoader(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener listener) {
        List<K> keysToLoad = this.filterLoadAllKeys(keys, replaceExistingValues, false);
        if (keysToLoad.isEmpty()) {
            this.setListenerCompletion(listener);
            return;
        }
        try {
            Map<K, V> loaded = this.loadAllKeys(keysToLoad);
            Iterator<Map.Entry<K, V>> it = loaded.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<K, V> entry = it.next();
                if (entry.getValue() != null) continue;
                it.remove();
            }
            AdvancedCache<K, V> skipCacheStoreCache = this.ignoreReturnValuesCache.withFlags(Flag.SKIP_CACHE_STORE);
            for (Map.Entry<K, V> entry : loaded.entrySet()) {
                K loadedKey = entry.getKey();
                V loadedValue = entry.getValue();
                this.put(skipCacheStoreCache, this.skipCacheLoadCache, loadedKey, loadedValue, false);
            }
            this.setListenerCompletion(listener);
        }
        catch (Throwable t) {
            this.setListenerException(listener, t);
        }
    }

    private Map<K, V> loadAllKeys(List<K> keysToLoad) {
        try {
            return this.jcacheLoader.loadAll(keysToLoad);
        }
        catch (Exception e) {
            throw Exceptions.launderCacheLoaderException(e);
        }
    }

    private boolean remove(AdvancedCache<K, V> cache, K key, V oldValue) {
        Object current = cache.get(key);
        if (current != null && !current.equals(oldValue)) {
            this.updateTTLForAccessed(cache, key, current);
            return false;
        }
        return cache.remove(key, oldValue);
    }

    private boolean statisticsEnabled() {
        return this.getConfiguration(CompleteConfiguration.class).isStatisticsEnabled();
    }

    private class Itr
    implements Iterator<Cache.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> it;
        private Cache.Entry<K, V> current;
        private Cache.Entry<K, V> next;

        Itr() {
            this.it = JCache.this.cache.entrySet().iterator();
            this.fetchNext();
        }

        private void fetchNext() {
            long start;
            long l = start = JCache.this.statisticsEnabled() ? System.nanoTime() : 0L;
            if (this.it.hasNext()) {
                Map.Entry entry = this.it.next();
                this.next = new JCacheEntry(entry.getKey(), entry.getValue());
                if (JCache.this.statisticsEnabled()) {
                    JCache.this.stats.increaseCacheHits(1L);
                    JCache.this.stats.addGetTimeNano(System.nanoTime() - start);
                }
            } else {
                this.next = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Cache.Entry<K, V> next() {
            if (this.next == null) {
                this.fetchNext();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Cache.Entry ret = this.next;
            JCache.this.updateTTLForAccessed(JCache.this.cache, this.next.getKey(), this.next.getValue());
            this.current = this.next;
            this.fetchNext();
            return ret;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Object k = this.current.getKey();
            this.current = null;
            JCache.this.cache.remove(k);
        }
    }

    private class WithProcessorLock<V> {
        private WithProcessorLock() {
        }

        public V call(K key, Callable<V> callable) {
            try {
                JCache.this.acquiredProcessorLock(key);
                V v = callable.call();
                return v;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                V v = null;
                return v;
            }
            catch (CacheListenerException e) {
                throw Exceptions.launderCacheListenerException(e);
            }
            catch (EntryProcessorException e) {
                throw e;
            }
            catch (CacheException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EntryProcessorException((Throwable)e);
            }
            finally {
                JCache.this.releaseProcessorLock(key);
            }
        }
    }
}

