/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.infinispan.atomic.DeltaCompositeKey;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.AbstractLockingInterceptor;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;

public abstract class AbstractTxLockingInterceptor
extends AbstractLockingInterceptor {
    protected TransactionTable txTable;
    protected RpcManager rpcManager;
    private boolean clustered;
    private TimeService timeService;

    @Inject
    public void setDependencies(TransactionTable txTable, RpcManager rpcManager, TimeService timeService) {
        this.txTable = txTable;
        this.rpcManager = rpcManager;
        this.clustered = rpcManager != null;
        this.timeService = timeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (command.hasFlag(Flag.PUT_FOR_EXTERNAL_READ)) {
            return this.visitNonTxDataWriteCommand(ctx, command);
        }
        return this.visitDataWriteCommand(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        try {
            Object object = super.visitCommitCommand(ctx, command);
            return object;
        }
        finally {
            if (this.releaseLockOnTxCompletion(ctx)) {
                this.lockManager.unlockAll(ctx);
            }
        }
    }

    protected final Object invokeNextAndCommitIf1Pc(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object result = this.invokeNextInterceptor(ctx, command);
        if (command.isOnePhaseCommit() && this.releaseLockOnTxCompletion(ctx)) {
            this.lockManager.unlockAll(ctx);
        }
        return result;
    }

    protected final void lockAndRegisterBackupLock(TxInvocationContext ctx, Object key, long lockTimeout, boolean skipLocking) throws InterruptedException {
        Object keyToCheck;
        Object object = keyToCheck = key instanceof DeltaCompositeKey ? ((DeltaCompositeKey)key).getDeltaAwareValueKey() : key;
        if (this.cdl.localNodeIsPrimaryOwner(keyToCheck)) {
            this.lockKeyAndCheckOwnership(ctx, key, lockTimeout, skipLocking);
        } else if (this.cdl.localNodeIsOwner(keyToCheck)) {
            ((AbstractCacheTransaction)ctx.getCacheTransaction()).addBackupLockForKey(key);
        }
    }

    protected final void lockKeyAndCheckOwnership(InvocationContext ctx, Object key, long lockTimeout, boolean skipLocking) throws InterruptedException {
        TxInvocationContext txContext = (TxInvocationContext)ctx;
        int transactionTopologyId = -1;
        boolean checkForPendingLocks = false;
        if (this.clustered) {
            boolean isFromStateTransfer;
            Object tx = txContext.getCacheTransaction();
            boolean bl = isFromStateTransfer = txContext.isOriginLocal() && ((LocalTransaction)tx).isFromStateTransfer();
            if (!isFromStateTransfer && (transactionTopologyId = tx.getTopologyId()) != -1) {
                checkForPendingLocks = this.txTable.getMinTopologyId() < transactionTopologyId;
            }
        }
        Log log = this.getLog();
        boolean trace = log.isTraceEnabled();
        if (checkForPendingLocks) {
            if (trace) {
                log.tracef("Checking for pending locks and then locking key %s", (Object)Util.toStr(key));
            }
            long expectedEndTime = this.timeService.expectedEndTime(this.cacheConfiguration.locking().lockAcquisitionTimeout(), TimeUnit.MILLISECONDS);
            this.waitForTransactionsToComplete(txContext, this.txTable.getLocalTransactions(), key, transactionTopologyId, expectedEndTime);
            this.waitForTransactionsToComplete(txContext, this.txTable.getRemoteTransactions(), key, transactionTopologyId, expectedEndTime);
            if (trace) {
                log.tracef("Finished waiting for other potential lockers, trying to acquire the lock on %s", (Object)Util.toStr(key));
            }
            long remaining = this.timeService.remainingTime(expectedEndTime, TimeUnit.MILLISECONDS);
            this.lockManager.acquireLock(ctx, key, remaining, skipLocking);
        } else {
            if (trace) {
                log.tracef("Locking key %s, no need to check for pending locks.", (Object)Util.toStr(key));
            }
            this.lockManager.acquireLock(ctx, key, lockTimeout, skipLocking);
        }
    }

    private void waitForTransactionsToComplete(TxInvocationContext txContext, Collection<? extends CacheTransaction> transactions, Object key, int transactionTopologyId, long expectedEndTime) throws InterruptedException {
        GlobalTransaction thisTransaction = txContext.getGlobalTransaction();
        for (CacheTransaction cacheTransaction : transactions) {
            long remaining;
            if (cacheTransaction.getTopologyId() >= transactionTopologyId || cacheTransaction.getGlobalTransaction().equals(thisTransaction)) continue;
            boolean txCompleted = false;
            while ((remaining = this.timeService.remainingTime(expectedEndTime, TimeUnit.MILLISECONDS)) > 0L) {
                if (!cacheTransaction.waitForLockRelease(key, remaining)) continue;
                txCompleted = true;
                break;
            }
            if (txCompleted) continue;
            throw this.newTimeoutException(key, cacheTransaction, txContext);
        }
    }

    private TimeoutException newTimeoutException(Object key, TxInvocationContext txContext) {
        return new TimeoutException("Could not acquire lock on " + key + " on behalf of transaction " + txContext.getGlobalTransaction() + "." + "Lock is being held by " + this.lockManager.getOwner(key));
    }

    private TimeoutException newTimeoutException(Object key, CacheTransaction tx, TxInvocationContext txContext) {
        return new TimeoutException("Could not acquire lock on " + key + " on behalf of transaction " + txContext.getGlobalTransaction() + ". Waiting to complete tx: " + tx + ".");
    }

    private boolean releaseLockOnTxCompletion(TxInvocationContext ctx) {
        return ctx.isOriginLocal() || Configurations.isSecondPhaseAsync(this.cacheConfiguration);
    }
}

