/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;

public class AsyncStoreConfiguration {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder("enabled", false).immutable().build();
    public static final AttributeDefinition<Long> FLUSH_LOCK_TIMEOUT = AttributeDefinition.builder("flushLockTimeout", 1L).build();
    public static final AttributeDefinition<Integer> MODIFICATION_QUEUE_SIZE = AttributeDefinition.builder("modificationQueueSize", 1024).immutable().build();
    public static final AttributeDefinition<Long> SHUTDOWN_TIMEOUT = AttributeDefinition.builder("shutdownTimeout", TimeUnit.SECONDS.toMillis(25L)).build();
    public static final AttributeDefinition<Integer> THREAD_POOL_SIZE = AttributeDefinition.builder("threadPoolSize", 1).immutable().build();
    private final Attribute<Boolean> enabled;
    private final Attribute<Long> flushLockTimeout;
    private final Attribute<Integer> modificationQueueSize;
    private final Attribute<Long> shutdownTimeout;
    private final Attribute<Integer> threadPoolSize;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AsyncStoreConfiguration.class, ENABLED, FLUSH_LOCK_TIMEOUT, MODIFICATION_QUEUE_SIZE, SHUTDOWN_TIMEOUT, THREAD_POOL_SIZE);
    }

    AsyncStoreConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.flushLockTimeout = attributes.attribute(FLUSH_LOCK_TIMEOUT);
        this.modificationQueueSize = attributes.attribute(MODIFICATION_QUEUE_SIZE);
        this.shutdownTimeout = attributes.attribute(SHUTDOWN_TIMEOUT);
        this.threadPoolSize = attributes.attribute(THREAD_POOL_SIZE);
    }

    public boolean enabled() {
        return this.enabled.get();
    }

    public long flushLockTimeout() {
        return this.flushLockTimeout.get();
    }

    public AsyncStoreConfiguration flushLockTimeout(long l) {
        this.flushLockTimeout.set(l);
        return this;
    }

    public int modificationQueueSize() {
        return this.modificationQueueSize.get();
    }

    public long shutdownTimeout() {
        return this.shutdownTimeout.get();
    }

    public AsyncStoreConfiguration shutdownTimeout(long l) {
        this.shutdownTimeout.set(l);
        return this;
    }

    public int threadPoolSize() {
        return this.threadPoolSize.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "AsyncStoreConfiguration [attributes=" + this.attributes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AsyncStoreConfiguration other = (AsyncStoreConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }
}

