/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.DeadlockDetectionConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;

public class DeadlockDetectionConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<DeadlockDetectionConfiguration> {
    private final AttributeSet attributes = DeadlockDetectionConfiguration.attributeDefinitionSet();

    DeadlockDetectionConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public DeadlockDetectionConfigurationBuilder spinDuration(long l) {
        this.attributes.attribute(DeadlockDetectionConfiguration.SPIN_DURATION).set(l);
        return this;
    }

    public DeadlockDetectionConfigurationBuilder spinDuration(long l, TimeUnit unit) {
        return this.spinDuration(unit.toMillis(l));
    }

    public DeadlockDetectionConfigurationBuilder enable() {
        this.attributes.attribute(DeadlockDetectionConfiguration.ENABLED).set(true);
        return this;
    }

    public DeadlockDetectionConfigurationBuilder disable() {
        this.attributes.attribute(DeadlockDetectionConfiguration.ENABLED).set(false);
        return this;
    }

    public DeadlockDetectionConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(DeadlockDetectionConfiguration.ENABLED).set(enabled);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public DeadlockDetectionConfiguration create() {
        return new DeadlockDetectionConfiguration(this.attributes.protect());
    }

    public DeadlockDetectionConfigurationBuilder read(DeadlockDetectionConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "DeadlockDetectionConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

