/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.SyncConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;

public class SyncConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder
implements Builder<SyncConfiguration> {
    private final AttributeSet attributes = SyncConfiguration.attributeDefinitionSet();

    protected SyncConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    public SyncConfigurationBuilder replTimeout(long l) {
        this.attributes.attribute(SyncConfiguration.REPL_TIMEOUT).set(l);
        return this;
    }

    public SyncConfigurationBuilder replTimeout(long l, TimeUnit unit) {
        return this.replTimeout(unit.toMillis(l));
    }

    @Override
    public void validate() {
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public SyncConfiguration create() {
        return new SyncConfiguration(this.attributes.protect());
    }

    public SyncConfigurationBuilder read(SyncConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "SyncConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

