/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.io;

import org.infinispan.Cache;
import org.infinispan.io.GridFile;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;

class FileChunkMapper {
    private static final Log log = LogFactory.getLog(FileChunkMapper.class);
    private final GridFile file;
    private final Cache<String, byte[]> cache;

    public FileChunkMapper(GridFile file, Cache<String, byte[]> cache) {
        this.file = file;
        this.cache = cache;
    }

    public int getChunkSize() {
        return this.file.getChunkSize();
    }

    public byte[] fetchChunk(int chunkNumber) {
        String key = this.getChunkKey(chunkNumber);
        byte[] val = (byte[])this.cache.get(key);
        if (log.isTraceEnabled()) {
            log.trace("fetching key=" + key + ": " + (val != null ? val.length + " bytes" : "null"));
        }
        return val;
    }

    public void storeChunk(int chunkNumber, byte[] buffer, int length) {
        String key = this.getChunkKey(chunkNumber);
        byte[] val = this.trim(buffer, length);
        this.cache.put(key, val);
        if (log.isTraceEnabled()) {
            log.trace("put(): key=" + key + ": " + val.length + " bytes");
        }
    }

    public void removeChunk(int chunkNumber) {
        this.cache.remove(this.getChunkKey(chunkNumber));
    }

    private byte[] trim(byte[] buffer, int length) {
        byte[] val = new byte[length];
        System.arraycopy(buffer, 0, val, 0, length);
        return val;
    }

    private String getChunkKey(int chunkNumber) {
        return FileChunkMapper.getChunkKey(this.file.getAbsolutePath(), chunkNumber);
    }

    static String getChunkKey(String absoluteFilePath, int chunkNumber) {
        return absoluteFilePath + ".#" + chunkNumber;
    }
}

