/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.AuthorizationConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalSecurityConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.registry.ClusterRegistry;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.impl.AuthorizationHelper;

public class AuthorizationManagerImpl
implements AuthorizationManager {
    private GlobalSecurityConfiguration globalConfiguration;
    private AuthorizationConfiguration configuration;
    private AuthorizationHelper authzHelper;

    @Inject
    public void init(Cache<?, ?> cache, GlobalConfiguration globalConfiguration, Configuration configuration, ClusterRegistry<String, Subject, Integer> clusterRegistry) {
        this.globalConfiguration = globalConfiguration.security();
        this.configuration = configuration.security().authorization();
        this.authzHelper = new AuthorizationHelper(this.globalConfiguration, AuditContext.CACHE, cache.getName(), clusterRegistry);
    }

    @Override
    public void checkPermission(AuthorizationPermission perm) {
        this.authzHelper.checkPermission(this.configuration, perm);
    }
}

