/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractCloseableIteratorCollection;
import org.infinispan.commands.read.AbstractLocalCommand;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorSet;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.filter.AcceptAllKeyValueFilter;
import org.infinispan.filter.NullValueConverter;

public class KeySetCommand<K, V>
extends AbstractLocalCommand
implements VisitableCommand {
    private final Cache<K, V> cache;

    public KeySetCommand(Cache<K, V> cache, Set<Flag> flags) {
        this.setFlags(flags);
        this.cache = flags != null ? cache.getAdvancedCache().withFlags(flags.toArray(new Flag[flags.size()])) : cache;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitKeySetCommand(ctx, this);
    }

    @Override
    public Set<K> perform(InvocationContext ctx) throws Throwable {
        return new BackingKeySet<K, V>(this.cache);
    }

    public String toString() {
        return "KeySetCommand{cache=" + this.cache.getName() + '}';
    }

    private static class EntryToKeyIterator<K>
    implements CloseableIterator<K> {
        private final CloseableIterator<CacheEntry<K, Void>> iterator;

        public EntryToKeyIterator(CloseableIterator<CacheEntry<K, Void>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            return ((CacheEntry)this.iterator.next()).getKey();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public void close() {
            this.iterator.close();
        }
    }

    private static class BackingKeySet<K, V>
    extends AbstractCloseableIteratorCollection<K, K, V>
    implements CloseableIteratorSet<K> {
        public BackingKeySet(Cache<K, V> cache) {
            super(cache);
        }

        @Override
        public CloseableIterator<K> iterator() {
            return new EntryToKeyIterator(this.cache.getAdvancedCache().filterEntries(AcceptAllKeyValueFilter.getInstance()).converter(NullValueConverter.getInstance()).iterator());
        }

        @Override
        public boolean contains(Object o) {
            return this.cache.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.cache.remove(o) != null;
        }
    }
}

