/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Membership;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.MergeData;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Digest;
import org.jgroups.util.MergeId;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.ResponseCollector;
import org.jgroups.util.Util;

public class Merger {
    private final GMS gms;
    private final Log log = LogFactory.getLog(this.getClass());
    private final MergeTask merge_task = new MergeTask();
    private final ResponseCollector<MergeData> merge_rsps = new ResponseCollector();
    private final ResponseCollector<Digest> digest_collector = new ResponseCollector();
    private final Lock merge_lock = new ReentrantLock();
    private MergeId merge_id = null;
    protected final BoundedList<MergeId> merge_id_history = new BoundedList(20);
    private Future<?> merge_killer = null;
    private final Lock merge_killer_lock = new ReentrantLock();

    public Merger(GMS gms) {
        this.gms = gms;
    }

    public String getMergeIdAsString() {
        return this.merge_id != null ? this.merge_id.toString() : null;
    }

    public String getMergeIdHistory() {
        return this.merge_id_history.toString();
    }

    public void merge(Map<Address, View> views) {
        if (this.isMergeInProgress()) {
            this.log.trace("%s: merge is already running (merge_id=%s)", this.gms.local_addr, this.merge_id);
            return;
        }
        Collection<Address> coords = Util.determineActualMergeCoords(views);
        if (coords.isEmpty()) {
            this.log.error("%s: unable to determine merge leader from %s; not starting a merge", this.gms.local_addr, views);
            return;
        }
        Membership tmp = new Membership(coords);
        tmp.sort();
        Address merge_leader = tmp.elementAt(0);
        if (merge_leader.equals(this.gms.local_addr)) {
            if (this.log.isDebugEnabled()) {
                Collection<Address> merge_participants = Util.determineMergeParticipants(views);
                this.log.debug("%s: I will be the leader. Starting the merge task for %d coords", this.gms.local_addr, merge_participants.size());
            }
            this.merge_task.start(views);
        } else {
            this.log.trace("%s: I'am not the merge leader, waiting for merge leader (%s) to initiate merge", this.gms.local_addr, merge_leader);
        }
    }

    public void handleMergeRequest(Address sender, MergeId merge_id, Collection<? extends Address> mbrs) {
        try {
            this._handleMergeRequest(sender, merge_id, mbrs);
        }
        catch (Throwable t) {
            this.log.error("%s: failure handling the merge request: %s", this.gms.local_addr, t.getMessage());
            this.cancelMerge(merge_id);
            this.sendMergeRejectedResponse(sender, merge_id);
        }
    }

    protected void _handleMergeRequest(Address sender, MergeId merge_id, Collection<? extends Address> mbrs) throws Exception {
        ViewId tmp_vid;
        boolean success;
        MergeId current_merge_id = this.merge_id;
        boolean bl = success = this.matchMergeId(merge_id) || this.setMergeId(null, merge_id);
        if (!success) {
            this.log.trace("%s: merge %s is already in progress, received merge-id=%s", this.gms.local_addr, current_merge_id, merge_id);
            return;
        }
        this.log.trace("%s: got merge request from %s, merge_id=%s, mbrs=%s", this.gms.local_addr, sender, merge_id, mbrs);
        ArrayList<Address> members = new ArrayList<Address>(mbrs != null ? mbrs.size() : 32);
        if (mbrs != null) {
            for (Address address : mbrs) {
                if (members.contains(address)) continue;
                members.add(address);
            }
        }
        if ((tmp_vid = this.gms.getViewId()) == null) {
            throw new Exception("view ID is null; cannot return merge response");
        }
        View view = new View(tmp_vid, members);
        if (this.gms.flushProtocolInStack && !this.gms.startFlush(view)) {
            throw new Exception("flush failed");
        }
        Digest digest = this.fetchDigestsFromAllMembersInSubPartition(view, merge_id);
        if (digest == null || digest.capacity() == 0) {
            throw new Exception("failed fetching digests from subpartition members; dropping merge response");
        }
        this.sendMergeResponse(sender, view, digest, merge_id);
    }

    public void handleMergeResponse(MergeData data, MergeId merge_id) {
        if (!this.matchMergeId(merge_id)) {
            this.log.trace("%s: this.merge_id (%s) is different from merge_id %s sent by %s as merge response, discarding it", this.gms.local_addr, this.merge_id, merge_id, data.getSender());
            return;
        }
        this.merge_rsps.add(data.getSender(), data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMergeView(MergeData data, MergeId merge_id) {
        if (!this.matchMergeId(merge_id)) {
            this.log.trace("%s: merge_ids (mine: %s, received: %s) don't match; merge view %s is discarded", this.gms.local_addr, this.merge_id, merge_id, data.view.getViewId());
            return;
        }
        ArrayList<Address> newViewMembers = new ArrayList<Address>(data.view.getMembers());
        newViewMembers.removeAll(this.gms.members.getMembers());
        try {
            this.gms.castViewChange(data.view, data.digest, newViewMembers);
            if (this.gms.flushProtocolInStack) {
                Message ack = new Message(data.getSender()).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL).putHeader(this.gms.getId(), new GMS.GmsHeader(12));
                this.gms.getDownProtocol().down(new Event(1, ack));
            }
        }
        finally {
            this.cancelMerge(merge_id);
        }
    }

    public void handleMergeCancelled(MergeId merge_id) {
        try {
            this.gms.stopFlush();
        }
        catch (Throwable t) {
            this.log.error("stop flush failed", t.getMessage());
        }
        this.log.trace("%s: merge %s is cancelled", this.gms.local_addr, merge_id);
        this.cancelMerge(merge_id);
    }

    public void handleDigestResponse(Address sender, Digest digest) {
        this.digest_collector.add(sender, digest);
    }

    public static void sanitizeViews(Map<Address, View> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<Address, View> entry : map.entrySet()) {
            Address key = entry.getKey();
            ArrayList<Address> members = new ArrayList<Address>(entry.getValue().getMembers());
            boolean modified = false;
            Iterator it = members.iterator();
            while (it.hasNext()) {
                View view;
                List<Address> tmp_mbrs;
                Address val = (Address)it.next();
                if (val.equals(key) || (tmp_mbrs = (view = map.get(val)) != null ? view.getMembers() : null) == null || tmp_mbrs.contains(key)) continue;
                it.remove();
                modified = true;
            }
            if (!modified) continue;
            View old_view = entry.getValue();
            entry.setValue(new View(old_view.getViewId(), members));
        }
    }

    private void sendMergeResponse(Address sender, View view, Digest digest, MergeId merge_id) {
        Message msg = new Message(sender).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL).putHeader(this.gms.getId(), new GMS.GmsHeader(7).mergeId(merge_id)).setBuffer(GMS.marshal(view, digest));
        this.gms.getDownProtocol().down(new Event(1, msg));
    }

    private void sendMergeView(Collection<Address> coords, MergeData combined_merge_data, MergeId merge_id) {
        if (coords == null || combined_merge_data == null) {
            return;
        }
        View view = combined_merge_data.view;
        Digest digest = combined_merge_data.digest;
        if (view == null || digest == null) {
            this.log.error("view or digest is null, cannot send consolidated merge view/digest");
            return;
        }
        int size = 0;
        if (this.gms.flushProtocolInStack) {
            this.gms.merge_ack_collector.reset(coords);
            size = this.gms.merge_ack_collector.size();
        }
        long start = System.currentTimeMillis();
        for (Address coord : coords) {
            Message msg = new Message(coord).setBuffer(GMS.marshal(view, digest)).putHeader(this.gms.getId(), new GMS.GmsHeader(8).mergeId(merge_id));
            this.gms.getDownProtocol().down(new Event(1, msg));
        }
        if (this.gms.flushProtocolInStack) {
            try {
                this.gms.merge_ack_collector.waitForAllAcks(this.gms.view_ack_collection_timeout);
                this.log.trace("%s: received all ACKs (%d) for merge view %s in %d ms", this.gms.local_addr, size, view, System.currentTimeMillis() - start);
            }
            catch (TimeoutException e) {
                this.log.warn("%s: failed to collect all ACKs (%d) for merge view %s after %d ms, missing ACKs from %s", this.gms.local_addr, size, view, this.gms.view_ack_collection_timeout, this.gms.merge_ack_collector.printMissing());
            }
        }
    }

    protected void sendMergeRejectedResponse(Address sender, MergeId merge_id) {
        Message msg = new Message(sender).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL).putHeader(this.gms.getId(), new GMS.GmsHeader(7).mergeId(merge_id).mergeRejected(true));
        this.gms.getDownProtocol().down(new Event(1, msg));
    }

    private void sendMergeCancelledMessage(Collection<Address> coords, MergeId merge_id) {
        if (coords == null || merge_id == null) {
            return;
        }
        for (Address coord : coords) {
            Message msg = new Message(coord).putHeader(this.gms.getId(), new GMS.GmsHeader(9).mergeId(merge_id));
            this.gms.getDownProtocol().down(new Event(1, msg));
        }
    }

    private Digest fetchDigestsFromAllMembersInSubPartition(View view, MergeId merge_id) {
        List<Address> current_mbrs = view.getMembers();
        if (current_mbrs == null || current_mbrs.size() == 1 && current_mbrs.get(0).equals(this.gms.local_addr)) {
            return new MutableDigest(view.getMembersRaw()).set((Digest)this.gms.getDownProtocol().down(new Event(39, this.gms.local_addr)));
        }
        Message get_digest_req = new Message().setFlag(Message.Flag.OOB, Message.Flag.INTERNAL).putHeader(this.gms.getId(), new GMS.GmsHeader(13).mergeId(merge_id));
        long max_wait_time = this.gms.merge_timeout / 2L;
        this.digest_collector.reset(current_mbrs);
        this.gms.getDownProtocol().down(new Event(1, get_digest_req));
        Digest digest = (Digest)this.gms.getDownProtocol().down(new Event(39, this.gms.local_addr));
        this.digest_collector.add(this.gms.local_addr, digest);
        this.digest_collector.waitForAllResponses(max_wait_time);
        if (this.log.isTraceEnabled()) {
            if (this.digest_collector.hasAllResponses()) {
                this.log.trace("%s: fetched all digests for %s", this.gms.local_addr, current_mbrs);
            } else {
                this.log.trace("%s: fetched incomplete digests (after timeout of %d) ms for %s", this.gms.local_addr, max_wait_time, current_mbrs);
            }
        }
        ArrayList<Address> valid_rsps = new ArrayList<Address>(current_mbrs);
        valid_rsps.removeAll(this.digest_collector.getMissing());
        Address[] tmp = new Address[valid_rsps.size()];
        valid_rsps.toArray(tmp);
        MutableDigest retval = new MutableDigest(tmp);
        HashMap<Address, Digest> responses = new HashMap<Address, Digest>(this.digest_collector.getResults());
        for (Digest dig : responses.values()) {
            retval.set(dig);
        }
        return retval;
    }

    void fixDigests() {
        Digest digest = this.fetchDigestsFromAllMembersInSubPartition(this.gms.view, null);
        Message msg = new Message().putHeader(this.gms.getId(), new GMS.GmsHeader(15)).setBuffer(GMS.marshal(null, digest));
        this.gms.getDownProtocol().down(new Event(1, msg));
    }

    void stop() {
        this.merge_task.stop();
    }

    void cancelMerge(MergeId id) {
        if (this.setMergeId(id, null)) {
            this.merge_task.stop();
            this.stopMergeKiller();
            this.merge_rsps.reset();
            this.gms.getViewHandler().resume();
            this.gms.getDownProtocol().down(new Event(66));
        }
    }

    boolean isMergeTaskRunning() {
        return this.merge_task.isRunning();
    }

    boolean isMergeKillerTaskRunning() {
        return this.merge_killer != null && !this.merge_killer.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceCancelMerge() {
        this.merge_lock.lock();
        try {
            if (this.merge_id != null) {
                this.cancelMerge(this.merge_id);
            }
        }
        finally {
            this.merge_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setMergeId(MergeId expected, MergeId new_value) {
        this.merge_lock.lock();
        try {
            boolean match = Util.match(this.merge_id, expected);
            if (match) {
                if (new_value != null && this.merge_id_history.contains(new_value)) {
                    boolean bl = false;
                    return bl;
                }
                this.merge_id_history.add(new_value);
                this.merge_id = new_value;
                if (this.merge_id != null) {
                    this.gms.getViewHandler().suspend();
                    this.gms.getDownProtocol().down(new Event(65, 20000));
                    this.startMergeKiller();
                }
            }
            boolean bl = match;
            return bl;
        }
        finally {
            this.merge_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MergeId getMergeId() {
        this.merge_lock.lock();
        try {
            MergeId mergeId = this.merge_id;
            return mergeId;
        }
        finally {
            this.merge_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMergeInProgress() {
        this.merge_lock.lock();
        try {
            boolean bl = this.merge_id != null;
            return bl;
        }
        finally {
            this.merge_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matchMergeId(MergeId id) {
        this.merge_lock.lock();
        try {
            boolean bl = Util.match(this.merge_id, id);
            return bl;
        }
        finally {
            this.merge_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMergeKiller() {
        this.merge_killer_lock.lock();
        try {
            if (this.merge_killer == null || this.merge_killer.isDone()) {
                MergeKiller task = new MergeKiller(this.merge_id);
                this.merge_killer = this.gms.timer.schedule(task, this.gms.merge_timeout * 2L, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.merge_killer_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMergeKiller() {
        this.merge_killer_lock.lock();
        try {
            if (this.merge_killer != null) {
                this.merge_killer.cancel(false);
                this.merge_killer = null;
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.merge_killer_lock.unlock();
        }
    }

    private class MergeKiller
    implements Runnable {
        private final MergeId my_merge_id;

        MergeKiller(MergeId my_merge_id) {
            this.my_merge_id = my_merge_id;
        }

        @Override
        public void run() {
            Merger.this.cancelMerge(this.my_merge_id);
        }

        public String toString() {
            return Merger.class.getSimpleName() + ": " + this.getClass().getSimpleName();
        }
    }

    protected class MergeTask
    implements Runnable {
        protected Thread thread = null;
        protected final ConcurrentMap<Address, Collection<Address>> coords = Util.createConcurrentMap(8, 0.75f, 8);
        protected final Set<View> subviews = new HashSet<View>();

        protected MergeTask() {
        }

        public synchronized void start(Map<Address, View> views) {
            if (this.thread != null && this.thread.isAlive()) {
                return;
            }
            this.coords.clear();
            this.subviews.clear();
            this.subviews.addAll(views.values());
            Merger.sanitizeViews(views);
            Collection<Address> coordinators = Util.determineMergeCoords(views);
            for (Address coord : coordinators) {
                View view = views.get(coord);
                if (view == null) continue;
                this.coords.put(coord, new ArrayList<Address>(view.getMembers()));
            }
            Collection<Address> merge_participants = Util.determineMergeParticipants(views);
            merge_participants.removeAll(coordinators);
            for (Address merge_participant : merge_participants) {
                ArrayList<Address> tmp = new ArrayList<Address>();
                tmp.add(merge_participant);
                this.coords.putIfAbsent(merge_participant, tmp);
            }
            this.thread = Merger.this.gms.getThreadFactory().newThread(this, "MergeTask");
            this.thread.setDaemon(true);
            this.thread.start();
        }

        public synchronized void stop() {
            Thread tmp = this.thread;
            if (this.thread != null && this.thread.isAlive()) {
                tmp.interrupt();
            }
            this.thread = null;
        }

        public synchronized boolean isRunning() {
            return this.thread != null && this.thread.isAlive();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MergeId new_merge_id = MergeId.create(((Merger)Merger.this).gms.local_addr);
            ArrayList<Address> coordsCopy = new ArrayList<Address>(this.coords.keySet());
            long start = System.currentTimeMillis();
            try {
                this._run(new_merge_id, coordsCopy);
            }
            catch (Throwable ex) {
                if (ex instanceof Error || ex instanceof RuntimeException) {
                    Merger.this.log.warn(((Merger)Merger.this).gms.local_addr + ": merge is cancelled", ex);
                } else {
                    Merger.this.log.warn("%s: merge is cancelled: %s", ((Merger)Merger.this).gms.local_addr, ex.getMessage());
                }
                Merger.this.sendMergeCancelledMessage(coordsCopy, new_merge_id);
                Merger.this.cancelMerge(new_merge_id);
            }
            finally {
                if (((Merger)Merger.this).gms.flushProtocolInStack) {
                    Merger.this.gms.stopFlush();
                }
                this.thread = null;
            }
            long diff = System.currentTimeMillis() - start;
            Merger.this.log.debug("%s: merge %s took %d ms", ((Merger)Merger.this).gms.local_addr, new_merge_id, diff);
        }

        protected void _run(MergeId new_merge_id, Collection<Address> coordsCopy) throws Exception {
            boolean success = Merger.this.setMergeId(null, new_merge_id);
            if (!success) {
                Merger.this.log.warn("%s: failed to set my own merge_id (%s) to %s", ((Merger)Merger.this).gms.local_addr, Merger.this.merge_id, new_merge_id);
                return;
            }
            Merger.this.log.debug("%s: merge task %s started with %d coords", ((Merger)Merger.this).gms.local_addr, Merger.this.merge_id, this.coords.keySet().size());
            success = this.getMergeDataFromSubgroupCoordinators(this.coords, new_merge_id, ((Merger)Merger.this).gms.merge_timeout);
            List<Address> missing = null;
            if (!success) {
                missing = Merger.this.merge_rsps.getMissing();
                Merger.this.log.debug("%s: merge leader %s did not get responses from all %d partition coordinators; missing responses from %d members, removing them from the merge", ((Merger)Merger.this).gms.local_addr, ((Merger)Merger.this).gms.local_addr, this.coords.keySet().size(), missing.size());
                Merger.this.merge_rsps.remove(missing);
            }
            if (missing != null && !missing.isEmpty()) {
                this.coords.keySet().removeAll(missing);
                coordsCopy.removeAll(missing);
            }
            this.removeRejectedMergeRequests(this.coords.keySet());
            if (Merger.this.merge_rsps.size() == 0) {
                throw new Exception("did not get any merge responses from partition coordinators");
            }
            if (!this.coords.keySet().contains(((Merger)Merger.this).gms.local_addr)) {
                throw new Exception("merge leader rejected merge request");
            }
            ArrayList<MergeData> merge_data = new ArrayList<MergeData>(Merger.this.merge_rsps.getResults().values());
            MergeData combined_merge_data = this.consolidateMergeData(merge_data, new ArrayList<View>(this.subviews));
            if (combined_merge_data == null) {
                throw new Exception("could not consolidate merge");
            }
            Merger.this.log.debug("%s: installing merge view %s (%d members) in %d coords", ((Merger)Merger.this).gms.local_addr, combined_merge_data.view.getViewId(), combined_merge_data.view.size(), this.coords.keySet().size());
            Merger.this.sendMergeView(this.coords.keySet(), combined_merge_data, new_merge_id);
        }

        protected boolean getMergeDataFromSubgroupCoordinators(Map<Address, Collection<Address>> coords, MergeId new_merge_id, long timeout) {
            long start = System.currentTimeMillis();
            Merger.this.merge_rsps.reset(coords.keySet());
            Merger.this.log.trace("%s: sending MERGE_REQ to %s", ((Merger)Merger.this).gms.local_addr, coords.keySet());
            for (Map.Entry<Address, Collection<Address>> entry : coords.entrySet()) {
                Address coord = entry.getKey();
                Collection<Address> mbrs = entry.getValue();
                Message msg = new Message(coord).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL).putHeader(Merger.this.gms.getId(), new GMS.GmsHeader(6).mbr(((Merger)Merger.this).gms.local_addr).mergeId(new_merge_id)).setBuffer(GMS.marshal(mbrs));
                Merger.this.gms.getDownProtocol().down(new Event(1, msg));
            }
            Merger.this.merge_rsps.waitForAllResponses(timeout);
            boolean gotAllResponses = Merger.this.merge_rsps.hasAllResponses();
            long stop = System.currentTimeMillis();
            Merger.this.log.trace("%s: collected %d merge response(s) in %d ms", ((Merger)Merger.this).gms.local_addr, Merger.this.merge_rsps.numberOfValidResponses(), stop - start);
            return gotAllResponses;
        }

        private void removeRejectedMergeRequests(Collection<Address> coords) {
            int num_removed = 0;
            Iterator it = Merger.this.merge_rsps.getResults().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                MergeData data = (MergeData)entry.getValue();
                if (!data.merge_rejected) continue;
                if (data.getSender() != null) {
                    coords.remove(data.getSender());
                }
                it.remove();
                ++num_removed;
            }
            if (num_removed > 0) {
                Merger.this.log.trace("%s: removed %d rejected merge responses", ((Merger)Merger.this).gms.local_addr, num_removed);
            }
        }

        protected MergeData consolidateMergeData(List<MergeData> merge_rsps, List<View> subviews) {
            Address new_coord;
            long logical_time = 0L;
            ArrayList<Collection<Address>> sub_mbrships = new ArrayList<Collection<Address>>();
            HashSet<Address> digest_membership = new HashSet<Address>();
            for (MergeData mergeData : merge_rsps) {
                Digest digest;
                View tmp_view = mergeData.getView();
                if (tmp_view != null) {
                    ViewId viewId = tmp_view.getViewId();
                    if (viewId != null) {
                        logical_time = Math.max(logical_time, viewId.getId());
                    }
                    sub_mbrships.add(new ArrayList<Address>(tmp_view.getMembers()));
                }
                if ((digest = mergeData.getDigest()) == null) continue;
                for (Digest.Entry entry : digest) {
                    digest_membership.add(entry.getMember());
                }
            }
            if (!digest_membership.isEmpty()) {
                for (Collection collection : sub_mbrships) {
                    collection.retainAll(digest_membership);
                }
            }
            List<Address> merged_mbrs = Merger.this.gms.computeNewMembership(sub_mbrships);
            HashSet hashSet = new HashSet();
            for (Collection collection : sub_mbrships) {
                hashSet.addAll(collection);
            }
            merged_mbrs.retainAll(hashSet);
            Address address = new_coord = merged_mbrs.isEmpty() ? null : merged_mbrs.get(0);
            if (new_coord == null) {
                return null;
            }
            Iterator<View> iterator = subviews.iterator();
            while (iterator.hasNext()) {
                Address creator = iterator.next().getCreator();
                if (creator == null || merged_mbrs.contains(creator)) continue;
                iterator.remove();
            }
            MergeView mergeView = new MergeView(new_coord, logical_time + 1L, merged_mbrs, subviews);
            MutableDigest new_digest = this.consolidateDigests(mergeView, merge_rsps);
            if (new_digest == null || !new_digest.allSet()) {
                return null;
            }
            Merger.this.log.trace("%s: consolidated view=%s\nconsolidated digest=%s", ((Merger)Merger.this).gms.local_addr, mergeView, new_digest);
            return new MergeData(((Merger)Merger.this).gms.local_addr, mergeView, new_digest);
        }

        protected MutableDigest consolidateDigests(View new_view, List<MergeData> merge_rsps) {
            MutableDigest retval = new MutableDigest(new_view.getMembersRaw());
            for (MergeData data : merge_rsps) {
                Digest tmp_digest = data.getDigest();
                if (tmp_digest == null) continue;
                retval.merge(tmp_digest);
            }
            return retval;
        }
    }
}

