/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import javax.xml.stream.XMLStreamException;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser80;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.Attribute;
import org.infinispan.persistence.jdbc.configuration.Element;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.ManagedConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.SimpleConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfigurationBuilder;

@Namespaces(value={@Namespace(uri="urn:infinispan:config:store:jdbc:8.0", root="string-keyed-jdbc-store"), @Namespace(root="string-keyed-jdbc-store"), @Namespace(uri="urn:infinispan:config:store:jdbc:8.0", root="binary-keyed-jdbc-store"), @Namespace(root="binary-keyed-jdbc-store"), @Namespace(uri="urn:infinispan:config:store:jdbc:8.0", root="mixed-keyed-jdbc-store"), @Namespace(root="mixed-keyed-jdbc-store")})
public class JdbcStoreConfigurationParser80
implements ConfigurationParser {
    @Override
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case STRING_KEYED_JDBC_STORE: {
                this.parseStringKeyedJdbcStore(reader, builder.persistence());
                break;
            }
            case BINARY_KEYED_JDBC_STORE: {
                this.parseBinaryKeyedJdbcStore(reader, builder.persistence());
                break;
            }
            case MIXED_KEYED_JDBC_STORE: {
                this.parseMixedKeyedJdbcStore(reader, builder.persistence());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    private void parseStringKeyedJdbcStore(XMLExtendedStreamReader reader, PersistenceConfigurationBuilder persistenceBuilder) throws XMLStreamException {
        JdbcStringBasedStoreConfigurationBuilder builder = new JdbcStringBasedStoreConfigurationBuilder(persistenceBuilder);
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEY_TO_STRING_MAPPER: {
                    builder.key2StringMapper(value);
                    continue block7;
                }
                case DIALECT: {
                    builder.dialect(DatabaseType.valueOf(value));
                    continue block7;
                }
                default: {
                    Parser80.parseStoreAttribute(reader, i, builder);
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STRING_KEYED_TABLE: {
                    this.parseTable(reader, builder.table());
                    continue block8;
                }
            }
            this.parseCommonJdbcStoreElements(reader, element, builder);
        }
        persistenceBuilder.addStore(builder);
    }

    private void parseBinaryKeyedJdbcStore(XMLExtendedStreamReader reader, PersistenceConfigurationBuilder persistenceBuilder) throws XMLStreamException {
        JdbcBinaryStoreConfigurationBuilder builder = new JdbcBinaryStoreConfigurationBuilder(persistenceBuilder);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DIALECT: {
                    builder.dialect(DatabaseType.valueOf(value));
                    continue block6;
                }
                default: {
                    Parser80.parseStoreAttribute(reader, i, builder);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BINARY_KEYED_TABLE: {
                    this.parseTable(reader, builder.table());
                    continue block7;
                }
            }
            this.parseCommonJdbcStoreElements(reader, element, builder);
        }
        persistenceBuilder.addStore(builder);
    }

    private void parseCommonJdbcStoreElements(XMLExtendedStreamReader reader, Element element, AbstractJdbcStoreConfigurationBuilder<?, ?> builder) throws XMLStreamException {
        switch (element) {
            case CONNECTION_POOL: {
                this.parseConnectionPoolAttributes(reader, builder.connectionPool());
                break;
            }
            case DATA_SOURCE: {
                this.parseDataSourceAttributes(reader, builder.dataSource());
                break;
            }
            case SIMPLE_CONNECTION: {
                this.parseSimpleConnectionAttributes(reader, builder.simpleConnection());
                break;
            }
            default: {
                Parser80.parseStoreElement(reader, builder);
            }
        }
    }

    private void parseDataSourceAttributes(XMLExtendedStreamReader reader, ManagedConnectionFactoryConfigurationBuilder<?> builder) throws XMLStreamException {
        String jndiUrl = ParseUtils.requireSingleAttribute(reader, Attribute.JNDI_URL.getLocalName());
        builder.jndiUrl(jndiUrl);
        ParseUtils.requireNoContent(reader);
    }

    private void parseConnectionPoolAttributes(XMLExtendedStreamReader reader, PooledConnectionFactoryConfigurationBuilder<?> builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CONNECTION_URL: {
                    builder.connectionUrl(value);
                    continue block6;
                }
                case DRIVER_CLASS: {
                    builder.driverClass(value);
                    continue block6;
                }
                case PASSWORD: {
                    builder.password(value);
                    continue block6;
                }
                case USERNAME: {
                    builder.username(value);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseSimpleConnectionAttributes(XMLExtendedStreamReader reader, SimpleConnectionFactoryConfigurationBuilder<?> builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CONNECTION_URL: {
                    builder.connectionUrl(value);
                    continue block6;
                }
                case DRIVER_CLASS: {
                    builder.driverClass(value);
                    continue block6;
                }
                case PASSWORD: {
                    builder.password(value);
                    continue block6;
                }
                case USERNAME: {
                    builder.username(value);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseMixedKeyedJdbcStore(XMLExtendedStreamReader reader, PersistenceConfigurationBuilder persistenceBuilder) throws XMLStreamException {
        JdbcMixedStoreConfigurationBuilder builder = new JdbcMixedStoreConfigurationBuilder(persistenceBuilder);
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEY_TO_STRING_MAPPER: {
                    builder.key2StringMapper(value);
                    continue block8;
                }
                case DIALECT: {
                    builder.dialect(DatabaseType.valueOf(value));
                    continue block8;
                }
                default: {
                    Parser80.parseStoreAttribute(reader, i, builder);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STRING_KEYED_TABLE: {
                    this.parseTable(reader, builder.stringTable());
                    continue block9;
                }
                case BINARY_KEYED_TABLE: {
                    this.parseTable(reader, builder.binaryTable());
                    continue block9;
                }
            }
            this.parseCommonJdbcStoreElements(reader, element, builder);
        }
        persistenceBuilder.addStore(builder);
    }

    private void parseTable(XMLExtendedStreamReader reader, TableManipulationConfigurationBuilder<?, ?> builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case BATCH_SIZE: {
                    builder.batchSize(Integer.parseInt(value));
                    continue block7;
                }
                case CREATE_ON_START: {
                    builder.createOnStart(Boolean.parseBoolean(value));
                    continue block7;
                }
                case DROP_ON_EXIT: {
                    builder.dropOnExit(Boolean.parseBoolean(value));
                    continue block7;
                }
                case FETCH_SIZE: {
                    builder.fetchSize(Integer.parseInt(value));
                    continue block7;
                }
                case PREFIX: {
                    builder.tableNamePrefix(value);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        this.parseTableElements(reader, builder);
    }

    private void parseTableElements(XMLExtendedStreamReader reader, TableManipulationConfigurationBuilder<?, ?> builder) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ID_COLUMN: {
                    Column column = this.parseTableElementAttributes(reader);
                    builder.idColumnName(column.name);
                    builder.idColumnType(column.type);
                    continue block5;
                }
                case DATA_COLUMN: {
                    Column column = this.parseTableElementAttributes(reader);
                    builder.dataColumnName(column.name);
                    builder.dataColumnType(column.type);
                    continue block5;
                }
                case TIMESTAMP_COLUMN: {
                    Column column = this.parseTableElementAttributes(reader);
                    builder.timestampColumnName(column.name);
                    builder.timestampColumnType(column.type);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private Column parseTableElementAttributes(XMLExtendedStreamReader reader) throws XMLStreamException {
        Column column = new Column();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    column.name = value;
                    continue block4;
                }
                case TYPE: {
                    column.type = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
        return column;
    }

    @Override
    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    class Column {
        String name;
        String type;

        Column() {
        }
    }
}

