/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.eviction.EvictionType;

public class EvictionConfiguration {
    public static final AttributeDefinition<Long> SIZE = AttributeDefinition.builder("size", -1L).build();
    public static final AttributeDefinition<EvictionType> TYPE = AttributeDefinition.builder("type", EvictionType.COUNT).build();
    public static final AttributeDefinition<EvictionStrategy> STRATEGY = AttributeDefinition.builder("strategy", EvictionStrategy.NONE).immutable().build();
    public static final AttributeDefinition<EvictionThreadPolicy> THREAD_POLICY = AttributeDefinition.builder("threadPolicy", EvictionThreadPolicy.DEFAULT).immutable().build();
    private final Attribute<Long> size;
    private final Attribute<EvictionType> type;
    private final Attribute<EvictionStrategy> strategy;
    private final Attribute<EvictionThreadPolicy> threadPolicy;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(EvictionConfiguration.class, SIZE, TYPE, STRATEGY, THREAD_POLICY);
    }

    EvictionConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.size = attributes.attribute(SIZE);
        this.type = attributes.attribute(TYPE);
        this.strategy = attributes.attribute(STRATEGY);
        this.threadPolicy = attributes.attribute(THREAD_POLICY);
    }

    public EvictionStrategy strategy() {
        return this.strategy.get();
    }

    public EvictionThreadPolicy threadPolicy() {
        return this.threadPolicy.get();
    }

    public long maxEntries() {
        if (this.type.get() != EvictionType.COUNT) {
            throw new IllegalStateException();
        }
        return this.size();
    }

    public long size() {
        return this.size.get();
    }

    public EvictionType type() {
        return this.type.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "EvictionConfiguration [attributes=" + this.attributes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EvictionConfiguration other = (EvictionConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }
}

