/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.remoting.inboundhandler.BasePerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NonTotalOrderPerCacheInboundInvocationHandler
extends BasePerCacheInboundInvocationHandler {
    private static final Log log = LogFactory.getLog(NonTotalOrderPerCacheInboundInvocationHandler.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
        if (order == DeliverOrder.TOTAL) {
            this.unexpectedDeliverMode(command, order);
        }
        try {
            BlockingRunnable runnable;
            boolean onExecutorService = !order.preserveOrder() && command.canBlock();
            switch (command.getCommandId()) {
                case 1: {
                    runnable = this.createDefaultRunnable(command, reply, NonTotalOrderPerCacheInboundInvocationHandler.extractCommandTopologyId((SingleRpcCommand)command), true, onExecutorService);
                    break;
                }
                case 2: {
                    runnable = this.createDefaultRunnable(command, reply, NonTotalOrderPerCacheInboundInvocationHandler.extractCommandTopologyId((MultipleRpcCommand)command), true, onExecutorService);
                    break;
                }
                case 15: {
                    runnable = this.createDefaultRunnable(command, reply, NonTotalOrderPerCacheInboundInvocationHandler.extractCommandTopologyId((StateRequestCommand)command), false, onExecutorService);
                    break;
                }
                default: {
                    int commandTopologyId = NO_TOPOLOGY_COMMAND;
                    if (command instanceof TopologyAffectedCommand) {
                        commandTopologyId = NonTotalOrderPerCacheInboundInvocationHandler.extractCommandTopologyId((TopologyAffectedCommand)((Object)command));
                    }
                    runnable = this.createDefaultRunnable(command, reply, commandTopologyId, true, onExecutorService);
                }
            }
            this.handleRunnable(runnable, onExecutorService);
        }
        catch (Throwable throwable) {
            reply.reply(this.exceptionHandlingCommand(command, throwable));
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected boolean isTraceEnabled() {
        return trace;
    }
}

