/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;

public class TakeOfflineConfiguration {
    public static final AttributeDefinition<Integer> AFTER_FAILURES = AttributeDefinition.builder("afterFailures", 0).immutable().build();
    public static final AttributeDefinition<Long> MIN_TIME_TO_WAIT = AttributeDefinition.builder("minTimeToWait", 0L).immutable().build();
    private final Attribute<Integer> afterFailures;
    private final Attribute<Long> minTimeToWait;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(TakeOfflineConfiguration.class, AFTER_FAILURES, MIN_TIME_TO_WAIT);
    }

    public TakeOfflineConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.afterFailures = attributes.attribute(AFTER_FAILURES);
        this.minTimeToWait = attributes.attribute(MIN_TIME_TO_WAIT);
    }

    public int afterFailures() {
        return this.afterFailures.get();
    }

    public long minTimeToWait() {
        return this.minTimeToWait.get();
    }

    public boolean enabled() {
        return this.afterFailures() > 0 || this.minTimeToWait() > 0L;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TakeOfflineConfiguration other = (TakeOfflineConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public String toString() {
        return "TakeOfflineConfiguration [attributes=" + this.attributes + "]";
    }
}

