/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.util.concurrent.jdk8backported.EquivalentConcurrentHashMapV8;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsTopologyAwareAddress;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.UUID;

public class JGroupsAddressCache {
    private static final EquivalentConcurrentHashMapV8<org.jgroups.Address, JGroupsAddress> addressCache = new EquivalentConcurrentHashMapV8(AnyEquivalence.getInstance(), AnyEquivalence.getInstance());

    static Address fromJGroupsAddress(Object address) {
        org.jgroups.Address addr1 = (org.jgroups.Address)address;
        return addressCache.computeIfAbsent(addr1, uuid -> {
            if (addr1 instanceof ExtendedUUID) {
                return new JGroupsTopologyAwareAddress((ExtendedUUID)addr1);
            }
            return new JGroupsAddress(addr1);
        });
    }

    static void pruneAddressCache() {
        addressCache.forEachKey(Integer.MAX_VALUE, address -> {
            if (UUID.get(address) == null) {
                addressCache.remove(address);
            }
        });
    }
}

