/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;

public class LocalValueCacheStream<K, V>
extends AbstractLocalCacheStream<V, K, V> {
    private final Cache<K, V> cache;

    public LocalValueCacheStream(Cache<K, V> cache, boolean parallel, ConsistentHash hash, Supplier<Stream<CacheEntry<K, V>>> supplier, ComponentRegistry registry) {
        super(parallel, hash, supplier, registry);
        this.cache = cache;
    }

    @Override
    protected Stream<V> getStream() {
        Stream<CacheEntry> stream;
        if (this.keysToFilter != null) {
            AdvancedCache advancedCache = this.cache.getAdvancedCache();
            this.log.tracef("Applying key filtering %s", (Object)this.keysToFilter);
            stream = this.keysToFilter.stream().map((? super T k) -> advancedCache.getCacheEntry(k)).filter((? super T e) -> e != null);
        } else {
            stream = (Stream<CacheEntry>)this.supplier.get();
        }
        if (this.segmentsToFilter != null && this.hash != null) {
            this.log.tracef("Applying segment filter %s", (Object)this.segmentsToFilter);
            stream = stream.filter((? super T k) -> this.segmentsToFilter.contains(this.hash.getSegment(k.getKey())));
        }
        return stream.map((? super T e) -> e.getValue());
    }
}

