/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.commands.read.AbstractCloseableIteratorCollection;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorMapper;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.stream.StreamMarshalling;
import org.infinispan.stream.impl.local.LocalEntryCacheStream;

public class ValueCacheCollection<K, V>
extends AbstractCloseableIteratorCollection<V, K, V>
implements CacheCollection<V> {
    private final CacheSet<CacheEntry<K, V>> cacheSet;

    public ValueCacheCollection(Cache<K, V> cache, CacheSet<CacheEntry<K, V>> cacheSet) {
        super(cache);
        this.cacheSet = cacheSet;
    }

    @Override
    public CloseableIterator<V> iterator() {
        return new CloseableIteratorMapper<CacheEntry, Object>((CloseableIterator<CacheEntry>)this.cacheSet.iterator(), CacheEntry::getValue);
    }

    @Override
    public CloseableSpliterator<V> spliterator() {
        return Closeables.spliterator(this.iterator(), this.cache.getAdvancedCache().getDataContainer().size(), 4352);
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        try (Iterator it = this.iterator();){
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c.size() > 0) {
            HashSet set = new HashSet(c);
            try (Iterator it = this.iterator();){
                while (!set.isEmpty() && it.hasNext()) {
                    set.remove(it.next());
                }
            }
            return set.isEmpty();
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        try (Iterator it = this.iterator();){
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                it.remove();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public CacheStream<V> stream() {
        Stream stream = this.cacheSet.stream();
        if (stream instanceof LocalEntryCacheStream) {
            return ((LocalEntryCacheStream)stream).toLocalValueCacheStream();
        }
        return (CacheStream)stream.map(StreamMarshalling.entryToValueFunction());
    }

    @Override
    public CacheStream<V> parallelStream() {
        Stream stream = this.cacheSet.parallelStream();
        if (stream instanceof LocalEntryCacheStream) {
            return ((LocalEntryCacheStream)stream).toLocalValueCacheStream();
        }
        return (CacheStream)this.cacheSet.parallelStream().map(StreamMarshalling.entryToValueFunction());
    }
}

