/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi;

import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessProducer;
import org.infinispan.cdi.InfinispanExtensionEmbedded;
import org.infinispan.cdi.InfinispanExtensionRemote;
import org.infinispan.cdi.util.defaultbean.DefaultBeanHolder;
import org.infinispan.cdi.util.defaultbean.Installed;
import org.infinispan.cdi.util.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public class InfinispanExtension
implements Extension {
    private static final Log log = LogFactory.getLog(InfinispanExtension.class, Log.class);
    private final InfinispanExtensionEmbedded embeddedExtension;
    private final InfinispanExtensionRemote remoteExtension;

    public InfinispanExtension() {
        InfinispanExtensionRemote r;
        InfinispanExtensionEmbedded e;
        try {
            e = new InfinispanExtensionEmbedded();
            log.debug("Enabling support for embedded CDI");
        }
        catch (Throwable t) {
            e = null;
            log.debug("Disabling support for embedded CDI");
        }
        this.embeddedExtension = e;
        try {
            r = new InfinispanExtensionRemote();
            log.debug("Enabling support for remote CDI");
        }
        catch (Throwable t) {
            r = null;
            log.debug("Disabling support for remote CDI");
        }
        this.remoteExtension = r;
    }

    void processProducers(@Observes ProcessProducer<?, ?> event, BeanManager beanManager) {
        if (this.remoteExtension != null) {
            this.remoteExtension.processProducers(event);
        }
        if (this.embeddedExtension != null) {
            this.embeddedExtension.processProducers(event, beanManager);
        }
    }

    <T> void processInjectionPoints(@Observes ProcessInjectionTarget<T> event, BeanManager beanManager) {
        if (this.remoteExtension != null) {
            this.remoteExtension.saveRemoteInjectionPoints(event, beanManager);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        if (this.remoteExtension != null) {
            this.remoteExtension.registerCacheBeans(event, beanManager);
        }
        if (this.embeddedExtension != null) {
            this.embeddedExtension.registerCacheBeans(event, beanManager);
            this.embeddedExtension.registerInputCacheCustomBean(event, beanManager);
        }
    }

    public void observeDefaultBean(@Observes @Installed DefaultBeanHolder bean) {
        if (this.embeddedExtension != null) {
            this.embeddedExtension.observeDefaultEmbeddedCacheManagerInstalled(bean);
        }
    }

    public void processBean(@Observes ProcessBean<?> processBean) {
        if (this.embeddedExtension != null) {
            this.embeddedExtension.observeEmbeddedCacheManagerBean(processBean);
        }
    }

    public InfinispanExtensionEmbedded getEmbeddedExtension() {
        return this.embeddedExtension;
    }

    public InfinispanExtensionRemote getRemoteExtension() {
        return this.remoteExtension;
    }
}

