/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Map;
import org.infinispan.commands.CancelCommand;
import org.infinispan.commands.CreateCacheCommand;
import org.infinispan.commands.RemoveCacheCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commands.read.DistributedExecuteCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.MapCombineCommand;
import org.infinispan.commands.read.ReduceCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.ClusteredGetAllCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderCommitCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderNonVersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderRollbackCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderVersionedCommitCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderVersionedPrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.iteration.impl.EntryRequestCommand;
import org.infinispan.iteration.impl.EntryResponseCommand;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.statetransfer.StateResponseCommand;
import org.infinispan.stream.impl.StreamRequestCommand;
import org.infinispan.stream.impl.StreamResponseCommand;
import org.infinispan.stream.impl.StreamSegmentResponseCommand;
import org.infinispan.topology.CacheTopologyControlCommand;
import org.infinispan.xsite.SingleXSiteRpcCommand;
import org.infinispan.xsite.XSiteAdminCommand;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;
import org.infinispan.xsite.statetransfer.XSiteStateTransferControlCommand;

@Scope(value=Scopes.GLOBAL)
public class RemoteCommandsFactory {
    EmbeddedCacheManager cacheManager;
    GlobalComponentRegistry registry;
    Map<Byte, ModuleCommandFactory> commandFactories;

    @Inject
    public void inject(EmbeddedCacheManager cacheManager, GlobalComponentRegistry registry, @ComponentName(value="org.infinispan.modules.command.factories") Map<Byte, ModuleCommandFactory> commandFactories) {
        this.cacheManager = cacheManager;
        this.registry = registry;
        this.commandFactories = commandFactories;
    }

    public ReplicableCommand fromStream(byte id, Object[] parameters, byte type) {
        ReplicableCommand command;
        block24: {
            block23: {
                if (type != 0) break block23;
                switch (id) {
                    case 8: {
                        command = new PutKeyValueCommand();
                        break block24;
                    }
                    case 9: {
                        command = new PutMapCommand();
                        break block24;
                    }
                    case 10: {
                        command = new RemoveCommand();
                        break block24;
                    }
                    case 11: {
                        command = new ReplaceCommand();
                        break block24;
                    }
                    case 4: {
                        command = new GetKeyValueCommand();
                        break block24;
                    }
                    case 5: {
                        command = new ClearCommand();
                        break block24;
                    }
                    case 6: {
                        command = new InvalidateCommand();
                        break block24;
                    }
                    case 7: {
                        command = new InvalidateL1Command();
                        break block24;
                    }
                    case 25: {
                        command = new ApplyDeltaCommand();
                        break block24;
                    }
                    case 17: {
                        command = new CacheTopologyControlCommand();
                        break block24;
                    }
                    case 43: {
                        command = new GetKeysInGroupCommand();
                        break block24;
                    }
                    case 45: {
                        command = new GetCacheEntryCommand();
                        break block24;
                    }
                    case 50: {
                        command = new ReadWriteKeyCommand();
                        break block24;
                    }
                    case 51: {
                        command = new ReadWriteKeyValueCommand();
                        break block24;
                    }
                    case 52: {
                        command = new ReadWriteManyCommand();
                        break block24;
                    }
                    case 53: {
                        command = new ReadWriteManyEntriesCommand();
                        break block24;
                    }
                    case 54: {
                        command = new WriteOnlyKeyCommand();
                        break block24;
                    }
                    case 55: {
                        command = new WriteOnlyKeyValueCommand();
                        break block24;
                    }
                    case 56: {
                        command = new WriteOnlyManyCommand();
                        break block24;
                    }
                    case 57: {
                        command = new WriteOnlyManyEntriesCommand();
                        break block24;
                    }
                    default: {
                        throw new CacheException("Unknown command id " + id + "!");
                    }
                }
            }
            ModuleCommandFactory mcf = this.commandFactories.get(id);
            if (mcf != null) {
                return mcf.fromStream(id, parameters);
            }
            throw new CacheException("Unknown command id " + id + "!");
        }
        command.setParameters(id, parameters);
        return command;
    }

    public CacheRpcCommand fromStream(byte id, Object[] parameters, byte type, String cacheName) {
        CacheRpcCommand command;
        if (type == 0) {
            switch (id) {
                case 3: {
                    command = new LockControlCommand(cacheName);
                    break;
                }
                case 12: {
                    command = new PrepareCommand(cacheName);
                    break;
                }
                case 26: {
                    command = new VersionedPrepareCommand(cacheName);
                    break;
                }
                case 38: {
                    command = new TotalOrderNonVersionedPrepareCommand(cacheName);
                    break;
                }
                case 39: {
                    command = new TotalOrderVersionedPrepareCommand(cacheName);
                    break;
                }
                case 14: {
                    command = new CommitCommand(cacheName);
                    break;
                }
                case 27: {
                    command = new VersionedCommitCommand(cacheName);
                    break;
                }
                case 35: {
                    command = new TotalOrderCommitCommand(cacheName);
                    break;
                }
                case 36: {
                    command = new TotalOrderVersionedCommitCommand(cacheName);
                    break;
                }
                case 13: {
                    command = new RollbackCommand(cacheName);
                    break;
                }
                case 37: {
                    command = new TotalOrderRollbackCommand(cacheName);
                    break;
                }
                case 2: {
                    command = new MultipleRpcCommand(cacheName);
                    break;
                }
                case 1: {
                    command = new SingleRpcCommand(cacheName);
                    break;
                }
                case 16: {
                    command = new ClusteredGetCommand(cacheName);
                    break;
                }
                case 15: {
                    command = new StateRequestCommand(cacheName);
                    break;
                }
                case 20: {
                    command = new StateResponseCommand(cacheName);
                    break;
                }
                case 18: {
                    ComponentRegistry namedCacheRegistry = this.registry.getNamedComponentRegistry(cacheName);
                    command = new RemoveCacheCommand(cacheName, this.cacheManager, this.registry, namedCacheRegistry.getComponent(PersistenceManager.class), namedCacheRegistry.getComponent(CacheJmxRegistration.class));
                    break;
                }
                case 22: {
                    command = new TxCompletionNotificationCommand(cacheName);
                    break;
                }
                case 21: {
                    command = new GetInDoubtTransactionsCommand(cacheName);
                    break;
                }
                case 30: {
                    command = new MapCombineCommand(cacheName);
                    break;
                }
                case 31: {
                    command = new ReduceCommand(cacheName);
                    break;
                }
                case 19: {
                    command = new DistributedExecuteCommand(cacheName);
                    break;
                }
                case 23: {
                    command = new GetInDoubtTxInfoCommand(cacheName);
                    break;
                }
                case 24: {
                    command = new CompleteTransactionCommand(cacheName);
                    break;
                }
                case 29: {
                    command = new CreateCacheCommand(cacheName);
                    break;
                }
                case 32: {
                    command = new XSiteAdminCommand(cacheName);
                    break;
                }
                case 34: {
                    command = new CancelCommand(cacheName);
                    break;
                }
                case 28: {
                    command = new XSiteStateTransferControlCommand(cacheName);
                    break;
                }
                case 33: {
                    command = new XSiteStatePushCommand(cacheName);
                    break;
                }
                case 40: {
                    command = new SingleXSiteRpcCommand(cacheName);
                    break;
                }
                case 41: {
                    command = new EntryRequestCommand(cacheName);
                    break;
                }
                case 42: {
                    command = new EntryResponseCommand(cacheName);
                    break;
                }
                case 46: {
                    command = new ClusteredGetAllCommand(cacheName);
                    break;
                }
                case 47: {
                    command = new StreamRequestCommand(cacheName);
                    break;
                }
                case 49: {
                    command = new StreamSegmentResponseCommand(cacheName);
                    break;
                }
                case 48: {
                    command = new StreamResponseCommand(cacheName);
                    break;
                }
                default: {
                    throw new CacheException("Unknown command id " + id + "!");
                }
            }
        } else {
            ModuleCommandFactory mcf = this.commandFactories.get(id);
            if (mcf != null) {
                return mcf.fromStream(id, parameters, cacheName);
            }
            throw new CacheException("Unknown command id " + id + "!");
        }
        command.setParameters(id, parameters);
        return command;
    }
}

