/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.api.functional;

import java.util.NoSuchElementException;
import java.util.Optional;
import org.infinispan.commons.api.functional.EntryVersion;

public interface MetaParam<T> {

    public static abstract class LongMetadata<T>
    implements MetaParam<T> {
        protected final long value;

        public LongMetadata(long value) {
            this.value = value;
        }

        public Long get() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LongMetadata longMeta = (LongMetadata)o;
            return this.value == longMeta.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }

    public static final class EntryVersionParam<V>
    implements Writable<EntryVersionParam<V>> {
        private final EntryVersion<V> entryVersion;

        public static <T> T getType() {
            return (T)EntryVersionParam.class;
        }

        public EntryVersionParam(EntryVersion<V> entryVersion) {
            this.entryVersion = entryVersion;
        }

        public EntryVersion<V> get() {
            return this.entryVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntryVersionParam that = (EntryVersionParam)o;
            return this.entryVersion.equals(that.entryVersion);
        }

        public int hashCode() {
            return this.entryVersion.hashCode();
        }

        public String toString() {
            return "MetaParam=" + this.entryVersion;
        }
    }

    public static final class LastUsed
    extends LongMetadata {
        public LastUsed(long lastUsed) {
            super(lastUsed);
        }

        public String toString() {
            return "LastUsed=" + this.value;
        }
    }

    public static final class MaxIdle
    extends LongMetadata<MaxIdle>
    implements Writable<MaxIdle> {
        private static final MaxIdle DEFAULT = new MaxIdle(-1L);

        public MaxIdle(long maxIdle) {
            super(maxIdle);
        }

        public String toString() {
            return "MaxIdle=" + this.value;
        }

        public static MaxIdle defaultValue() {
            return DEFAULT;
        }
    }

    public static final class Created
    extends LongMetadata {
        public Created(long created) {
            super(created);
        }

        public String toString() {
            return "Created=" + this.value;
        }
    }

    public static final class Lifespan
    extends LongMetadata<Lifespan>
    implements Writable<Lifespan> {
        private static final Lifespan DEFAULT = new Lifespan(-1L);

        public Lifespan(long lifespan) {
            super(lifespan);
        }

        public String toString() {
            return "Lifespan=" + this.value;
        }

        public static Lifespan defaultValue() {
            return DEFAULT;
        }
    }

    public static interface Writable<T>
    extends MetaParam<T> {
    }

    public static interface Lookup {
        public <T> T getMetaParam(Class<T> var1) throws NoSuchElementException;

        public <T> Optional<T> findMetaParam(Class<T> var1);
    }
}

