/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;

public final class Iterators {
    public static <T> CloseableIterator<T> of(Stream<T> stream) {
        return new StreamCloseableIterator(stream);
    }

    public static <T> CloseableSpliterator<T> spliterator(Stream<T> stream) {
        return new StreamCloseableSpliterator(stream);
    }

    public static <T> CloseableIterator<T> eager(Stream<T> stream) {
        List list = stream.collect(Collectors.toList());
        return new StreamCloseableIterator(list.stream());
    }

    private Iterators() {
    }

    private static final class StreamCloseableSpliterator<T>
    implements CloseableSpliterator<T> {
        private final Spliterator<T> it;

        private StreamCloseableSpliterator(Stream<T> stream) {
            this.it = stream.spliterator();
        }

        @Override
        public void close() {
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            return false;
        }

        @Override
        public Spliterator<T> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        @Override
        public int characteristics() {
            return 0;
        }
    }

    private static final class StreamCloseableIterator<T>
    implements CloseableIterator<T> {
        volatile boolean isClosed = false;
        final Iterator<T> it;

        private StreamCloseableIterator(Stream<T> stream) {
            this.it = stream.iterator();
        }

        @Override
        public boolean hasNext() {
            return !this.isClosed && this.it.hasNext();
        }

        @Override
        public T next() {
            if (this.isClosed) {
                throw new NoSuchElementException("Iterator closed");
            }
            return this.it.next();
        }

        @Override
        public void close() {
            this.isClosed = true;
        }
    }
}

