/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.infinispan.atomic.DeltaCompositeKey;
import org.infinispan.atomic.impl.AtomicHashMap;
import org.infinispan.atomic.impl.AtomicHashMapDelta;
import org.infinispan.atomic.impl.ClearOperation;
import org.infinispan.atomic.impl.PutOperation;
import org.infinispan.atomic.impl.RemoveOperation;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.RemoteCommandsFactory;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.hash.MurmurHash2;
import org.infinispan.commons.hash.MurmurHash2Compat;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.ImmutableListCopy;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.ReadCommittedEntry;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataImmortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataImmortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataMortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataMortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataTransientCacheEntry;
import org.infinispan.container.entries.metadata.MetadataTransientCacheValue;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheValue;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.context.Flag;
import org.infinispan.distexec.mapreduce.MapReduceManagerImpl;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.distribution.ch.impl.DefaultConsistentHashFactory;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHash;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHashFactory;
import org.infinispan.distribution.ch.impl.SyncConsistentHashFactory;
import org.infinispan.distribution.ch.impl.TopologyAwareConsistentHashFactory;
import org.infinispan.distribution.ch.impl.TopologyAwareSyncConsistentHashFactory;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.filter.AcceptAllKeyValueFilter;
import org.infinispan.filter.CacheFilters;
import org.infinispan.filter.CollectionKeyFilter;
import org.infinispan.filter.CompositeKeyFilter;
import org.infinispan.filter.CompositeKeyValueFilter;
import org.infinispan.filter.KeyFilterAsKeyValueFilter;
import org.infinispan.filter.KeyValueFilterAsKeyFilter;
import org.infinispan.filter.NullValueConverter;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.MetaParams;
import org.infinispan.functional.impl.MetaParamsInternalMetadata;
import org.infinispan.marshall.core.MarshalledEntryImpl;
import org.infinispan.marshall.core.MarshalledValue;
import org.infinispan.marshall.exts.ArrayExternalizers;
import org.infinispan.marshall.exts.CacheRpcCommandExternalizer;
import org.infinispan.marshall.exts.EnumSetExternalizer;
import org.infinispan.marshall.exts.ListExternalizer;
import org.infinispan.marshall.exts.MapExternalizer;
import org.infinispan.marshall.exts.MetaParamExternalizers;
import org.infinispan.marshall.exts.OptionalExternalizer;
import org.infinispan.marshall.exts.ReplicableCommandExternalizer;
import org.infinispan.marshall.exts.SetExternalizer;
import org.infinispan.marshall.exts.SingletonListExternalizer;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.notifications.cachelistener.cluster.ClusterEvent;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventCallable;
import org.infinispan.notifications.cachelistener.cluster.ClusterListenerRemoveCallable;
import org.infinispan.notifications.cachelistener.cluster.ClusterListenerReplicateCallable;
import org.infinispan.notifications.cachelistener.cluster.MultiClusterEventCallable;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterAsConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterAsKeyValueFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterAsKeyValueFilterConverter;
import org.infinispan.notifications.cachelistener.filter.ConverterAsCacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.KeyFilterAsCacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.KeyValueFilterAsCacheEventFilter;
import org.infinispan.registry.ScopedKey;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsuccessfulResponse;
import org.infinispan.remoting.responses.UnsureResponse;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsTopologyAwareAddress;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.statetransfer.TransactionInfo;
import org.infinispan.stream.StreamMarshalling;
import org.infinispan.stream.impl.intops.IntermediateOperationExternalizer;
import org.infinispan.stream.impl.termop.TerminalOperationExternalizer;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.ManagerStatusResponse;
import org.infinispan.transaction.xa.DldGlobalTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.InDoubtTxInfoImpl;
import org.infinispan.transaction.xa.recovery.RecoveryAwareDldGlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareGlobalTransaction;
import org.infinispan.transaction.xa.recovery.SerializableXid;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;

@Scope(value=Scopes.GLOBAL)
public class ExternalizerTable
implements ObjectTable {
    private static final Log log = LogFactory.getLog(ExternalizerTable.class);
    private final Map<Class<?>, ExternalizerAdapter> writers = new WeakHashMap();
    private final Map<Integer, ExternalizerAdapter> readers = new HashMap<Integer, ExternalizerAdapter>();
    private volatile boolean started;
    private RemoteCommandsFactory cmdFactory;
    private GlobalComponentRegistry gcr;
    private StreamingMarshaller globalMarshaller;

    @Inject
    public void inject(RemoteCommandsFactory cmdFactory, GlobalComponentRegistry gcr, @ComponentName(value="org.infinispan.marshaller.global") StreamingMarshaller globalMarshaller) {
        this.cmdFactory = cmdFactory;
        this.gcr = gcr;
        this.globalMarshaller = globalMarshaller;
    }

    @Start(priority=7)
    public void start() {
        this.loadInternalMarshallables();
        this.loadForeignMarshallables(this.gcr.getGlobalConfiguration());
        this.started = true;
        if (log.isTraceEnabled()) {
            log.tracef("Constant object table was started and contains these externalizer readers: %s", (Object)this.readers);
            log.tracef("The externalizer writers collection contains: %s", (Object)this.writers);
        }
    }

    @Stop(priority=13)
    public void stop() {
        this.started = false;
        this.writers.clear();
        this.readers.clear();
        log.trace("Externalizer reader and writer maps have been cleared and constant object table was stopped");
    }

    @Override
    public ObjectTable.Writer getObjectWriter(Object o) throws IOException {
        Class<?> clazz = o.getClass();
        if (!this.started) {
            throw log.externalizerTableStopped(clazz.getName());
        }
        ObjectTable.Writer writer = this.writers.get(clazz);
        return writer;
    }

    @Override
    public Object readObject(Unmarshaller input) throws IOException, ClassNotFoundException {
        ExternalizerAdapter adapter;
        int readerIndex = input.readUnsignedByte();
        int foreignId = -1;
        if (readerIndex == 255) {
            foreignId = UnsignedNumeric.readUnsignedInt(input);
            readerIndex = this.generateForeignReaderIndex(foreignId);
        }
        if ((adapter = this.readers.get(readerIndex)) == null) {
            if (!this.started) {
                log.tracef("Either the marshaller has stopped or hasn't started. Read externalizers are not properly populated: %s", (Object)this.readers);
                if (Thread.currentThread().isInterrupted()) {
                    throw log.pushReadInterruptionDueToCacheManagerShutdown(readerIndex, new InterruptedException());
                }
                throw log.cannotResolveExternalizerReader(this.gcr.getStatus(), readerIndex);
            }
            if (log.isTraceEnabled()) {
                log.tracef("Unknown type. Input stream has %s to read", input.available());
                log.tracef("Check contents of read externalizers: %s", (Object)this.readers);
            }
            if (foreignId > 0) {
                throw log.missingForeignExternalizer(foreignId);
            }
            throw log.unknownExternalizerReaderIndex(readerIndex);
        }
        return adapter.readObject(input);
    }

    boolean isMarshallableCandidate(Object o) {
        return this.writers.containsKey(o.getClass());
    }

    int getExternalizerId(Object o) {
        return this.writers.get(o.getClass()).getExternalizerId();
    }

    private void loadInternalMarshallables() {
        this.addInternalExternalizer(new ListExternalizer());
        this.addInternalExternalizer(new MapExternalizer());
        this.addInternalExternalizer(new SetExternalizer());
        this.addInternalExternalizer(new EnumSetExternalizer());
        this.addInternalExternalizer(new ArrayExternalizers.ListArray());
        this.addInternalExternalizer(new SingletonListExternalizer());
        this.addInternalExternalizer(new GlobalTransaction.Externalizer());
        this.addInternalExternalizer(new RecoveryAwareGlobalTransaction.Externalizer());
        this.addInternalExternalizer(new DldGlobalTransaction.Externalizer());
        this.addInternalExternalizer(new RecoveryAwareDldGlobalTransaction.Externalizer());
        this.addInternalExternalizer(new JGroupsAddress.Externalizer());
        this.addInternalExternalizer(new ImmutableListCopy.Externalizer());
        this.addInternalExternalizer(new Immutables.ImmutableMapWrapperExternalizer());
        this.addInternalExternalizer(new MarshalledValue.Externalizer(this.globalMarshaller));
        this.addInternalExternalizer(new ByteBufferImpl.Externalizer());
        this.addInternalExternalizer(new SuccessfulResponse.Externalizer());
        this.addInternalExternalizer(new ExceptionResponse.Externalizer());
        this.addInternalExternalizer(new UnsuccessfulResponse.Externalizer());
        this.addInternalExternalizer(new UnsureResponse.Externalizer());
        this.addInternalExternalizer(new CacheNotFoundResponse.Externalizer());
        ReplicableCommandExternalizer cmExt = new ReplicableCommandExternalizer(this.cmdFactory, this.gcr);
        this.addInternalExternalizer(cmExt);
        this.addInternalExternalizer(new CacheRpcCommandExternalizer(this.gcr, cmExt));
        this.addInternalExternalizer(new ImmortalCacheEntry.Externalizer());
        this.addInternalExternalizer(new MortalCacheEntry.Externalizer());
        this.addInternalExternalizer(new TransientCacheEntry.Externalizer());
        this.addInternalExternalizer(new TransientMortalCacheEntry.Externalizer());
        this.addInternalExternalizer(new ImmortalCacheValue.Externalizer());
        this.addInternalExternalizer(new MortalCacheValue.Externalizer());
        this.addInternalExternalizer(new TransientCacheValue.Externalizer());
        this.addInternalExternalizer(new TransientMortalCacheValue.Externalizer());
        this.addInternalExternalizer(new SimpleClusteredVersion.Externalizer());
        this.addInternalExternalizer(new MetadataImmortalCacheEntry.Externalizer());
        this.addInternalExternalizer(new MetadataMortalCacheEntry.Externalizer());
        this.addInternalExternalizer(new MetadataTransientCacheEntry.Externalizer());
        this.addInternalExternalizer(new MetadataTransientMortalCacheEntry.Externalizer());
        this.addInternalExternalizer(new MetadataImmortalCacheValue.Externalizer());
        this.addInternalExternalizer(new MetadataMortalCacheValue.Externalizer());
        this.addInternalExternalizer(new MetadataTransientCacheValue.Externalizer());
        this.addInternalExternalizer(new MetadataTransientMortalCacheValue.Externalizer());
        this.addInternalExternalizer(new DeltaCompositeKey.DeltaCompositeKeyExternalizer());
        this.addInternalExternalizer(new AtomicHashMap.Externalizer());
        this.addInternalExternalizer(new AtomicHashMapDelta.Externalizer());
        this.addInternalExternalizer(new PutOperation.Externalizer());
        this.addInternalExternalizer(new RemoveOperation.Externalizer());
        this.addInternalExternalizer(new ClearOperation.Externalizer());
        this.addInternalExternalizer(new JGroupsTopologyAwareAddress.Externalizer());
        this.addInternalExternalizer(new SerializableXid.XidExternalizer());
        this.addInternalExternalizer(new InDoubtTxInfoImpl.Externalizer());
        this.addInternalExternalizer(new MurmurHash2.Externalizer());
        this.addInternalExternalizer(new MurmurHash2Compat.Externalizer());
        this.addInternalExternalizer(new MurmurHash3.Externalizer());
        this.addInternalExternalizer(new DefaultConsistentHash.Externalizer());
        this.addInternalExternalizer(new ReplicatedConsistentHash.Externalizer());
        this.addInternalExternalizer(new DefaultConsistentHashFactory.Externalizer());
        this.addInternalExternalizer(new ReplicatedConsistentHashFactory.Externalizer());
        this.addInternalExternalizer(new SyncConsistentHashFactory.Externalizer());
        this.addInternalExternalizer(new TopologyAwareConsistentHashFactory.Externalizer());
        this.addInternalExternalizer(new TopologyAwareSyncConsistentHashFactory.Externalizer());
        this.addInternalExternalizer(new CacheTopology.Externalizer());
        this.addInternalExternalizer(new CacheJoinInfo.Externalizer());
        this.addInternalExternalizer(new TransactionInfo.Externalizer());
        this.addInternalExternalizer(new StateChunk.Externalizer());
        this.addInternalExternalizer(new Flag.Externalizer());
        this.addInternalExternalizer(new InfinispanCollections.EmptySet.EmptySetExternalizer());
        this.addInternalExternalizer(new InfinispanCollections.EmptyMap.EmptyMapExternalizer());
        this.addInternalExternalizer(new InfinispanCollections.EmptyList.EmptyListExternalizer());
        this.addInternalExternalizer(new EmbeddedMetadata.Externalizer());
        this.addInternalExternalizer(new NumericVersion.Externalizer());
        this.addInternalExternalizer(new ScopedKey.Externalizer());
        this.addInternalExternalizer(new KeyValuePair.Externalizer());
        this.addInternalExternalizer(new InternalMetadataImpl.Externalizer());
        this.addInternalExternalizer(new MarshalledEntryImpl.Externalizer(this.globalMarshaller));
        this.addInternalExternalizer(new CollectionKeyFilter.Externalizer());
        this.addInternalExternalizer(new KeyFilterAsKeyValueFilter.Externalizer());
        this.addInternalExternalizer(new KeyValueFilterAsKeyFilter.Externalizer());
        this.addInternalExternalizer(new ClusterEvent.Externalizer());
        this.addInternalExternalizer(new ClusterEventCallable.Externalizer());
        this.addInternalExternalizer(new ClusterListenerRemoveCallable.Externalizer());
        this.addInternalExternalizer(new ClusterListenerReplicateCallable.Externalizer());
        this.addInternalExternalizer(new XSiteState.XSiteStateExternalizer());
        this.addInternalExternalizer(new CompositeKeyFilter.Externalizer());
        this.addInternalExternalizer(new CompositeKeyValueFilter.Externalizer());
        this.addInternalExternalizer(new MapReduceManagerImpl.DeltaListExternalizer());
        this.addInternalExternalizer(new MapReduceManagerImpl.DeltaAwareListExternalizer());
        this.addInternalExternalizer(new CacheStatusResponse.Externalizer());
        this.addInternalExternalizer(new CacheEventConverterAsConverter.Externalizer());
        this.addInternalExternalizer(new CacheEventFilterAsKeyValueFilter.Externalizer());
        this.addInternalExternalizer(new CacheEventFilterConverterAsKeyValueFilterConverter.Externalizer());
        this.addInternalExternalizer(new ConverterAsCacheEventConverter.Externalizer());
        this.addInternalExternalizer(new KeyFilterAsCacheEventFilter.Externalizer());
        this.addInternalExternalizer(new KeyValueFilterAsCacheEventFilter.Externalizer());
        this.addInternalExternalizer(new NullValueConverter.Externalizer());
        this.addInternalExternalizer(new AcceptAllKeyValueFilter.Externalizer());
        this.addInternalExternalizer(new ManagerStatusResponse.Externalizer());
        this.addInternalExternalizer(new MultiClusterEventCallable.Externalizer());
        this.addInternalExternalizer(new IntermediateOperationExternalizer());
        this.addInternalExternalizer(new TerminalOperationExternalizer());
        this.addInternalExternalizer(new StreamMarshalling.StreamMarshallingExternalizer());
        this.addInternalExternalizer(new CommandInvocationId.Externalizer());
        this.addInternalExternalizer(new CacheFilters.CacheFiltersExternalizer());
        this.addInternalExternalizer(new OptionalExternalizer());
        this.addInternalExternalizer(new MetaParamsInternalMetadata.Externalizer());
        this.addInternalExternalizer(new MetaParams.Externalizer());
        this.addInternalExternalizer(new MetaParamExternalizers.LifespanExternalizer());
        this.addInternalExternalizer(new MetaParamExternalizers.EntryVersionParamExternalizer());
        this.addInternalExternalizer(new MetaParamExternalizers.NumericEntryVersionExternalizer());
        this.addInternalExternalizer(new EntryViews.ReadWriteViewImplExternalizer());
        this.addInternalExternalizer(new ReadCommittedEntry.Externalizer());
    }

    void addInternalExternalizer(AdvancedExternalizer<?> ext) {
        int id = this.checkInternalIdLimit(ext.getId(), ext);
        this.updateExtReadersWritersWithTypes(new ExternalizerAdapter(id, ext));
    }

    private void updateExtReadersWritersWithTypes(ExternalizerAdapter adapter) {
        this.updateExtReadersWritersWithTypes(adapter, adapter.id);
    }

    private void updateExtReadersWritersWithTypes(ExternalizerAdapter adapter, int readerIndex) {
        Set<Class<Object>> typeClasses = adapter.externalizer.getTypeClasses();
        if (typeClasses.size() > 0) {
            for (Class<Object> typeClass : typeClasses) {
                this.updateExtReadersWriters(adapter, typeClass, readerIndex);
            }
        } else {
            throw log.advanceExternalizerTypeClassesUndefined(adapter.externalizer.getClass().getName());
        }
    }

    private void loadForeignMarshallables(GlobalConfiguration globalCfg) {
        log.trace("Loading user defined externalizers");
        for (Map.Entry<Integer, AdvancedExternalizer<?>> config : globalCfg.serialization().advancedExternalizers().entrySet()) {
            AdvancedExternalizer<?> ext = config.getValue();
            Integer id = ext.getId();
            if (config.getKey() == null && id == null) {
                throw new CacheConfigurationException(String.format("No advanced externalizer identifier set for externalizer %s", ext.getClass().getName()));
            }
            if (config.getKey() != null) {
                id = config.getKey();
            }
            id = this.checkForeignIdLimit(id, ext);
            this.updateExtReadersWritersWithTypes(new ForeignExternalizerAdapter(id, ext), this.generateForeignReaderIndex(id));
        }
    }

    private void updateExtReadersWriters(ExternalizerAdapter adapter, Class<?> typeClass, int readerIndex) {
        this.writers.put(typeClass, adapter);
        ExternalizerAdapter prevReader = this.readers.put(readerIndex, adapter);
        if (prevReader != null && !prevReader.equals(adapter)) {
            throw log.duplicateExternalizerIdFound(adapter.id, typeClass, prevReader.externalizer.getClass().getName(), readerIndex);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Loaded externalizer %s for %s with id %s and reader index %s", adapter.externalizer.getClass().getName(), typeClass, adapter.id, readerIndex);
        }
    }

    private int checkInternalIdLimit(int id, AdvancedExternalizer<?> ext) {
        if (id >= 255) {
            throw log.internalExternalizerIdLimitExceeded(ext, id, 255);
        }
        return id;
    }

    private int checkForeignIdLimit(int id, AdvancedExternalizer<?> ext) {
        if (id < 0) {
            throw log.foreignExternalizerUsingNegativeId(ext, id);
        }
        return id;
    }

    private int generateForeignReaderIndex(int foreignId) {
        return Integer.MIN_VALUE | foreignId;
    }

    static class ForeignExternalizerAdapter
    extends ExternalizerAdapter {
        final int foreignId;

        ForeignExternalizerAdapter(int foreignId, AdvancedExternalizer<?> externalizer) {
            super(255, externalizer);
            this.foreignId = foreignId;
        }

        @Override
        int getExternalizerId() {
            return this.foreignId;
        }

        @Override
        public void writeObject(Marshaller output, Object object) throws IOException {
            output.write(this.id);
            UnsignedNumeric.writeUnsignedInt(output, this.foreignId);
            this.externalizer.writeObject(output, object);
        }
    }

    static class ExternalizerAdapter
    implements ObjectTable.Writer {
        final int id;
        final AdvancedExternalizer<Object> externalizer;

        ExternalizerAdapter(int id, AdvancedExternalizer<?> externalizer) {
            this.id = id;
            this.externalizer = externalizer;
        }

        public Object readObject(Unmarshaller input) throws IOException, ClassNotFoundException {
            return this.externalizer.readObject(input);
        }

        @Override
        public void writeObject(Marshaller output, Object object) throws IOException {
            output.write(this.id);
            this.externalizer.writeObject(output, object);
        }

        int getExternalizerId() {
            return this.id;
        }

        public String toString() {
            return this.externalizer.getClass().getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExternalizerAdapter that = (ExternalizerAdapter)o;
            if (this.id != that.id) {
                return false;
            }
            return !(this.externalizer != null ? !this.externalizer.getClass().equals(that.externalizer.getClass()) : that.externalizer != null);
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + (this.externalizer.getClass() != null ? this.externalizer.getClass().hashCode() : 0);
            return result;
        }
    }
}

