/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.termop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.termop.BaseTerminalOperation;

public abstract class AbstractForEachOperation<K, V, S extends BaseStream<V, S>>
extends BaseTerminalOperation
implements KeyTrackingTerminalOperation<K, V, K> {
    private final int batchSize;

    public AbstractForEachOperation(Iterable<IntermediateOperation> intermediateOperations, Supplier<Stream<CacheEntry>> supplier, int batchSize) {
        super(intermediateOperations, supplier);
        this.batchSize = batchSize;
    }

    @Override
    public boolean lostSegment(boolean stopIfLost) {
        return true;
    }

    @Override
    public List<V> performOperation(KeyTrackingTerminalOperation.IntermediateCollector<Collection<V>> response) {
        throw new UnsupportedOperationException();
    }

    protected abstract void handleList(List<V> var1);

    protected abstract void handleStreamForEach(S var1, List<V> var2);

    @Override
    public Collection<CacheEntry<K, K>> performOperationRehashAware(KeyTrackingTerminalOperation.IntermediateCollector<Collection<CacheEntry<K, K>>> response) {
        Object stream = ((BaseStream)this.supplier.get()).sequential();
        ArrayList<CacheEntry<K, K>> collectedValues = new ArrayList<CacheEntry<K, K>>(this.batchSize);
        ArrayList currentList = new ArrayList();
        Object[] currentKey = new Object[1];
        stream = ((Stream)stream).peek(e -> {
            if (!currentList.isEmpty()) {
                collectedValues.add(new ImmortalCacheEntry(currentKey[0], currentKey[0]));
                if (collectedValues.size() >= this.batchSize) {
                    this.handleList(currentList);
                    response.sendDataResonse(collectedValues);
                    collectedValues.clear();
                    currentList.clear();
                }
            }
            objectArray[0] = e.getKey();
        });
        for (IntermediateOperation intermediateOperation : this.intermediateOperations) {
            stream = intermediateOperation.perform(stream);
        }
        Object convertedStream = stream;
        this.handleStreamForEach(convertedStream, currentList);
        if (!currentList.isEmpty()) {
            this.handleList(currentList);
            collectedValues.add(new ImmortalCacheEntry(currentKey[0], currentKey[0]));
        }
        return collectedValues;
    }

    public int getBatchSize() {
        return this.batchSize;
    }
}

