/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.util.ArrayList;
import java.util.Set;
import java.util.function.Consumer;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.lifecycle.ComponentStatus;

public final class WriteOnlyManyCommand<K, V>
extends AbstractWriteManyCommand<K, V> {
    public static final byte COMMAND_ID = 56;
    private Set<? extends K> keys;
    private Consumer<EntryView.WriteEntryView<V>> f;

    public WriteOnlyManyCommand(Set<? extends K> keys, Consumer<EntryView.WriteEntryView<V>> f) {
        this.keys = keys;
        this.f = f;
    }

    public WriteOnlyManyCommand(WriteOnlyManyCommand<K, V> command) {
        this.keys = command.getKeys();
        this.f = command.f;
    }

    public WriteOnlyManyCommand() {
    }

    public Set<? extends K> getKeys() {
        return this.keys;
    }

    public void setKeys(Set<? extends K> keys) {
        this.keys = keys;
    }

    @Override
    public byte getCommandId() {
        return 56;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        this.keys = (Set)parameters[0];
        this.f = (Consumer)parameters[1];
        this.isForwarded = (Boolean)parameters[2];
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.keys, this.f, this.isForwarded};
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitWriteOnlyManyCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        ArrayList returns = new ArrayList(this.keys.size());
        this.keys.forEach(k -> {
            CacheEntry cacheEntry = ctx.lookupEntry(k);
            if (cacheEntry != null) {
                this.f.accept(EntryViews.writeOnly(cacheEntry));
                returns.add(null);
            }
        });
        return returns.stream();
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public Set<Object> getAffectedKeys() {
        return null;
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    @Override
    public boolean isWriteOnly() {
        return true;
    }
}

