/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.api.functional;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.api.functional.Listeners;
import org.infinispan.commons.api.functional.Param;
import org.infinispan.commons.api.functional.Status;
import org.infinispan.commons.api.functional.Traversable;

public interface FunctionalMap<K, V>
extends AutoCloseable {
    public FunctionalMap<K, V> withParams(Param<?> ... var1);

    public String getName();

    public Status getStatus();

    public static interface ReadWriteMap<K, V>
    extends FunctionalMap<K, V> {
        @Override
        public ReadWriteMap<K, V> withParams(Param<?> ... var1);

        public <R> CompletableFuture<R> eval(K var1, Function<EntryView.ReadWriteEntryView<K, V>, R> var2);

        public <R> CompletableFuture<R> eval(K var1, V var2, BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> var3);

        public <R> Traversable<R> evalMany(Map<? extends K, ? extends V> var1, BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> var2);

        public <R> Traversable<R> evalMany(Set<? extends K> var1, Function<EntryView.ReadWriteEntryView<K, V>, R> var2);

        public <R> Traversable<R> evalAll(Function<EntryView.ReadWriteEntryView<K, V>, R> var1);

        public Listeners.ReadWriteListeners<K, V> listeners();
    }

    public static interface WriteOnlyMap<K, V>
    extends FunctionalMap<K, V> {
        @Override
        public WriteOnlyMap<K, V> withParams(Param<?> ... var1);

        public CompletableFuture<Void> eval(K var1, V var2, BiConsumer<V, EntryView.WriteEntryView<V>> var3);

        public CompletableFuture<Void> eval(K var1, Consumer<EntryView.WriteEntryView<V>> var2);

        public CompletableFuture<Void> evalMany(Map<? extends K, ? extends V> var1, BiConsumer<V, EntryView.WriteEntryView<V>> var2);

        public CompletableFuture<Void> evalMany(Set<? extends K> var1, Consumer<EntryView.WriteEntryView<V>> var2);

        public CompletableFuture<Void> evalAll(Consumer<EntryView.WriteEntryView<V>> var1);

        public CompletableFuture<Void> truncate();

        public Listeners.WriteListeners<K, V> listeners();
    }

    public static interface ReadOnlyMap<K, V>
    extends FunctionalMap<K, V> {
        @Override
        public ReadOnlyMap<K, V> withParams(Param<?> ... var1);

        public <R> CompletableFuture<R> eval(K var1, Function<EntryView.ReadEntryView<K, V>, R> var2);

        public <R> Traversable<R> evalMany(Set<? extends K> var1, Function<EntryView.ReadEntryView<K, V>, R> var2);

        public Traversable<K> keys();

        public Traversable<EntryView.ReadEntryView<K, V>> entries();
    }
}

