/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.api.functional;

import java.util.Optional;
import org.infinispan.commons.api.functional.EntryVersion;

public interface MetaParam<T> {
    public T get();

    public static abstract class MetaLong
    implements MetaParam<Long> {
        protected final long value;

        public MetaLong(long value) {
            this.value = value;
        }

        @Override
        public Long get() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetaLong longMeta = (MetaLong)o;
            return this.value == longMeta.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }

    public static class MetaEntryVersion<T>
    implements Writable<EntryVersion<T>> {
        private final EntryVersion<T> entryVersion;

        public MetaEntryVersion(EntryVersion<T> entryVersion) {
            this.entryVersion = entryVersion;
        }

        @Override
        public EntryVersion<T> get() {
            return this.entryVersion;
        }

        public static <T> T type() {
            return (T)MetaEntryVersion.class;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetaEntryVersion that = (MetaEntryVersion)o;
            return this.entryVersion.equals(that.entryVersion);
        }

        public int hashCode() {
            return this.entryVersion.hashCode();
        }

        public String toString() {
            return "MetaEntryVersion{" + this.entryVersion + '}';
        }
    }

    public static final class MetaLastUsed
    extends MetaLong {
        public MetaLastUsed(long lastUsed) {
            super(lastUsed);
        }

        public String toString() {
            return "MetaLastUsed=" + this.value;
        }
    }

    public static final class MetaMaxIdle
    extends MetaLong
    implements Writable<Long> {
        private static final MetaMaxIdle DEFAULT = new MetaMaxIdle(-1L);

        public MetaMaxIdle(long maxIdle) {
            super(maxIdle);
        }

        public String toString() {
            return "MetaMaxIdle=" + this.value;
        }

        public static MetaMaxIdle defaultValue() {
            return DEFAULT;
        }
    }

    public static final class MetaCreated
    extends MetaLong {
        public MetaCreated(long created) {
            super(created);
        }

        public String toString() {
            return "MetaCreated=" + this.value;
        }
    }

    public static final class MetaLifespan
    extends MetaLong
    implements Writable<Long> {
        private static final MetaLifespan DEFAULT = new MetaLifespan(-1L);

        public MetaLifespan(long lifespan) {
            super(lifespan);
        }

        public String toString() {
            return "MetaLifespan=" + this.value;
        }

        public static MetaLifespan defaultValue() {
            return DEFAULT;
        }
    }

    public static interface Writable<T>
    extends MetaParam<T> {
    }

    public static interface Lookup {
        public <T> Optional<T> findMetaParam(Class<T> var1);
    }
}

