/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context.impl;

import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.remoting.transport.Address;

public abstract class AbstractInvocationContext
implements InvocationContext {
    private final Address origin;
    private ClassLoader classLoader;

    protected AbstractInvocationContext(Address origin) {
        this.origin = origin;
    }

    @Override
    public final Address getOrigin() {
        return this.origin;
    }

    @Override
    public boolean isOriginLocal() {
        return this.origin == null;
    }

    @Override
    public boolean hasLockedKey(Object key) {
        return this.getLockedKeys().contains(key);
    }

    @Override
    public AbstractInvocationContext clone() {
        try {
            return (AbstractInvocationContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!");
        }
    }

    @Override
    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public final void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public boolean replaceValue(Object key, InternalCacheEntry cacheEntry) {
        CacheEntry ce = this.lookupEntry(key);
        if (ce == null || ce.isNull() || ce.getValue() == null) {
            if (ce != null) {
                ce.setValue(cacheEntry.getValue());
                ce.setMetadata(cacheEntry.getMetadata());
                this.onEntryValueReplaced(key, cacheEntry);
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isEntryRemovedInContext(Object key) {
        CacheEntry ce = this.lookupEntry(key);
        return ce != null && ce.isRemoved() && ce.isChanged();
    }

    protected void onEntryValueReplaced(Object key, InternalCacheEntry cacheEntry) {
    }
}

