/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.eviction.EvictionType;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.filter.KeyFilter;
import org.infinispan.interceptors.CacheLoaderInterceptor;
import org.infinispan.interceptors.CacheWriterInterceptor;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.persistence.InitializationContextImpl;
import org.infinispan.persistence.async.AdvancedAsyncCacheLoader;
import org.infinispan.persistence.async.AdvancedAsyncCacheWriter;
import org.infinispan.persistence.async.AsyncCacheLoader;
import org.infinispan.persistence.async.AsyncCacheWriter;
import org.infinispan.persistence.async.State;
import org.infinispan.persistence.factory.CacheStoreFactoryRegistry;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.CacheWriter;
import org.infinispan.persistence.spi.LocalOnlyCacheLoader;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.support.AdvancedSingletonCacheWriter;
import org.infinispan.persistence.support.DelegatingCacheLoader;
import org.infinispan.persistence.support.DelegatingCacheWriter;
import org.infinispan.persistence.support.SingletonCacheWriter;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PersistenceManagerImpl
implements PersistenceManager {
    private static final Log log = LogFactory.getLog(PersistenceManagerImpl.class);
    Configuration configuration;
    AdvancedCache<Object, Object> cache;
    StreamingMarshaller m;
    TransactionManager transactionManager;
    private TimeService timeService;
    private final List<CacheLoader> loaders = new ArrayList<CacheLoader>();
    private final List<CacheWriter> writers = new ArrayList<CacheWriter>();
    private final ReadWriteLock storesMutex = new ReentrantReadWriteLock();
    private final Map<Object, StoreConfiguration> configMap = new HashMap<Object, StoreConfiguration>();
    private CacheStoreFactoryRegistry cacheStoreFactoryRegistry;
    private ExpirationManager expirationManager;
    volatile boolean enabled;
    private Executor persistenceExecutor;
    private ByteBufferFactory byteBufferFactory;
    private MarshalledEntryFactory marshalledEntryFactory;
    private volatile boolean clearOnStop;

    @Inject
    public void inject(AdvancedCache<Object, Object> cache, @ComponentName(value="org.infinispan.marshaller.cache") StreamingMarshaller marshaller, Configuration configuration, TransactionManager transactionManager, TimeService timeService, @ComponentName(value="org.infinispan.executors.persistence") ExecutorService persistenceExecutor, ByteBufferFactory byteBufferFactory, MarshalledEntryFactory marshalledEntryFactory, CacheStoreFactoryRegistry cacheStoreFactoryRegistry, ExpirationManager expirationManager) {
        this.cache = cache;
        this.m = marshaller;
        this.configuration = configuration;
        this.transactionManager = transactionManager;
        this.timeService = timeService;
        this.persistenceExecutor = persistenceExecutor;
        this.byteBufferFactory = byteBufferFactory;
        this.marshalledEntryFactory = marshalledEntryFactory;
        this.cacheStoreFactoryRegistry = cacheStoreFactoryRegistry;
        this.expirationManager = expirationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Start(priority=10)
    public void start() {
        this.enabled = this.configuration.persistence().usingStores();
        if (!this.enabled) {
            return;
        }
        try {
            this.createLoadersAndWriters();
            Transaction xaTx = null;
            if (this.transactionManager != null) {
                xaTx = this.transactionManager.suspend();
            }
            try {
                Lifecycle actual;
                HashSet<CacheWriter> undelegated = new HashSet<CacheWriter>();
                for (CacheWriter w : this.writers) {
                    w.start();
                    if (w instanceof DelegatingCacheWriter) {
                        actual = this.undelegate(w);
                        actual.start();
                        undelegated.add((CacheWriter)actual);
                    } else {
                        undelegated.add(w);
                    }
                    if (!this.configMap.get(w).purgeOnStartup()) continue;
                    if (!(w instanceof AdvancedCacheWriter)) {
                        throw new PersistenceException("'purgeOnStartup' can only be set on stores implementing " + AdvancedCacheWriter.class.getName());
                    }
                    ((AdvancedCacheWriter)w).clear();
                }
                for (CacheLoader l : this.loaders) {
                    if (!undelegated.contains(l)) {
                        l.start();
                    }
                    if (!(l instanceof DelegatingCacheLoader) || undelegated.contains(actual = this.undelegate(l))) continue;
                    actual.start();
                }
            }
            finally {
                if (xaTx != null) {
                    this.transactionManager.resume(xaTx);
                }
            }
        }
        catch (Exception e) {
            throw new CacheException("Unable to start cache loaders", e);
        }
    }

    @Override
    @Stop
    public void stop() {
        Lifecycle actual;
        if (this.clearOnStop) {
            this.clearAllStores(PersistenceManager.AccessMode.BOTH);
        }
        HashSet<CacheWriter> undelegated = new HashSet<CacheWriter>();
        for (CacheWriter w : this.writers) {
            w.stop();
            if (w instanceof DelegatingCacheWriter) {
                actual = this.undelegate(w);
                actual.stop();
                undelegated.add((CacheWriter)actual);
                continue;
            }
            undelegated.add(w);
        }
        for (CacheLoader l : this.loaders) {
            if (!undelegated.contains(l)) {
                l.stop();
            }
            if (!(l instanceof DelegatingCacheLoader) || undelegated.contains(actual = this.undelegate(l))) continue;
            actual.stop();
        }
    }

    @Override
    @Start(priority=56)
    public void preload() {
        if (!this.enabled) {
            return;
        }
        AdvancedCacheLoader preloadCl = null;
        for (CacheLoader l : this.loaders) {
            if (!this.configMap.get(l).preload()) continue;
            if (!(l instanceof AdvancedCacheLoader)) {
                throw new PersistenceException("Cannot preload from cache loader '" + l.getClass().getName() + "' as it doesn't implement '" + AdvancedCacheLoader.class.getName() + "'");
            }
            preloadCl = (AdvancedCacheLoader)l;
            if (!(preloadCl instanceof AdvancedAsyncCacheLoader)) break;
            preloadCl = (AdvancedCacheLoader)((AdvancedAsyncCacheLoader)preloadCl).undelegate();
            break;
        }
        if (preloadCl == null) {
            return;
        }
        long start = this.timeService.time();
        final long maxEntries = this.getMaxEntries();
        final AtomicInteger loadedEntries = new AtomicInteger(0);
        final AdvancedCache<Object, Object> flaggedCache = this.getCacheForStateInsertion();
        preloadCl.process(null, new AdvancedCacheLoader.CacheLoaderTask(){

            public void processEntry(MarshalledEntry me, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
                if ((long)loadedEntries.getAndIncrement() >= maxEntries) {
                    taskContext.stop();
                    return;
                }
                Metadata metadata = me.getMetadata() != null ? ((InternalMetadataImpl)me.getMetadata()).actual() : null;
                PersistenceManagerImpl.this.preloadKey(flaggedCache, me.getKey(), me.getValue(), metadata);
            }
        }, new WithinThreadExecutor(), true, true);
        log.debugf("Preloaded %s keys in %s", (Object)loadedEntries, (Object)Util.prettyPrintTime(this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableStore(String storeType) {
        if (this.enabled) {
            this.storesMutex.writeLock().lock();
            try {
                Iterator<CacheLoader> clIt = this.loaders.iterator();
                while (clIt.hasNext()) {
                    CacheLoader l = clIt.next();
                    if (!this.undelegate(l).getClass().getName().equals(storeType)) continue;
                    clIt.remove();
                }
                Iterator<CacheWriter> cwIt = this.writers.iterator();
                while (cwIt.hasNext()) {
                    CacheWriter w = cwIt.next();
                    if (!this.undelegate(w).getClass().getName().equals(storeType)) continue;
                    cwIt.remove();
                }
            }
            finally {
                this.storesMutex.writeLock().unlock();
            }
            if (this.loaders.isEmpty() && this.writers.isEmpty()) {
                InterceptorChain chain = this.cache.getComponentRegistry().getComponent(InterceptorChain.class);
                List<CommandInterceptor> loaderInterceptors = chain.getInterceptorsWhichExtend(CacheLoaderInterceptor.class);
                if (loaderInterceptors.isEmpty()) {
                    log.persistenceWithoutCacheLoaderInterceptor();
                } else {
                    for (CommandInterceptor interceptor : loaderInterceptors) {
                        ((CacheLoaderInterceptor)interceptor).disableInterceptor();
                    }
                }
                List<CommandInterceptor> writerInterceptors = chain.getInterceptorsWhichExtend(CacheWriterInterceptor.class);
                if (writerInterceptors.isEmpty()) {
                    log.persistenceWithoutCacheWriteInterceptor();
                } else {
                    for (CommandInterceptor interceptor : writerInterceptors) {
                        ((CacheWriterInterceptor)interceptor).disableInterceptor();
                    }
                }
                this.removeInterceptors(loaderInterceptors);
                this.removeInterceptors(writerInterceptors);
                this.enabled = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Set<T> getStores(Class<T> storeClass) {
        this.storesMutex.readLock().lock();
        try {
            Lifecycle real;
            HashSet<CacheLoader> result = new HashSet<CacheLoader>();
            for (CacheLoader l : this.loaders) {
                real = this.undelegate(l);
                if (!storeClass.isInstance(real)) continue;
                result.add((CacheLoader)real);
            }
            for (CacheWriter w : this.writers) {
                real = this.undelegate(w);
                if (!storeClass.isInstance(real)) continue;
                result.add((CacheLoader)real);
            }
            HashSet<CacheLoader> hashSet = result;
            return hashSet;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getStoresAsString() {
        this.storesMutex.readLock().lock();
        try {
            HashSet<String> loaderTypes = new HashSet<String>(this.loaders.size());
            for (CacheLoader loader : this.loaders) {
                loaderTypes.add(this.undelegate(loader).getClass().getName());
            }
            for (CacheWriter writer : this.writers) {
                loaderTypes.add(this.undelegate(writer).getClass().getName());
            }
            HashSet<String> hashSet = loaderTypes;
            return hashSet;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeExpired() {
        if (!this.enabled) {
            return;
        }
        long start = -1L;
        try {
            if (log.isTraceEnabled()) {
                log.trace("Purging cache store of expired entries");
                start = this.timeService.time();
            }
            this.storesMutex.readLock().lock();
            try {
                for (CacheWriter w : this.writers) {
                    if (!(w instanceof AdvancedCacheWriter)) continue;
                    ((AdvancedCacheWriter)w).purge(this.persistenceExecutor, key -> this.expirationManager.handleInStoreExpiration(key));
                }
            }
            finally {
                this.storesMutex.readLock().unlock();
            }
            if (log.isTraceEnabled()) {
                log.tracef("Purging cache store completed in %s", (Object)Util.prettyPrintTime(this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
            }
        }
        catch (Exception e) {
            log.exceptionPurgingDataContainer(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllStores(PersistenceManager.AccessMode mode) {
        this.storesMutex.readLock().lock();
        try {
            for (CacheWriter w : this.writers) {
                if (!(w instanceof AdvancedCacheWriter) || !mode.canPerform(this.configMap.get(w))) continue;
                ((AdvancedCacheWriter)w).clear();
            }
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteFromAllStores(Object key, PersistenceManager.AccessMode mode) {
        this.storesMutex.readLock().lock();
        try {
            boolean removed = false;
            for (CacheWriter w : this.writers) {
                if (!mode.canPerform(this.configMap.get(w))) continue;
                removed |= w.delete(key);
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    @Override
    public void processOnAllStores(KeyFilter keyFilter, AdvancedCacheLoader.CacheLoaderTask task, boolean fetchValue, boolean fetchMetadata) {
        this.processOnAllStores(this.persistenceExecutor, keyFilter, task, fetchValue, fetchMetadata);
    }

    @Override
    public void processOnAllStores(Executor executor, KeyFilter keyFilter, AdvancedCacheLoader.CacheLoaderTask task, boolean fetchValue, boolean fetchMetadata) {
        this.processOnAllStores(executor, keyFilter, task, fetchValue, fetchMetadata, PersistenceManager.AccessMode.BOTH);
    }

    @Override
    public void processOnAllStores(KeyFilter keyFilter, AdvancedCacheLoader.CacheLoaderTask task, boolean fetchValue, boolean fetchMetadata, PersistenceManager.AccessMode mode) {
        this.processOnAllStores(this.persistenceExecutor, keyFilter, task, fetchValue, fetchMetadata, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processOnAllStores(Executor executor, KeyFilter keyFilter, AdvancedCacheLoader.CacheLoaderTask task, boolean fetchValue, boolean fetchMetadata, PersistenceManager.AccessMode mode) {
        this.storesMutex.readLock().lock();
        try {
            for (CacheLoader loader : this.loaders) {
                if (!mode.canPerform(this.configMap.get(loader)) || !(loader instanceof AdvancedCacheLoader)) continue;
                ((AdvancedCacheLoader)loader).process(keyFilter, task, executor, fetchValue, fetchMetadata);
            }
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MarshalledEntry loadFromAllStores(Object key, InvocationContext context) {
        this.storesMutex.readLock().lock();
        try {
            for (CacheLoader l : this.loaders) {
                if (!context.isOriginLocal() && this.isLocalOnlyLoader(l)) continue;
                MarshalledEntry load = l.load(key);
                if (load == null) continue;
                MarshalledEntry marshalledEntry = load;
                return marshalledEntry;
            }
            Iterator<CacheLoader> iterator = null;
            return iterator;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    private boolean isLocalOnlyLoader(CacheLoader loader) {
        CacheLoader unwrappedLoader;
        if (loader instanceof LocalOnlyCacheLoader) {
            return true;
        }
        return loader instanceof DelegatingCacheLoader && (unwrappedLoader = ((DelegatingCacheLoader)loader).undelegate()) instanceof LocalOnlyCacheLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToAllStores(MarshalledEntry marshalledEntry, PersistenceManager.AccessMode mode) {
        this.storesMutex.readLock().lock();
        try {
            for (CacheWriter w : this.writers) {
                if (!mode.canPerform(this.configMap.get(w))) continue;
                w.write(marshalledEntry);
            }
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdvancedCacheLoader getStateTransferProvider() {
        this.storesMutex.readLock().lock();
        try {
            for (CacheLoader l : this.loaders) {
                StoreConfiguration storeConfiguration = this.configMap.get(l);
                if (!storeConfiguration.fetchPersistentState() || storeConfiguration.shared()) continue;
                AdvancedCacheLoader advancedCacheLoader = (AdvancedCacheLoader)l;
                return advancedCacheLoader;
            }
            Iterator<CacheLoader> iterator = null;
            return iterator;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.storesMutex.readLock().lock();
        try {
            for (CacheLoader l : this.loaders) {
                if (!(l instanceof AdvancedCacheLoader)) continue;
                int n = ((AdvancedCacheLoader)l).size();
                return n;
            }
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
        return 0;
    }

    @Override
    public void setClearOnStop(boolean clearOnStop) {
        this.clearOnStop = clearOnStop;
    }

    public List<CacheLoader> getAllLoaders() {
        return Collections.unmodifiableList(this.loaders);
    }

    public List<CacheWriter> getAllWriters() {
        return Collections.unmodifiableList(this.writers);
    }

    private void createLoadersAndWriters() {
        for (StoreConfiguration cfg : this.configuration.persistence().stores()) {
            Object bareInstance = this.cacheStoreFactoryRegistry.createInstance(cfg);
            StoreConfiguration processedConfiguration = this.cacheStoreFactoryRegistry.processStoreConfiguration(cfg);
            CacheWriter writer = this.createCacheWriter(bareInstance);
            CacheLoader loader = this.createCacheLoader(bareInstance);
            writer = this.postProcessWriter(processedConfiguration, writer);
            loader = this.postProcessReader(processedConfiguration, writer, loader);
            InitializationContextImpl ctx = new InitializationContextImpl(processedConfiguration, this.cache, this.m, this.timeService, this.byteBufferFactory, this.marshalledEntryFactory);
            this.initializeLoader(processedConfiguration, loader, ctx);
            this.initializeWriter(processedConfiguration, writer, ctx);
            this.initializeBareInstance(bareInstance, ctx);
        }
    }

    private CacheLoader postProcessReader(StoreConfiguration cfg, CacheWriter writer, CacheLoader loader) {
        if (cfg.async().enabled() && loader != null && writer != null) {
            loader = this.createAsyncLoader(loader, (AsyncCacheWriter)writer);
        }
        return loader;
    }

    private CacheWriter postProcessWriter(StoreConfiguration cfg, CacheWriter writer) {
        if (writer != null) {
            if (cfg.ignoreModifications()) {
                writer = null;
            } else if (cfg.singletonStore().enabled()) {
                writer = this.createSingletonWriter(cfg, writer);
            } else if (cfg.async().enabled()) {
                writer = this.createAsyncWriter(writer);
            }
        }
        return writer;
    }

    private CacheLoader createAsyncLoader(CacheLoader loader, AsyncCacheWriter asyncWriter) {
        AtomicReference<State> state = asyncWriter.getState();
        loader = loader instanceof AdvancedCacheLoader ? new AdvancedAsyncCacheLoader(loader, state) : new AsyncCacheLoader(loader, state);
        return loader;
    }

    private SingletonCacheWriter createSingletonWriter(StoreConfiguration cfg, CacheWriter writer) {
        return writer instanceof AdvancedCacheWriter ? new AdvancedSingletonCacheWriter(writer, cfg.singletonStore()) : new SingletonCacheWriter(writer, cfg.singletonStore());
    }

    private void initializeWriter(StoreConfiguration cfg, CacheWriter writer, InitializationContextImpl ctx) {
        if (writer != null) {
            if (writer instanceof DelegatingCacheWriter) {
                writer.init(ctx);
            }
            this.writers.add(writer);
            this.configMap.put(writer, cfg);
        }
    }

    private void initializeLoader(StoreConfiguration cfg, CacheLoader loader, InitializationContextImpl ctx) {
        if (loader != null) {
            if (loader instanceof DelegatingCacheLoader) {
                loader.init(ctx);
            }
            this.loaders.add(loader);
            this.configMap.put(loader, cfg);
        }
    }

    private void initializeBareInstance(Object instance, InitializationContextImpl ctx) {
        if (instance instanceof CacheWriter) {
            ((CacheWriter)instance).init(ctx);
        } else {
            ((CacheLoader)instance).init(ctx);
        }
    }

    private CacheLoader createCacheLoader(Object instance) {
        return instance instanceof CacheLoader ? (CacheLoader)instance : null;
    }

    private CacheWriter createCacheWriter(Object instance) {
        return instance instanceof CacheWriter ? (CacheWriter)instance : null;
    }

    protected AsyncCacheWriter createAsyncWriter(CacheWriter writer) {
        return writer instanceof AdvancedCacheWriter ? new AdvancedAsyncCacheWriter(writer) : new AsyncCacheWriter(writer);
    }

    private CacheLoader undelegate(CacheLoader l) {
        return l instanceof DelegatingCacheLoader ? ((DelegatingCacheLoader)l).undelegate() : l;
    }

    private CacheWriter undelegate(CacheWriter w) {
        return w instanceof DelegatingCacheWriter ? ((DelegatingCacheWriter)w).undelegate() : w;
    }

    private AdvancedCache<Object, Object> getCacheForStateInsertion() {
        ArrayList<Flag> flags = new ArrayList<Flag>(Arrays.asList(Flag.CACHE_MODE_LOCAL, Flag.SKIP_OWNERSHIP_CHECK, Flag.IGNORE_RETURN_VALUES, Flag.SKIP_CACHE_STORE, Flag.SKIP_LOCKING));
        boolean hasShared = false;
        for (CacheWriter w : this.writers) {
            if (!this.configMap.get(w).shared()) continue;
            hasShared = true;
            break;
        }
        if (hasShared) {
            if (this.indexShareable()) {
                flags.add(Flag.SKIP_INDEXING);
            }
        } else {
            flags.add(Flag.SKIP_INDEXING);
        }
        return this.cache.getAdvancedCache().withFlags(flags.toArray(new Flag[flags.size()]));
    }

    private boolean localIndexingEnabled() {
        return this.configuration.indexing().index() == Index.LOCAL;
    }

    private boolean indexShareable() {
        return this.configuration.indexing().indexShareable();
    }

    private long getMaxEntries() {
        long ne = 0xFFFFFFFFFFFFFFL;
        if (this.configuration.eviction().strategy().isEnabled() && this.configuration.eviction().type() == EvictionType.COUNT) {
            ne = this.configuration.eviction().maxEntries();
        }
        return ne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preloadKey(AdvancedCache<Object, Object> cache, Object key, Object value, Metadata metadata) {
        Transaction transaction = this.suspendIfNeeded();
        boolean success = false;
        try {
            try {
                this.beginIfNeeded();
                cache.put(key, value, metadata);
                success = true;
            }
            catch (Exception e) {
                throw new PersistenceException("Unable to preload!", e);
            }
            finally {
                this.commitIfNeeded(success);
            }
        }
        finally {
            this.resumeIfNeeded(transaction);
        }
    }

    private void resumeIfNeeded(Transaction transaction) {
        if (this.configuration.transaction().transactionMode().isTransactional() && this.transactionManager != null && transaction != null) {
            try {
                this.transactionManager.resume(transaction);
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
    }

    private Transaction suspendIfNeeded() {
        if (this.configuration.transaction().transactionMode().isTransactional() && this.transactionManager != null) {
            try {
                return this.transactionManager.suspend();
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
        return null;
    }

    private void beginIfNeeded() {
        if (this.configuration.transaction().transactionMode().isTransactional() && this.transactionManager != null) {
            try {
                this.transactionManager.begin();
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
    }

    private void commitIfNeeded(boolean success) {
        if (this.configuration.transaction().transactionMode().isTransactional() && this.transactionManager != null) {
            try {
                if (success) {
                    this.transactionManager.commit();
                } else {
                    this.transactionManager.rollback();
                }
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
    }

    public Executor getPersistenceExecutor() {
        return this.persistenceExecutor;
    }

    public StreamingMarshaller getMarshaller() {
        return this.m;
    }

    private void removeInterceptors(Collection<CommandInterceptor> interceptors) {
        if (interceptors.isEmpty()) {
            return;
        }
        for (CommandInterceptor interceptor : interceptors) {
            this.cache.removeInterceptor(interceptor.getClass());
        }
    }
}

