/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.inboundhandler.BasePerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.DefaultTopologyRunnable;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.inboundhandler.TopologyMode;
import org.infinispan.remoting.inboundhandler.action.ActionListener;
import org.infinispan.remoting.inboundhandler.action.ActionState;
import org.infinispan.remoting.inboundhandler.action.CheckTopologyAction;
import org.infinispan.remoting.inboundhandler.action.DefaultReadyAction;
import org.infinispan.remoting.inboundhandler.action.LockAction;
import org.infinispan.remoting.inboundhandler.action.ReadyAction;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.concurrent.locks.LockListener;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.LockState;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NonTotalOrderPerCacheInboundInvocationHandler
extends BasePerCacheInboundInvocationHandler
implements LockListener {
    private static final Log log = LogFactory.getLog(NonTotalOrderPerCacheInboundInvocationHandler.class);
    private static final boolean trace = log.isTraceEnabled();
    private final CheckTopologyAction checkTopologyAction = new CheckTopologyAction(this);
    private LockManager lockManager;
    private ClusteringDependentLogic clusteringDependentLogic;
    private Configuration configuration;

    @Inject
    public void inject(LockManager lockManager, ClusteringDependentLogic clusteringDependentLogic, Configuration configuration) {
        this.lockManager = lockManager;
        this.clusteringDependentLogic = clusteringDependentLogic;
        this.configuration = configuration;
    }

    @Override
    public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
        if (order == DeliverOrder.TOTAL) {
            this.unexpectedDeliverMode(command, order);
        }
        try {
            BlockingRunnable runnable;
            int commandTopologyId = NonTotalOrderPerCacheInboundInvocationHandler.extractCommandTopologyId(command);
            boolean onExecutorService = this.executeOnExecutorService(order, command);
            switch (command.getCommandId()) {
                case 1: {
                    runnable = this.createReadyActionRunnable(command, reply, commandTopologyId, true, onExecutorService, this.createReadyActionForSingleRpcCommand(commandTopologyId, (SingleRpcCommand)command));
                    break;
                }
                case 2: {
                    runnable = this.createReadyActionRunnable(command, reply, commandTopologyId, true, onExecutorService, this.createReadyActionForMultipleRpcCommand(commandTopologyId, (MultipleRpcCommand)command));
                    break;
                }
                default: {
                    runnable = this.createDefaultRunnable(command, reply, commandTopologyId, command.getCommandId() != 15, onExecutorService);
                }
            }
            this.handleRunnable(runnable, onExecutorService);
        }
        catch (Throwable throwable) {
            reply.reply(this.exceptionHandlingCommand(command, throwable));
        }
    }

    @Override
    public void onEvent(LockState state) {
        this.remoteCommandsExecutor.checkForReadyTasks();
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected boolean isTraceEnabled() {
        return trace;
    }

    private BlockingRunnable createReadyActionRunnable(CacheRpcCommand command, Reply reply, int commandTopologyId, boolean waitTransactionalData, boolean onExecutorService, final ReadyAction readyAction) {
        TopologyMode topologyMode = TopologyMode.create(onExecutorService, waitTransactionalData);
        if (onExecutorService && readyAction != null) {
            readyAction.addListener(this.remoteCommandsExecutor::checkForReadyTasks);
            return new DefaultTopologyRunnable(this, command, reply, topologyMode, commandTopologyId){

                @Override
                public boolean isReady() {
                    return super.isReady() && readyAction.isReady();
                }
            };
        }
        return new DefaultTopologyRunnable(this, command, reply, topologyMode, commandTopologyId);
    }

    private ReadyAction createReadyAction(int topologyId, RemoteLockCommand command) {
        if (command.hasSkipLocking()) {
            return null;
        }
        Collection<Object> keys = command.getKeysToLock();
        if (keys.isEmpty()) {
            return null;
        }
        long timeoutMillis = command.hasZeroLockAcquisition() ? 0L : this.configuration.locking().lockAcquisitionTimeout();
        DefaultReadyAction action = new DefaultReadyAction(new ActionState(command, topologyId, timeoutMillis), this.checkTopologyAction, new LockAction(this.lockManager, this.clusteringDependentLogic));
        action.registerListener();
        return action;
    }

    private ReadyAction createReadyActionForSingleRpcCommand(int topologyId, SingleRpcCommand singleRpcCommand) {
        ReplicableCommand command = singleRpcCommand.getCommand();
        return command instanceof RemoteLockCommand ? this.createReadyAction(topologyId, (RemoteLockCommand)((Object)command)) : null;
    }

    private ReadyAction createReadyActionForMultipleRpcCommand(int topologyId, MultipleRpcCommand command) {
        ReplicableCommand[] commands = command.getCommands();
        ArrayList list = new ArrayList(commands.length);
        InfinispanCollections.forEach(commands, cmd -> {
            ReadyAction action;
            if (cmd instanceof RemoteLockCommand && (action = this.createReadyAction(topologyId, (RemoteLockCommand)((Object)cmd))) != null) {
                list.add(action);
            }
        });
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return (ReadyAction)list.get(0);
        }
        CompositeAction action = new CompositeAction(list);
        action.registerListener();
        return action;
    }

    private static class CompositeAction
    implements ReadyAction,
    ActionListener {
        private final Collection<ReadyAction> actions;
        private final AtomicBoolean notify;
        private volatile ActionListener listener;

        private CompositeAction(Collection<ReadyAction> actions) {
            this.actions = actions;
            this.notify = new AtomicBoolean(false);
        }

        public void registerListener() {
            this.actions.forEach(readyAction -> readyAction.addListener(this));
        }

        @Override
        public boolean isReady() {
            for (ReadyAction action : this.actions) {
                if (action.isReady()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void addListener(ActionListener listener) {
            this.listener = listener;
        }

        @Override
        public void onComplete() {
            ActionListener actionListener = this.listener;
            if (this.isReady() && actionListener != null && this.notify.compareAndSet(false, true)) {
                actionListener.onComplete();
            }
        }
    }
}

