/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.RemoteFetchingCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.util.ReadOnlySegmentAwareMap;
import org.infinispan.distribution.util.ReadOnlySegmentAwareSet;
import org.infinispan.interceptors.distribution.BaseDistributionInterceptor;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NonTxDistributionInterceptor
extends BaseDistributionInterceptor {
    private static Log log = LogFactory.getLog(NonTxDistributionInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitGetCommand(ctx, command);
    }

    @Override
    public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.visitGetCommand(ctx, command);
    }

    private <T extends AbstractDataCommand> Object visitGetCommand(InvocationContext ctx, T command) throws Throwable {
        Object key;
        CacheEntry entry;
        if (ctx.isOriginLocal() && this.valueIsMissing(entry = ctx.lookupEntry(key = command.getKey()))) {
            InternalCacheEntry localEntry;
            InternalCacheEntry remoteEntry = null;
            if (this.readNeedsRemoteValue(ctx, command)) {
                if (trace) {
                    log.tracef("Doing a remote get for key %s", key);
                }
                remoteEntry = this.retrieveFromRemoteSource(key, ctx, false, command, false);
                ((RemoteFetchingCommand)((Object)command)).setRemotelyFetchedValue(remoteEntry);
                if (remoteEntry != null) {
                    this.wrapInternalCacheEntry(remoteEntry, ctx, key, false, command);
                }
            }
            if (remoteEntry == null && (localEntry = this.fetchValueLocallyIfAvailable(this.dm.getReadConsistentHash(), key)) != null) {
                this.wrapInternalCacheEntry(localEntry, ctx, key, false, command);
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Map<Object, Object> originalMap = command.getMap();
        ConsistentHash ch = this.dm.getConsistentHash();
        Address localAddress = this.rpcManager.getAddress();
        if (ctx.isOriginLocal()) {
            ArrayList<CompletableFuture<Map<Address, Response>>> futures = new ArrayList<CompletableFuture<Map<Address, Response>>>(this.rpcManager.getMembers().size() - 1);
            RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
            for (Address member : this.rpcManager.getMembers()) {
                ReadOnlySegmentAwareMap<Object, Object> segmentEntriesMap;
                Set<Integer> segments;
                if (member.equals(this.rpcManager.getAddress()) || (segments = ch.getPrimarySegmentsForOwner(member)).isEmpty() || (segmentEntriesMap = new ReadOnlySegmentAwareMap<Object, Object>(originalMap, ch, segments)).isEmpty()) continue;
                PutMapCommand putMapCommand = new PutMapCommand(command);
                putMapCommand.setMap(segmentEntriesMap);
                CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(member), putMapCommand, options);
                futures.add(future);
            }
            if (futures.size() > 0) {
                CompletableFuture[] futuresArray = new CompletableFuture[futures.size()];
                CompletableFuture<Void> compFuture = CompletableFuture.allOf(futures.toArray(futuresArray));
                try {
                    compFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException e) {
                    throw new RemoteException("Exception while processing put on primary owner", e.getCause());
                }
                catch (TimeoutException e) {
                    throw new CacheException(e);
                }
            }
        }
        if (!command.isForwarded() && ch.getNumOwners() > 1) {
            HashMap backupOwnerSegments = new HashMap();
            int segmentCount = ch.getNumSegments();
            for (int i = 0; i < segmentCount; ++i) {
                Iterator<Address> iter = ch.locateOwnersForSegment(i).iterator();
                if (!iter.next().equals(localAddress)) continue;
                while (iter.hasNext()) {
                    Address backupOwner = iter.next();
                    Set segments = (Set)backupOwnerSegments.get(backupOwner);
                    if (segments == null) {
                        segments = new HashSet();
                        backupOwnerSegments.put(backupOwner, segments);
                    }
                    segments.add(i);
                }
            }
            int backupOwnerSize = backupOwnerSegments.size();
            if (backupOwnerSize > 0) {
                ArrayList<CompletableFuture<Map<Address, Response>>> futures = new ArrayList<CompletableFuture<Map<Address, Response>>>(backupOwnerSize);
                RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
                command.addFlag(Flag.SKIP_LOCKING);
                command.setForwarded(true);
                for (Map.Entry entry : backupOwnerSegments.entrySet()) {
                    Set segments = (Set)entry.getValue();
                    ReadOnlySegmentAwareMap<Object, Object> segmentEntriesMap = new ReadOnlySegmentAwareMap<Object, Object>(originalMap, ch, segments);
                    if (segmentEntriesMap.isEmpty()) continue;
                    PutMapCommand copy = new PutMapCommand(command);
                    copy.setMap(segmentEntriesMap);
                    CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(entry.getKey()), copy, options);
                    futures.add(future);
                }
                command.setForwarded(false);
                if (futures.size() > 0) {
                    CompletableFuture[] futuresArray = new CompletableFuture[futures.size()];
                    CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(futuresArray));
                    try {
                        completableFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (ExecutionException e) {
                        throw new RemoteException("Exception while processing put on backup owner", e.getCause());
                    }
                    catch (TimeoutException e) {
                        throw new CacheException(e);
                    }
                }
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadOnlyKeyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) throws Throwable {
        Object key;
        CacheEntry entry;
        if (ctx.isOriginLocal() && this.valueIsMissing(entry = ctx.lookupEntry(key = command.getKey()))) {
            InternalCacheEntry remoteEntry = null;
            if (this.readNeedsRemoteValue(ctx, command)) {
                if (trace) {
                    log.tracef("Doing a remote get for key %s", key);
                }
                if ((remoteEntry = this.retrieveFromRemoteSource(key, ctx, false, command, false)) != null) {
                    this.wrapInternalCacheEntry(remoteEntry, ctx, key, false, command);
                }
                return command.perform(remoteEntry);
            }
            InternalCacheEntry localEntry = this.fetchValueLocallyIfAvailable(this.dm.getReadConsistentHash(), key);
            if (localEntry != null) {
                this.wrapInternalCacheEntry(localEntry, ctx, key, false, command);
            }
            return command.perform(localEntry);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) throws Throwable {
        return super.visitReadOnlyManyCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
        Map originalMap = command.getEntries();
        ConsistentHash ch = this.dm.getConsistentHash();
        Address localAddress = this.rpcManager.getAddress();
        if (ctx.isOriginLocal()) {
            ArrayList<CompletableFuture<Map<Address, Response>>> futures = new ArrayList<CompletableFuture<Map<Address, Response>>>(this.rpcManager.getMembers().size() - 1);
            RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
            for (Address member : this.rpcManager.getMembers()) {
                ReadOnlySegmentAwareMap segmentEntriesMap;
                Set<Integer> segments;
                if (member.equals(this.rpcManager.getAddress()) || (segments = ch.getPrimarySegmentsForOwner(member)).isEmpty() || (segmentEntriesMap = new ReadOnlySegmentAwareMap(originalMap, ch, segments)).isEmpty()) continue;
                WriteOnlyManyEntriesCommand writeOnlyManyEntriesCommand = new WriteOnlyManyEntriesCommand(command);
                writeOnlyManyEntriesCommand.setEntries(segmentEntriesMap);
                CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(member), writeOnlyManyEntriesCommand, options);
                futures.add(future);
            }
            if (futures.size() > 0) {
                CompletableFuture[] futuresArray = new CompletableFuture[futures.size()];
                CompletableFuture<Void> compFuture = CompletableFuture.allOf(futures.toArray(futuresArray));
                try {
                    compFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException e) {
                    throw new RemoteException("Exception while processing put on primary owner", e.getCause());
                }
                catch (TimeoutException e) {
                    throw new CacheException(e);
                }
            }
        }
        if (!command.isForwarded() && ch.getNumOwners() > 1) {
            HashMap<Address, HashSet<Integer>> backupOwnerSegments = new HashMap<Address, HashSet<Integer>>();
            int segmentCount = ch.getNumSegments();
            for (int i = 0; i < segmentCount; ++i) {
                Iterator<Address> iter = ch.locateOwnersForSegment(i).iterator();
                if (!iter.next().equals(localAddress)) continue;
                while (iter.hasNext()) {
                    Address backupOwner = iter.next();
                    HashSet<Integer> segments = (HashSet<Integer>)backupOwnerSegments.get(backupOwner);
                    if (segments == null) {
                        segments = new HashSet<Integer>();
                        backupOwnerSegments.put(backupOwner, segments);
                    }
                    segments.add(i);
                }
            }
            int backupOwnerSize = backupOwnerSegments.size();
            if (backupOwnerSize > 0) {
                ArrayList<CompletableFuture<Map<Address, Response>>> futures = new ArrayList<CompletableFuture<Map<Address, Response>>>(backupOwnerSize);
                RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
                command.setFlags(new Flag[]{Flag.SKIP_LOCKING});
                command.setForwarded(true);
                for (Map.Entry entry : backupOwnerSegments.entrySet()) {
                    Set segments = (Set)entry.getValue();
                    ReadOnlySegmentAwareMap segmentEntriesMap = new ReadOnlySegmentAwareMap(originalMap, ch, segments);
                    if (segmentEntriesMap.isEmpty()) continue;
                    WriteOnlyManyEntriesCommand copy = new WriteOnlyManyEntriesCommand(command);
                    copy.setEntries(segmentEntriesMap);
                    CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(entry.getKey()), copy, options);
                    futures.add(future);
                }
                command.setForwarded(false);
                if (futures.size() > 0) {
                    CompletableFuture[] futuresArray = new CompletableFuture[futures.size()];
                    CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(futuresArray));
                    try {
                        completableFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (ExecutionException e) {
                        throw new RemoteException("Exception while processing put on backup owner", e.getCause());
                    }
                    catch (TimeoutException e) {
                        throw new CacheException(e);
                    }
                }
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
        Set originalMap = command.getKeys();
        ConsistentHash ch = this.dm.getConsistentHash();
        Address localAddress = this.rpcManager.getAddress();
        if (ctx.isOriginLocal()) {
            ArrayList<CompletableFuture<Map<Address, Response>>> futures = new ArrayList<CompletableFuture<Map<Address, Response>>>(this.rpcManager.getMembers().size() - 1);
            RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
            for (Address member : this.rpcManager.getMembers()) {
                ReadOnlySegmentAwareSet segmentKeysSet;
                Set<Integer> segments;
                if (member.equals(this.rpcManager.getAddress()) || (segments = ch.getPrimarySegmentsForOwner(member)).isEmpty() || (segmentKeysSet = new ReadOnlySegmentAwareSet(originalMap, ch, segments)).isEmpty()) continue;
                WriteOnlyManyCommand writeOnlyManyCommand = new WriteOnlyManyCommand(command);
                writeOnlyManyCommand.setKeys(segmentKeysSet);
                CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(member), writeOnlyManyCommand, options);
                futures.add(future);
            }
            if (futures.size() > 0) {
                CompletableFuture[] futuresArray = new CompletableFuture[futures.size()];
                CompletableFuture<Void> compFuture = CompletableFuture.allOf(futures.toArray(futuresArray));
                try {
                    compFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException e) {
                    throw new RemoteException("Exception while processing put on primary owner", e.getCause());
                }
                catch (TimeoutException e) {
                    throw new CacheException(e);
                }
            }
        }
        if (!command.isForwarded() && ch.getNumOwners() > 1) {
            HashMap<Address, HashSet<Integer>> backupOwnerSegments = new HashMap<Address, HashSet<Integer>>();
            int segmentCount = ch.getNumSegments();
            for (int i = 0; i < segmentCount; ++i) {
                Iterator<Address> iter = ch.locateOwnersForSegment(i).iterator();
                if (!iter.next().equals(localAddress)) continue;
                while (iter.hasNext()) {
                    Address backupOwner = iter.next();
                    HashSet<Integer> segments = (HashSet<Integer>)backupOwnerSegments.get(backupOwner);
                    if (segments == null) {
                        segments = new HashSet<Integer>();
                        backupOwnerSegments.put(backupOwner, segments);
                    }
                    segments.add(i);
                }
            }
            int backupOwnerSize = backupOwnerSegments.size();
            if (backupOwnerSize > 0) {
                ArrayList<CompletableFuture<Map<Address, Response>>> futures = new ArrayList<CompletableFuture<Map<Address, Response>>>(backupOwnerSize);
                RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
                command.setFlags(new Flag[]{Flag.SKIP_LOCKING});
                command.setForwarded(true);
                for (Map.Entry entry : backupOwnerSegments.entrySet()) {
                    Set segments = (Set)entry.getValue();
                    ReadOnlySegmentAwareSet segmentKeysSet = new ReadOnlySegmentAwareSet(originalMap, ch, segments);
                    if (segmentKeysSet.isEmpty()) continue;
                    WriteOnlyManyCommand copy = new WriteOnlyManyCommand(command);
                    copy.setKeys(segmentKeysSet);
                    CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(entry.getKey()), copy, options);
                    futures.add(future);
                }
                command.setForwarded(false);
                if (futures.size() > 0) {
                    CompletableFuture[] futuresArray = new CompletableFuture[futures.size()];
                    CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(futuresArray));
                    try {
                        completableFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (ExecutionException e) {
                        throw new RemoteException("Exception while processing put on backup owner", e.getCause());
                    }
                    catch (TimeoutException e) {
                        throw new CacheException(e);
                    }
                }
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        Set originalMap = command.getKeys();
        ConsistentHash ch = this.dm.getConsistentHash();
        Address localAddress = this.rpcManager.getAddress();
        if (ctx.isOriginLocal()) {
            ArrayList<Object> futures = new ArrayList<Object>(this.rpcManager.getMembers().size() - 1);
            RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
            for (Address member : this.rpcManager.getMembers()) {
                ReadOnlySegmentAwareSet readOnlySegmentAwareSet;
                Object segments;
                if (member.equals(this.rpcManager.getAddress()) || (segments = ch.getPrimarySegmentsForOwner(member)).isEmpty() || (readOnlySegmentAwareSet = new ReadOnlySegmentAwareSet(originalMap, ch, (Set<Integer>)segments)).isEmpty()) continue;
                ReadWriteManyCommand readWriteManyCommand = new ReadWriteManyCommand(command);
                readWriteManyCommand.setKeys(readOnlySegmentAwareSet);
                CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(member), readWriteManyCommand, options);
                futures.add(future);
            }
            if (futures.size() > 0) {
                CompletableFuture[] futuresArray = new CompletableFuture[futures.size()];
                CompletableFuture<Void> compFuture = CompletableFuture.allOf(futures.toArray(futuresArray));
                try {
                    compFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                    for (CompletableFuture completableFuture : futures) {
                        Map map = (Map)completableFuture.get();
                        for (Response response : map.values()) {
                            if (!response.isSuccessful()) continue;
                            SuccessfulResponse success = (SuccessfulResponse)response;
                            command.addAllRemoteReturns((List)success.getResponseValue());
                        }
                    }
                }
                catch (ExecutionException e) {
                    throw new RemoteException("Exception while processing put on primary owner", e.getCause());
                }
                catch (TimeoutException e) {
                    throw new CacheException(e);
                }
            }
        }
        if (!command.isForwarded() && ch.getNumOwners() > 1) {
            HashMap backupOwnerSegments = new HashMap();
            int segmentCount = ch.getNumSegments();
            for (int i = 0; i < segmentCount; ++i) {
                Iterator<Address> iter = ch.locateOwnersForSegment(i).iterator();
                if (!iter.next().equals(localAddress)) continue;
                while (iter.hasNext()) {
                    void var11_21;
                    Address backupOwner = iter.next();
                    Set set = (Set)backupOwnerSegments.get(backupOwner);
                    if (set == null) {
                        HashSet hashSet = new HashSet();
                        backupOwnerSegments.put(backupOwner, hashSet);
                    }
                    var11_21.add(i);
                }
            }
            int backupOwnerSize = backupOwnerSegments.size();
            if (backupOwnerSize > 0) {
                ArrayList<CompletableFuture<Map<Address, Response>>> futures = new ArrayList<CompletableFuture<Map<Address, Response>>>(backupOwnerSize);
                RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
                command.setFlags(Flag.SKIP_LOCKING);
                command.setForwarded(true);
                for (Map.Entry entry : backupOwnerSegments.entrySet()) {
                    Set segments = (Set)entry.getValue();
                    ReadOnlySegmentAwareSet segmentKeysSet = new ReadOnlySegmentAwareSet(originalMap, ch, segments);
                    if (segmentKeysSet.isEmpty()) continue;
                    ReadWriteManyCommand copy = new ReadWriteManyCommand(command);
                    copy.setKeys(segmentKeysSet);
                    CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(entry.getKey()), copy, options);
                    futures.add(future);
                }
                command.setForwarded(false);
                if (futures.size() > 0) {
                    CompletableFuture[] completableFutureArray = new CompletableFuture[futures.size()];
                    CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(completableFutureArray));
                    try {
                        completableFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (ExecutionException e) {
                        throw new RemoteException("Exception while processing put on backup owner", e.getCause());
                    }
                    catch (TimeoutException e) {
                        throw new CacheException(e);
                    }
                }
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        Map originalMap = command.getEntries();
        ConsistentHash ch = this.dm.getConsistentHash();
        Address localAddress = this.rpcManager.getAddress();
        if (ctx.isOriginLocal()) {
            ArrayList<Object> futures = new ArrayList<Object>(this.rpcManager.getMembers().size() - 1);
            RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
            for (Address member : this.rpcManager.getMembers()) {
                ReadOnlySegmentAwareMap readOnlySegmentAwareMap;
                Object segments;
                if (member.equals(this.rpcManager.getAddress()) || (segments = ch.getPrimarySegmentsForOwner(member)).isEmpty() || (readOnlySegmentAwareMap = new ReadOnlySegmentAwareMap(originalMap, ch, (Set<Integer>)segments)).isEmpty()) continue;
                ReadWriteManyEntriesCommand readWriteManyEntriesCommand = new ReadWriteManyEntriesCommand(command);
                readWriteManyEntriesCommand.setEntries(readOnlySegmentAwareMap);
                CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(member), readWriteManyEntriesCommand, options);
                futures.add(future);
            }
            if (futures.size() > 0) {
                CompletableFuture[] futuresArray = new CompletableFuture[futures.size()];
                CompletableFuture<Void> compFuture = CompletableFuture.allOf(futures.toArray(futuresArray));
                try {
                    compFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                    for (CompletableFuture completableFuture : futures) {
                        Map map = (Map)completableFuture.get();
                        for (Response response : map.values()) {
                            if (!response.isSuccessful()) continue;
                            SuccessfulResponse success = (SuccessfulResponse)response;
                            command.addAllRemoteReturns((List)success.getResponseValue());
                        }
                    }
                }
                catch (ExecutionException e) {
                    throw new RemoteException("Exception while processing put on primary owner", e.getCause());
                }
                catch (TimeoutException e) {
                    throw new CacheException(e);
                }
            }
        }
        if (!command.isForwarded() && ch.getNumOwners() > 1) {
            HashMap backupOwnerSegments = new HashMap();
            int segmentCount = ch.getNumSegments();
            for (int i = 0; i < segmentCount; ++i) {
                Iterator<Address> iter = ch.locateOwnersForSegment(i).iterator();
                if (!iter.next().equals(localAddress)) continue;
                while (iter.hasNext()) {
                    void var11_21;
                    Address backupOwner = iter.next();
                    Set set = (Set)backupOwnerSegments.get(backupOwner);
                    if (set == null) {
                        HashSet hashSet = new HashSet();
                        backupOwnerSegments.put(backupOwner, hashSet);
                    }
                    var11_21.add(i);
                }
            }
            int backupOwnerSize = backupOwnerSegments.size();
            if (backupOwnerSize > 0) {
                ArrayList<CompletableFuture<Map<Address, Response>>> futures = new ArrayList<CompletableFuture<Map<Address, Response>>>(backupOwnerSize);
                RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
                command.setFlags(Flag.SKIP_LOCKING);
                command.setForwarded(true);
                for (Map.Entry entry : backupOwnerSegments.entrySet()) {
                    Set segments = (Set)entry.getValue();
                    ReadOnlySegmentAwareMap segmentEntriesMap = new ReadOnlySegmentAwareMap(originalMap, ch, segments);
                    if (segmentEntriesMap.isEmpty()) continue;
                    ReadWriteManyEntriesCommand copy = new ReadWriteManyEntriesCommand(command);
                    copy.setEntries(segmentEntriesMap);
                    CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(entry.getKey()), copy, options);
                    futures.add(future);
                }
                command.setForwarded(false);
                if (futures.size() > 0) {
                    CompletableFuture[] completableFutureArray = new CompletableFuture[futures.size()];
                    CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(completableFutureArray));
                    try {
                        completableFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (ExecutionException e) {
                        throw new RemoteException("Exception while processing put on backup owner", e.getCause());
                    }
                    catch (TimeoutException e) {
                        throw new CacheException(e);
                    }
                }
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    protected void remoteGetBeforeWrite(InvocationContext ctx, WriteCommand command, Object key) throws Throwable {
        CacheEntry entry = ctx.lookupEntry(key);
        if (!this.valueIsMissing(entry)) {
            return;
        }
        InternalCacheEntry remoteEntry = null;
        if (this.writeNeedsRemoteValue(ctx, command, key)) {
            InternalCacheEntry localEntry;
            if (!this.isValueAvailableLocally(this.dm.getReadConsistentHash(), key)) {
                if (trace) {
                    log.tracef("Doing a remote get for key %s", key);
                }
                if ((remoteEntry = this.retrieveFromRemoteSource(key, ctx, false, command, false)) != null) {
                    this.wrapInternalCacheEntry(remoteEntry, ctx, key, false, command);
                }
            }
            if (remoteEntry == null && (localEntry = this.fetchValueLocallyIfAvailable(this.dm.getReadConsistentHash(), key)) != null) {
                this.wrapInternalCacheEntry(localEntry, ctx, key, false, command);
            }
        }
    }

    @Override
    protected boolean writeNeedsRemoteValue(InvocationContext ctx, WriteCommand command, Object key) {
        if (command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            return false;
        }
        if (ctx.isOriginLocal() && command.hasFlag(Flag.SKIP_REMOTE_LOOKUP)) {
            return false;
        }
        return !ctx.isOriginLocal() && command.alwaysReadsExistingValues();
    }
}

