/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.termop.object;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import org.infinispan.commons.util.ByRef;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.termop.BaseTerminalOperation;

public class FlatMapIteratorOperation<K, V>
extends BaseTerminalOperation
implements KeyTrackingTerminalOperation<K, V, Collection<V>> {
    private final int batchSize;

    public FlatMapIteratorOperation(Iterable<IntermediateOperation> intermediateOperations, Supplier<Stream<CacheEntry>> supplier, int batchSize) {
        super(intermediateOperations, supplier);
        this.batchSize = batchSize;
    }

    @Override
    public boolean lostSegment(boolean stopIfLost) {
        return true;
    }

    @Override
    public List<V> performOperation(KeyTrackingTerminalOperation.IntermediateCollector<Collection<V>> response) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<CacheEntry<K, Collection<V>>> performOperationRehashAware(KeyTrackingTerminalOperation.IntermediateCollector<Collection<CacheEntry<K, Collection<V>>>> response) {
        Object stream = ((BaseStream)this.supplier.get()).sequential();
        ArrayList<CacheEntry<K, Collection<V>>> collectedValues = new ArrayList<CacheEntry<K, Collection<V>>>(this.batchSize);
        ByRef currentList = new ByRef(new ArrayList());
        ByRef<Object> currentKey = new ByRef<Object>(null);
        stream = ((Stream)stream).peek(e -> {
            List list2 = (List)currentList.get();
            if (!list2.isEmpty()) {
                collectedValues.add(new ImmortalCacheEntry(currentKey.get(), list2));
                if (collectedValues.size() >= this.batchSize) {
                    response.sendDataResonse(collectedValues);
                    collectedValues.clear();
                    list2.clear();
                } else {
                    currentList.set(new ArrayList(list2.size()));
                }
            }
            currentKey.set(e.getKey());
        });
        for (IntermediateOperation intermediateOperation : this.intermediateOperations) {
            stream = intermediateOperation.perform(stream);
        }
        Stream convertedStream = (Stream)stream;
        convertedStream.forEach(v -> ((List)currentList.get()).add(v));
        List lastList = currentList.get();
        if (lastList != null && !lastList.isEmpty()) {
            collectedValues.add(new ImmortalCacheEntry(currentKey.get(), lastList));
        }
        return collectedValues;
    }

    public int getBatchSize() {
        return this.batchSize;
    }
}

