/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Map;
import org.infinispan.commands.CancelCommand;
import org.infinispan.commands.CreateCacheCommand;
import org.infinispan.commands.RemoveCacheCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commands.read.DistributedExecuteCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.MapCombineCommand;
import org.infinispan.commands.read.ReduceCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.ClusteredGetAllCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderCommitCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderNonVersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderRollbackCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderVersionedCommitCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderVersionedPrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.iteration.impl.EntryRequestCommand;
import org.infinispan.iteration.impl.EntryResponseCommand;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.statetransfer.StateResponseCommand;
import org.infinispan.stream.impl.StreamRequestCommand;
import org.infinispan.stream.impl.StreamResponseCommand;
import org.infinispan.stream.impl.StreamSegmentResponseCommand;
import org.infinispan.topology.CacheTopologyControlCommand;
import org.infinispan.xsite.SingleXSiteRpcCommand;
import org.infinispan.xsite.XSiteAdminCommand;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;
import org.infinispan.xsite.statetransfer.XSiteStateTransferControlCommand;

@Scope(value=Scopes.GLOBAL)
public class RemoteCommandsFactory {
    EmbeddedCacheManager cacheManager;
    GlobalComponentRegistry registry;
    Map<Byte, ModuleCommandFactory> commandFactories;

    @Inject
    public void inject(EmbeddedCacheManager cacheManager, GlobalComponentRegistry registry, @ComponentName(value="org.infinispan.modules.command.factories") Map<Byte, ModuleCommandFactory> commandFactories) {
        this.cacheManager = cacheManager;
        this.registry = registry;
        this.commandFactories = commandFactories;
    }

    public ReplicableCommand fromStream(byte id, Object[] parameters, byte type) {
        ReplicableCommand command;
        block25: {
            block24: {
                if (type != 0) break block24;
                switch (id) {
                    case 8: {
                        command = new PutKeyValueCommand();
                        break block25;
                    }
                    case 9: {
                        command = new PutMapCommand();
                        break block25;
                    }
                    case 10: {
                        command = new RemoveCommand();
                        break block25;
                    }
                    case 11: {
                        command = new ReplaceCommand();
                        break block25;
                    }
                    case 4: {
                        command = new GetKeyValueCommand();
                        break block25;
                    }
                    case 5: {
                        command = new ClearCommand();
                        break block25;
                    }
                    case 6: {
                        command = new InvalidateCommand();
                        break block25;
                    }
                    case 7: {
                        command = new InvalidateL1Command();
                        break block25;
                    }
                    case 25: {
                        command = new ApplyDeltaCommand();
                        break block25;
                    }
                    case 17: {
                        command = new CacheTopologyControlCommand();
                        break block25;
                    }
                    case 43: {
                        command = new GetKeysInGroupCommand();
                        break block25;
                    }
                    case 45: {
                        command = new GetCacheEntryCommand();
                        break block25;
                    }
                    case 50: {
                        command = new ReadWriteKeyCommand();
                        break block25;
                    }
                    case 51: {
                        command = new ReadWriteKeyValueCommand();
                        break block25;
                    }
                    case 52: {
                        command = new ReadWriteManyCommand();
                        break block25;
                    }
                    case 53: {
                        command = new ReadWriteManyEntriesCommand();
                        break block25;
                    }
                    case 54: {
                        command = new WriteOnlyKeyCommand();
                        break block25;
                    }
                    case 55: {
                        command = new WriteOnlyKeyValueCommand();
                        break block25;
                    }
                    case 56: {
                        command = new WriteOnlyManyCommand();
                        break block25;
                    }
                    case 57: {
                        command = new WriteOnlyManyEntriesCommand();
                        break block25;
                    }
                    case 58: {
                        command = new RemoveExpiredCommand();
                        break block25;
                    }
                    default: {
                        throw new CacheException("Unknown command id " + id + "!");
                    }
                }
            }
            ModuleCommandFactory mcf = this.commandFactories.get(id);
            if (mcf != null) {
                return mcf.fromStream(id, parameters);
            }
            throw new CacheException("Unknown command id " + id + "!");
        }
        command.setParameters(id, parameters);
        return command;
    }

    public CacheRpcCommand fromStream(byte id, Object[] parameters, byte type, String cacheName) {
        CacheRpcCommand command;
        block40: {
            block39: {
                if (type != 0) break block39;
                switch (id) {
                    case 3: {
                        command = new LockControlCommand(cacheName);
                        break block40;
                    }
                    case 12: {
                        command = new PrepareCommand(cacheName);
                        break block40;
                    }
                    case 26: {
                        command = new VersionedPrepareCommand(cacheName);
                        break block40;
                    }
                    case 38: {
                        command = new TotalOrderNonVersionedPrepareCommand(cacheName);
                        break block40;
                    }
                    case 39: {
                        command = new TotalOrderVersionedPrepareCommand(cacheName);
                        break block40;
                    }
                    case 14: {
                        command = new CommitCommand(cacheName);
                        break block40;
                    }
                    case 27: {
                        command = new VersionedCommitCommand(cacheName);
                        break block40;
                    }
                    case 35: {
                        command = new TotalOrderCommitCommand(cacheName);
                        break block40;
                    }
                    case 36: {
                        command = new TotalOrderVersionedCommitCommand(cacheName);
                        break block40;
                    }
                    case 13: {
                        command = new RollbackCommand(cacheName);
                        break block40;
                    }
                    case 37: {
                        command = new TotalOrderRollbackCommand(cacheName);
                        break block40;
                    }
                    case 2: {
                        command = new MultipleRpcCommand(cacheName);
                        break block40;
                    }
                    case 1: {
                        command = new SingleRpcCommand(cacheName);
                        break block40;
                    }
                    case 16: {
                        command = new ClusteredGetCommand(cacheName);
                        break block40;
                    }
                    case 15: {
                        command = new StateRequestCommand(cacheName);
                        break block40;
                    }
                    case 20: {
                        command = new StateResponseCommand(cacheName);
                        break block40;
                    }
                    case 18: {
                        ComponentRegistry namedCacheRegistry = this.registry.getNamedComponentRegistry(cacheName);
                        command = new RemoveCacheCommand(cacheName, this.cacheManager, this.registry, namedCacheRegistry.getComponent(PersistenceManager.class), namedCacheRegistry.getComponent(CacheJmxRegistration.class));
                        break block40;
                    }
                    case 22: {
                        command = new TxCompletionNotificationCommand(cacheName);
                        break block40;
                    }
                    case 21: {
                        command = new GetInDoubtTransactionsCommand(cacheName);
                        break block40;
                    }
                    case 30: {
                        command = new MapCombineCommand(cacheName);
                        break block40;
                    }
                    case 31: {
                        command = new ReduceCommand(cacheName);
                        break block40;
                    }
                    case 19: {
                        command = new DistributedExecuteCommand(cacheName);
                        break block40;
                    }
                    case 23: {
                        command = new GetInDoubtTxInfoCommand(cacheName);
                        break block40;
                    }
                    case 24: {
                        command = new CompleteTransactionCommand(cacheName);
                        break block40;
                    }
                    case 29: {
                        command = new CreateCacheCommand(cacheName);
                        break block40;
                    }
                    case 32: {
                        command = new XSiteAdminCommand(cacheName);
                        break block40;
                    }
                    case 34: {
                        command = new CancelCommand(cacheName);
                        break block40;
                    }
                    case 28: {
                        command = new XSiteStateTransferControlCommand(cacheName);
                        break block40;
                    }
                    case 33: {
                        command = new XSiteStatePushCommand(cacheName);
                        break block40;
                    }
                    case 40: {
                        command = new SingleXSiteRpcCommand(cacheName);
                        break block40;
                    }
                    case 41: {
                        command = new EntryRequestCommand(cacheName);
                        break block40;
                    }
                    case 42: {
                        command = new EntryResponseCommand(cacheName);
                        break block40;
                    }
                    case 46: {
                        command = new ClusteredGetAllCommand(cacheName);
                        break block40;
                    }
                    case 47: {
                        command = new StreamRequestCommand(cacheName);
                        break block40;
                    }
                    case 49: {
                        command = new StreamSegmentResponseCommand(cacheName);
                        break block40;
                    }
                    case 48: {
                        command = new StreamResponseCommand(cacheName);
                        break block40;
                    }
                    default: {
                        throw new CacheException("Unknown command id " + id + "!");
                    }
                }
            }
            ModuleCommandFactory mcf = this.commandFactories.get(id);
            if (mcf != null) {
                return mcf.fromStream(id, parameters, cacheName);
            }
            throw new CacheException("Unknown command id " + id + "!");
        }
        command.setParameters(id, parameters);
        return command;
    }
}

