/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalSecurityConfiguration;
import org.infinispan.configuration.global.GlobalSecurityConfigurationChildBuilder;

public class GlobalSecurityConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements GlobalSecurityConfigurationChildBuilder,
Builder<GlobalSecurityConfiguration> {
    private final GlobalAuthorizationConfigurationBuilder authorizationBuilder = new GlobalAuthorizationConfigurationBuilder(this);
    private long securityCacheTimeout = 30000L;

    public GlobalSecurityConfigurationBuilder(GlobalConfigurationBuilder builder) {
        super(builder);
    }

    @Override
    public GlobalAuthorizationConfigurationBuilder authorization() {
        return this.authorizationBuilder;
    }

    @Override
    public GlobalSecurityConfigurationBuilder securityCacheTimeout(long securityCacheTimeout) {
        this.securityCacheTimeout = securityCacheTimeout;
        return this;
    }

    @Override
    public void validate() {
        this.authorizationBuilder.validate();
    }

    @Override
    public GlobalSecurityConfiguration create() {
        return new GlobalSecurityConfiguration(this.authorizationBuilder.create(), this.securityCacheTimeout);
    }

    public GlobalSecurityConfigurationBuilder read(GlobalSecurityConfiguration template) {
        this.authorizationBuilder.read(template.authorization());
        return this;
    }
}

