/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.atomic.impl.AtomicHashMap;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.functional.ParamsCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.api.functional.Param;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.DeltaAwareCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.JmxStatsCommandInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.marshall.core.MarshalledEntryImpl;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="CacheStore", description="Component that handles storing of entries to a CacheStore from memory.")
public class CacheWriterInterceptor
extends JmxStatsCommandInterceptor {
    PersistenceConfiguration loaderConfig = null;
    final AtomicLong cacheStores = new AtomicLong(0L);
    protected PersistenceManager persistenceManager;
    private InternalEntryFactory entryFactory;
    private TransactionManager transactionManager;
    private StreamingMarshaller marshaller;
    protected volatile boolean enabled = true;
    private static final Log log = LogFactory.getLog(CacheWriterInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    protected void init(PersistenceManager pm, InternalEntryFactory entryFactory, TransactionManager transactionManager, @ComponentName(value="org.infinispan.marshaller.cache") StreamingMarshaller marshaller) {
        this.persistenceManager = pm;
        this.entryFactory = entryFactory;
        this.transactionManager = transactionManager;
        this.marshaller = marshaller;
    }

    @Start(priority=15)
    protected void start() {
        this.setStatisticsEnabled(this.cacheConfiguration.jmxStatistics().enabled());
        this.loaderConfig = this.cacheConfiguration.persistence();
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.isStoreEnabled()) {
            this.commitCommand(ctx);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (this.isStoreEnabled() && command.isOnePhaseCommit()) {
            this.commitCommand(ctx);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitCommand(TxInvocationContext ctx) throws Throwable {
        if (!((AbstractCacheTransaction)ctx.getCacheTransaction()).getAllModifications().isEmpty()) {
            GlobalTransaction tx = ctx.getGlobalTransaction();
            if (this.getLog().isTraceEnabled()) {
                this.getLog().tracef("Calling loader.commit() for transaction %s", (Object)tx);
            }
            Transaction xaTx = null;
            try {
                xaTx = this.suspendRunningTx(ctx);
                this.store(ctx);
            }
            finally {
                this.resumeRunningTx(xaTx);
            }
        } else if (this.getLog().isTraceEnabled()) {
            this.getLog().trace("Commit called with no modifications; ignoring.");
        }
    }

    private void resumeRunningTx(Transaction xaTx) throws InvalidTransactionException, SystemException {
        if (this.transactionManager != null && xaTx != null) {
            this.transactionManager.resume(xaTx);
        }
    }

    private Transaction suspendRunningTx(TxInvocationContext ctx) throws SystemException {
        Transaction xaTx = null;
        if (this.transactionManager != null && (xaTx = this.transactionManager.suspend()) != null && !ctx.isOriginLocal()) {
            throw new IllegalStateException("It is only possible to be in the context of an JRA transaction in the local node.");
        }
        return xaTx;
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (!this.isStoreEnabled(command) || ctx.isInTxScope() || !command.isSuccessful()) {
            return retval;
        }
        if (!this.isProperWriter(ctx, command, command.getKey())) {
            return retval;
        }
        Object key = command.getKey();
        boolean resp = this.persistenceManager.deleteFromAllStores(key, PersistenceManager.AccessMode.BOTH);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Removed entry under key %s and got response %s from CacheStore", key, (Object)resp);
        }
        return retval;
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (this.isStoreEnabled(command) && !ctx.isInTxScope()) {
            this.persistenceManager.clearAllStores(ctx.isOriginLocal() ? PersistenceManager.AccessMode.BOTH : PersistenceManager.AccessMode.PRIVATE);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (!this.isStoreEnabled(command) || ctx.isInTxScope() || !command.isSuccessful()) {
            return returnValue;
        }
        if (!this.isProperWriter(ctx, command, command.getKey())) {
            return returnValue;
        }
        Object key = command.getKey();
        this.storeEntry(ctx, key, command);
        if (this.getStatisticsEnabled()) {
            this.cacheStores.incrementAndGet();
        }
        return returnValue;
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (!this.isStoreEnabled(command) || ctx.isInTxScope() || !command.isSuccessful()) {
            return returnValue;
        }
        if (!this.isProperWriter(ctx, command, command.getKey())) {
            return returnValue;
        }
        Object key = command.getKey();
        this.storeEntry(ctx, key, command);
        if (this.getStatisticsEnabled()) {
            this.cacheStores.incrementAndGet();
        }
        return returnValue;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (!this.isStoreEnabled(command) || ctx.isInTxScope()) {
            return returnValue;
        }
        Map<Object, Object> map = command.getMap();
        for (Object key : map.keySet()) {
            if (!this.isProperWriter(ctx, command, key)) continue;
            this.storeEntry(ctx, key, command);
        }
        if (this.getStatisticsEnabled()) {
            this.cacheStores.getAndAdd(map.size());
        }
        return returnValue;
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.visitWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.visitWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        return this.visitWriteCommand(ctx, command);
    }

    /*
     * Unable to fully structure code
     */
    private <T extends DataWriteCommand & ParamsCommand> Object visitWriteCommand(InvocationContext ctx, T command) throws Throwable {
        retval = this.invokeNextInterceptor(ctx, command);
        if (!this.isStoreEnabled(command) || ctx.isInTxScope() || !command.isSuccessful()) {
            return retval;
        }
        if (!this.isProperWriter(ctx, command, command.getKey())) {
            return retval;
        }
        persistMode = ((ParamsCommand)command).getParams().get(1);
        switch (1.$SwitchMap$org$infinispan$commons$api$functional$Param$PersistenceMode[((Param.PersistenceMode)persistMode.get()).ordinal()]) {
            case 1: {
                key = command.getKey();
                entry = ctx.lookupEntry(key);
                if (entry == null) ** GOTO lbl19
                if (!entry.isRemoved()) ** GOTO lbl17
                resp = this.persistenceManager.deleteFromAllStores(key, PersistenceManager.AccessMode.BOTH);
                if (this.getLog().isTraceEnabled()) {
                    this.getLog().tracef("Removed entry under key %s and got response %s from CacheStore", key, (Object)resp);
                }
                ** GOTO lbl19
lbl17:
                // 1 sources

                if (entry.isChanged()) {
                    this.storeEntry(ctx, key, command);
                }
            }
lbl19:
            // 6 sources

            case 2: {
                CacheWriterInterceptor.log.trace("Skipping cache store since persistence mode parameter is SKIP");
            }
        }
        return retval;
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (!this.isStoreEnabled(command) || ctx.isInTxScope()) {
            return returnValue;
        }
        Param persistMode = command.getParams().get(1);
        switch ((Param.PersistenceMode)persistMode.get()) {
            case PERSIST: {
                Map map = command.getEntries();
                int storedCount = 0;
                for (Object key : map.keySet()) {
                    CacheEntry entry = ctx.lookupEntry(key);
                    if (entry == null) continue;
                    if (entry.isRemoved()) {
                        boolean resp = this.persistenceManager.deleteFromAllStores(key, PersistenceManager.AccessMode.BOTH);
                        if (!this.getLog().isTraceEnabled()) continue;
                        this.getLog().tracef("Removed entry under key %s and got response %s from CacheStore", key, (Object)resp);
                        continue;
                    }
                    if (!entry.isChanged() || !this.isProperWriter(ctx, command, key)) continue;
                    this.storeEntry(ctx, key, command);
                    ++storedCount;
                }
                if (this.getStatisticsEnabled()) {
                    this.cacheStores.getAndAdd(storedCount);
                }
            }
            case SKIP: {
                log.trace("Skipping cache store since persistence mode parameter is SKIP");
            }
        }
        return returnValue;
    }

    protected final void store(TxInvocationContext ctx) throws Throwable {
        List<WriteCommand> modifications = ((AbstractCacheTransaction)ctx.getCacheTransaction()).getAllModifications();
        if (modifications.isEmpty()) {
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace("Transaction has not logged any modifications!");
            }
            return;
        }
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Cache loader modification list: %s", (Object)modifications);
        }
        Updater modsBuilder = new Updater(this.getStatisticsEnabled());
        for (WriteCommand cacheCommand : modifications) {
            if (!this.isStoreEnabled(cacheCommand)) continue;
            cacheCommand.acceptVisitor(ctx, modsBuilder);
        }
        if (this.getStatisticsEnabled() && modsBuilder.putCount > 0) {
            this.cacheStores.getAndAdd(modsBuilder.putCount);
        }
    }

    protected boolean isStoreEnabled() {
        return this.enabled;
    }

    protected boolean isStoreEnabled(FlagAffectedCommand command) {
        if (!this.isStoreEnabled()) {
            return false;
        }
        if (command.hasFlag(Flag.SKIP_CACHE_STORE)) {
            log.trace("Skipping cache store since the call contain a skip cache store flag");
            return false;
        }
        return true;
    }

    protected boolean isProperWriter(InvocationContext ctx, FlagAffectedCommand command, Object key) {
        return true;
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        this.cacheStores.set(0L);
    }

    @ManagedAttribute(description="Number of writes to the store", displayName="Number of writes to the store", measurementType=MeasurementType.TRENDSUP)
    public long getWritesToTheStores() {
        return this.cacheStores.get();
    }

    void storeEntry(InvocationContext ctx, Object key, FlagAffectedCommand command) {
        InternalCacheValue sv = this.getStoredValue(key, ctx);
        this.persistenceManager.writeToAllStores(new MarshalledEntryImpl(key, sv.getValue(), PersistenceUtil.internalMetadata(sv), this.marshaller), this.skipSharedStores(ctx, key, command) ? PersistenceManager.AccessMode.PRIVATE : PersistenceManager.AccessMode.BOTH);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Stored entry %s under key %s", (Object)sv, key);
        }
    }

    protected boolean skipSharedStores(InvocationContext ctx, Object key, FlagAffectedCommand command) {
        return !ctx.isOriginLocal() || command.hasFlag(Flag.SKIP_SHARED_CACHE_STORE);
    }

    InternalCacheValue getStoredValue(Object key, InvocationContext ctx) {
        EntryVersion version;
        EntryVersionsMap updatedVersions;
        CacheEntry entry = ctx.lookupEntry(key);
        if (entry instanceof InternalCacheEntry) {
            return ((InternalCacheEntry)entry).toInternalCacheValue();
        }
        if (ctx.isInTxScope() && (updatedVersions = ((AbstractCacheTransaction)((TxInvocationContext)ctx).getCacheTransaction()).getUpdatedEntryVersions()) != null && (version = (EntryVersion)updatedVersions.get(entry.getKey())) != null) {
            Metadata metadata = entry.getMetadata();
            if (metadata == null) {
                metadata = new EmbeddedMetadata.Builder().lifespan(entry.getLifespan()).maxIdle(entry.getMaxIdle()).version(version).build();
                return this.entryFactory.create(entry.getKey(), entry.getValue(), metadata).toInternalCacheValue();
            }
            metadata = metadata.builder().version(version).build();
            return this.entryFactory.create(entry.getKey(), entry.getValue(), metadata).toInternalCacheValue();
        }
        return this.entryFactory.create(entry).toInternalCacheValue();
    }

    public void disableInterceptor() {
        this.enabled = false;
    }

    public class Updater
    extends AbstractVisitor {
        protected final boolean generateStatistics;
        int putCount;

        public Updater(boolean generateStatistics) {
            this.generateStatistics = generateStatistics;
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.visitSingleStore(ctx, command, command.getKey());
        }

        @Override
        public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
            if (CacheWriterInterceptor.this.isProperWriter(ctx, command, command.getKey())) {
                InternalCacheEntry ice;
                CacheEntry entry;
                if (this.generateStatistics) {
                    ++this.putCount;
                }
                if ((entry = ctx.lookupEntry(command.getKey())) instanceof InternalCacheEntry) {
                    ice = (InternalCacheEntry)entry;
                } else if (entry instanceof DeltaAwareCacheEntry) {
                    AtomicHashMap<?, ?> uncommittedChanges = ((DeltaAwareCacheEntry)entry).getUncommittedChages();
                    ice = CacheWriterInterceptor.this.entryFactory.create(entry.getKey(), uncommittedChanges, entry.getMetadata(), entry.getLifespan(), entry.getMaxIdle());
                } else {
                    ice = CacheWriterInterceptor.this.entryFactory.create(entry);
                }
                MarshalledEntryImpl marshalledEntry = new MarshalledEntryImpl(ice.getKey(), ice.getValue(), PersistenceUtil.internalMetadata(ice), CacheWriterInterceptor.this.marshaller);
                CacheWriterInterceptor.this.persistenceManager.writeToAllStores(marshalledEntry, command.hasFlag(Flag.SKIP_SHARED_CACHE_STORE) ? PersistenceManager.AccessMode.PRIVATE : PersistenceManager.AccessMode.BOTH);
            }
            return null;
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            return this.visitSingleStore(ctx, command, command.getKey());
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            Map<Object, Object> map = command.getMap();
            for (Object key : map.keySet()) {
                this.visitSingleStore(ctx, command, key);
            }
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            Object key = command.getKey();
            if (CacheWriterInterceptor.this.isProperWriter(ctx, command, key)) {
                CacheWriterInterceptor.this.persistenceManager.deleteFromAllStores(key, PersistenceManager.AccessMode.BOTH);
            }
            return null;
        }

        @Override
        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            CacheWriterInterceptor.this.persistenceManager.clearAllStores(ctx.isOriginLocal() ? PersistenceManager.AccessMode.PRIVATE : PersistenceManager.AccessMode.BOTH);
            return null;
        }

        protected Object visitSingleStore(InvocationContext ctx, FlagAffectedCommand command, Object key) throws Throwable {
            if (CacheWriterInterceptor.this.isProperWriter(ctx, command, key)) {
                if (this.generateStatistics) {
                    ++this.putCount;
                }
                InternalCacheValue sv = CacheWriterInterceptor.this.getStoredValue(key, ctx);
                MarshalledEntryImpl me = new MarshalledEntryImpl(key, sv.getValue(), PersistenceUtil.internalMetadata(sv), CacheWriterInterceptor.this.marshaller);
                CacheWriterInterceptor.this.persistenceManager.writeToAllStores(me, command.hasFlag(Flag.SKIP_SHARED_CACHE_STORE) ? PersistenceManager.AccessMode.PRIVATE : PersistenceManager.AccessMode.BOTH);
            }
            return null;
        }
    }
}

